/*
*   copy letter
*/

#include <stdio.h>
#include <ctype.h>
#include "mail.h"

extern char *Mailpgm, *thissys, *rmtmsg, from[], *forwmsg, *my_name;
extern int ttyout, flgp;
extern FILE *tmpf;

copylet(n, f, type, prepnd)
FILE *f;
char *prepnd;
{
   register int fromon, pgflg;
   register char *p;
   char lbuf[1024];
   register int lines;
   extern int bfrlns, lpp;

   if (prepnd == NULL)
      prepnd = "";
   lines = let[n].llns;
   if (fseek(tmpf, let[n].adr, 0) < 0)
   {
      fprintf(stderr, "%s: Cannot seek to %d line letter %d at %ld\n", Mailpgm, lines, n, let[n].adr);
      return FALSE;

   }
   pgflg = 0;
   bfrlns = ((lpp-23) < 0) ? 0 : (lpp-23);
   if (lines >= 23 && f == stdout && type==ORDINARY && ttyout && !flgp)
   {
      pgflg = 1;
      pgflsh(0);      /* scratch anything in buffer */

   }
   fgets(lbuf, sizeof(lbuf), tmpf);

   if (type == ORDINARY && f == stdout)
      fradd(lbuf);
   lbuf[strlen(lbuf)-1] = 0;

   /* Sanity test -- first line must be a `[>]From ...' line */
   if(lbuf[0] == '>') strcpy(lbuf, &lbuf[1]);
   if (!equaln(lbuf, from, 5))
   {
      fprintf(stderr, "\nINTERNAL ERROR! `From' expected, `%s' found\n\tletter %d, seek at %ld, %d lines\n", lbuf,
          n, let[n].adr, lines);
      return FALSE;

   }

   ascck(lbuf);
   if (type != ZAP && type != DEAD)
   {
      if (pgflg)
      {
         if (*prepnd)
            pgputs(prepnd);
         pgputs(lbuf);

      }
      else 
      {
         if (*prepnd)
            fputs(prepnd,f);
         fputs(lbuf,f);

      }

   }
   if (type == REMOTE)
      fprintf(f, rmtmsg, thissys);
   else if (type == FORWARD)
      fprintf(f, forwmsg, my_name);
   else if (type == ORDINARY)
   {
      if (pgflg)
         pgputs("\n");
      else
         fputc('\n',f);

   }
   fromon = 1;
   lbuf[sizeof(lbuf)-2] = 0;
   while ( --lines > 0)
   {
      if (fgets(lbuf, sizeof(lbuf), tmpf) == NULL)
         break;
      ascck(lbuf);
      if (lines == let[n].llns - 1 && type == DEAD)
         continue;
      /* save the last ">From ... " line if it exists. */
      if (*(p=lbuf) == '>')
         p++;
      if (*p != 'F')
         p = NULL;
      if (fromon && p && type == ORDINARY && f == stdout && Isfrom(p))
         fradd(lbuf);
      else
         fromon = 0;
      if (pgflg)
      {
         if (*prepnd)
            pgputs(prepnd);
         if (pgputs(lbuf) <= 0)
         {
            pgflsh(0);
            return TRUE;

         }

      }
      else 
      {
         if (*prepnd)
            fputs(prepnd, f);
         fputs(lbuf, f);

      }
      /*
             *   Handle long lines
             */
      if (lbuf[sizeof(lbuf)-2] && lbuf[sizeof(lbuf)-2] != '\n')
      {
         do 
         {
            lbuf[sizeof(lbuf)-2] = 0;
            fgets(lbuf, sizeof(lbuf), tmpf);
            ascck(lbuf);
            if (pgflg)
            {
               if (pgputs(lbuf) <= 0)
                  return TRUE;

            }
            else
               fputs(lbuf, f);

         } while(lbuf[sizeof(lbuf)-2] && lbuf[sizeof(lbuf)-2] == '\n');

      }
      lbuf[sizeof(lbuf)-2] = 0;

   }
   if (pgflg)
   {
      pgflsh(1);
      return TRUE;

   }
   else 
   {
      fflush(f);
      return ferror(f) ? FALSE : TRUE;

   }
}

ascck(s)
char   *s;
{
   char   *sp = s;

   if (s != NULL)
   {
      while (*sp)
      {
         if (!isascii(*sp))
            fprintf(stderr,
                "%s: Nonascii character 0%o\nLine: %s\n",
                Mailpgm, *sp, s);
         ++sp;

      }

   }
}

fromuucp(line)
char *line;
/* returns 1 if message from "uucp ", else returns NULL */
{
   printf("scanning line: %s", line);
   if(*line == '>') line++;
   if(strncmp(line, "From uucp ", 10)) return(1);
   else return(NULL);
}
