case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting filter/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#
# @(#)$Id: Makefile.SH,v 4.1 90/04/28 22:41:51 syd Exp $
#  Makefile for the Elm system filter program
#
#	Copyright (c) 1986, 1987 Dave Taylor
#	Copyright (c) 1988, 1989, 1990 USENET Community Trust
#
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Syd Weinstein - elm@DSI.COM
#			dsinc!elm
#
#  $Log:	Makefile.SH,v $
# Revision 4.1  90/04/28  22:41:51  syd
# checkin of Elm 2.3 as of Release PL0
# 
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $xenlf
LIB		=	$lib
LIB2		= 	$libs
LIBS		=	$termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MAKE		=	$make
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	Variables you may want to manually edit
#		If you want debug logging then you'll
#		want to uncomment the following.
#DEBUG		=	-DDEBUG

#	Other variables
BIN		=	../bin
INCLDIR		=	../hdrs
CFLAGS		=	$(CCFLAGS) $(OPTIMIZE) -I$(INCLDIR) $(DEBUG) $(DACSNET) 
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# Definitions of variables
FILTER_SRC	=	actions.c	\
			buffer.c	\
			filter.c	\
			lock.c		\
			parse.c		\
			rules.c		\
			summarize.c	\
			utils.c		\
			../src/opt_utils.c

FILTER_OBJ	=	actions.o	\
			buffer.o	\
			filter.o	\
			lock.o		\
			parse.o		\
			rules.o		\
			summarize.o	\
			utils.o		\
			../src/opt_utils.o

# Standard targets
all:		$(BIN)/filter
		
install:	$(DEST)/filter

uninstall:	
		$(RM) $(DEST)/filter

#	This is the only target that gets installed even if not out-of-date
#	with respect the files from which it is installed.
rmt-install:	rmt-defined
		-$(MV) $(DEST)/filter $(DEST)/filter.old
		-$(RM) $(DEST)/filter.old
		$(CP) $(REMOTE)$(DEST)/filter $(DEST)/filter
		$(CHGRP) $(MAILGRP) $(DEST)/filter
		$(CHMOD) $(MAILERMODE) $(DEST)/filter

rmt-defined:
	@(if [ "$(REMOTE)" = "" ];\
	  then\
	    $(ECHO) "You need to define 'REMOTE' as the remote file system";\
	    $(ECHO) "for this particular command. The easiest way to do this";\
	    $(ECHO) "to type:";\
	    $(ECHO) "        make REMOTE=<remote file system> rmt-install";\
	    exit 1;\
	  fi);

lint:		
		$(LINT) $(LINTFLAGS) $(FILTER_SRC) > LINT.OUT

clean:		
		$(RM) $(FILTER_OBJ) $(BIN)/filter

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies and rules for C object files
actions.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
filter.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
lock.o:			$(INCLDIR)/defs.h $(INCLDIR)/filter.h
parse.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
rules.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
summarize.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
utils.o:		$(INCLDIR)/defs.h $(INCLDIR)/filter.h
../src/opt_utils.o:
			cd ../src; $(MAKE) -$(MAKEFLAGS) $(@F)

#	Dependencies and rules for compiling programs
$(BIN)/filter:	$& $(FILTER_OBJ)
		$(CC) $(LFLAGS) -o $@ $(FILTER_OBJ) $(LIB2)

#	Dependencies and rules for installing programs from bin directory
$(DEST)/filter:		$(BIN)/filter
			-$(MV) $(DEST)/filter $(DEST)/filter.old
			-$(RM) $(DEST)/filter.old
			$(CP) $? $@
			$(CHGRP) $(MAILGRP) $@
			$(CHMOD) $(MAILERMODE) $@
!NO!SUBS!
