function retval = norm (x, p)

# Compute the norm of x.

  if (nargin < 1 || nargin > 2)
    error ('usage: norm (x [, p])')
  endif

# Do we have a vector or matrix as the first argument?

  if (rows (x) == 1 || columns (x) == 1)

    if (nargin == 2)
      if (p == Inf)
        retval = max (abs (x));
      elseif (p == -Inf)
        retval = min (abs (x));
      else
        retval = sum (abs (x) .^ p) ^ (1/p);
      endif
    elseif (nargin == 1)
      retval = sum (abs (x) .^ 2) ^ 0.5;
    endif

  else

    if (nargin == 2)
      if (isstr (p))
        if (strcmp (p, 'fro'))
          retval = sqrt (sum (diag (x' * x)));
        else
          error ('norm: unrecognized norm');
        endif
      else
        if (p == 1)
          retval = max (sum (abs (real (x)) + abs (imag (x))));
        elseif (p == 2)
          s = svd (x);
          retval = s (1);
        elseif (p == Inf)
          xp = x';
          retval = max (sum (abs (real (xp)) + abs (imag (xp))));
        endif
      endif
    elseif (nargin == 1)
      s = svd (x);
      retval = s (1);
    endif

  endif

endfunction
