------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--  S Y S T E M . T A S K _ C L O C K . M A C H I N E _ S P E C I F I C S   --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.4 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides target machine specific Clock related definitions.
--  Portability of System.Task_Clock package is accomplished separating
--  this child package out. We only need to modify this package for
--  different targets.

with System.POSIX_Timers;
--  Used for, POSIX_Timers.clock_gettime,
--            POSIX_Timers.CLOCK_REALTIME

package body System.Task_Clock.Machine_Specifics is

   -----------
   -- Clock --
   -----------

   function Clock return Stimespec is
      Now    : POSIX_Timers.timespec;
      Result : Integer;

   begin
      POSIX_Timers.clock_gettime (POSIX_Timers.CLOCK_REALTIME, Now, Result);
      return
        Stimespec'(Val => Stimespec_Sec_Unit.Val * Time_Base (Now.tv_sec) +
                   Time_Base (Now.tv_nsec));
   end Clock;

begin
   Stimespec_Ticks := Time_Of (0, 1000000);
   --  Sun os 4.1 has clock resoultion of 10ms.

end System.Task_Clock.Machine_Specifics;
