------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--               S Y S T E M . S E C O N D A R Y _ S T A C K                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.10 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package System.Secondary_Stack is

   --  The Secondary Stack is used to allocate anonymous objects created for
   --  storing intermediate result of functions returning unconstrained objects

   --  The basic use of this stack is the following:

   --    * before executing such a function (when the call doesn't appear in a
   --      return statement), the stack is marked

   --    * after execution, and copy of the intermediate result, the stack is
   --      poped until the mark is reached.

   --    * during execution, the function allocates its returned value in the
   --      secondary stack (as well as other function calls in the return
   --      statement)

   type Mark_Id is private;
   --  Type used to mark the stack.

   procedure SS_Init (Stk : out Address; Size : Natural);
   --  Initialize the secondary stack with a main stack of the given Size.
   --  All further allocations which do not overflow the main stack will not
   --  generate dynamic (de)allocation calls. If the main Stack is overflowed
   --  a linked list of dynamically allocated chunks of memory takes place.
   --  Note: the reason that Stk is passed is that SS_Init is called before
   --  the proper interface is established to obtain the address of the
   --  stack using System.Task_Specific_Data.Get_Sec_Stack_Addr.

   procedure SS_Free (Stk : Address);
   --  Release the memory allocated for the Secondary Stack

   function SS_Mark return Mark_Id;
   --  Return the Mark corresponding to the current state of the stack

   procedure SS_Release (M : Mark_Id);
   --  Restore the state of the stack corresponding to the mark M. Frees
   --  all storage allocated by SS_Allocate since the SS_Mark operation
   --  that returned the value M.

   function SS_Allocate (Size : Natural) return Address;
   --  Allocate a chunk of memory of the given Size (in Storage_Units)

   generic
      with procedure Put_Line (S : String);
   procedure SS_Info;
   --  Debugging procedure used to print out secondary Stack allocation
   --  information. This procedure is generic in order to avoid a direct
   --  dependance on a particular IO package.

private

   type Mark_Id is new Natural;

end System.Secondary_Stack;
