------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                           S Y S T E M . F F M                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the generic package which is instantiated with
--  predefined integer types to generate the runtime functions called by the
--  expanded code generated by Expand_Fixed_To_Fixed_Multiplication. This
--  is an implementation of Paul Hilfinger's algorithms.

package System.Ffm is
   generic
      type Int_Type is range <>;

   package Ffm_Util is

      function Compute_Result
        (X, Y, A         : Int_Type;
         M               : Integer;
         B1, B2, Eps_Neg : Boolean)
         return    Int_Type;
      --  X and Y correspond to the two values to be multiplied (X * Y).
      --  M and A correspond to scaling factors (A * (2 ** M)).
      --  The three boolean parameters are computed in the expander and
      --  correspond to different cases of Hilfinger's algorithms. They enable
      --  this function to compute the result in different ways depending on
      --  their values.

   end Ffm_Util;

end System.Ffm;
