------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                 I N T E R F A C E S . C . S T R I N G S                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Storage_Elements;

package Interfaces.C.Strings is
pragma Preelaborate (Strings);

   type Char_Array_Ptr is access all Char_Array;

   type Chars_Ptr is private;

   Null_Ptr : constant Chars_Ptr;

   function To_Chars_Ptr
     (Item       : in Char_Array_Ptr;
      Null_Check : in Boolean := False)
      return       Chars_Ptr;

   function Allocate_Chars (Chars   : in Char_Array) return Chars_Ptr;

   function Allocate_String (Str : in String) return Chars_Ptr;

   procedure Free (Item : in out Chars_Ptr);

   Null_Dereference : exception;

   function Value (Item : in Chars_Ptr) return Char_Array;

   function Value
     (Item   : in Chars_Ptr;
      Length : in Natural)
      return   Char_Array;

   function Value (Item : in Chars_Ptr) return String;

   function Value
     (Item   : in Chars_Ptr;
      Length : in Natural)
      return   String;

   function Strlen (Item : in Chars_Ptr) return Natural;

   procedure Update
     (Item   : in Chars_Ptr;
      Offset : in Natural;
      Chars  : in Char_Array;
      Check  : Boolean := True);

   procedure Update
     (Item   : in Chars_Ptr;
      Offset : in Natural;
      Str    : in String;
      Check  : in Boolean := True);

   Update_Error : exception;

private
   type Chars_Ptr is new System.Storage_Elements.Integer_Address;

   Null_Ptr : constant Chars_Ptr := 0;
   --  A little cleaner might be To_Integer (System.Null_Address) but this is
   --  non-preelaborable, and in fact we jolly well know this value is zero.
   --  Indeed, given the C interface nature, it is probably more correct to
   --  write zero here (even if Null_Address were non-zero).

end Interfaces.C.Strings;
