-----------------------------------------------------------------------------
--                                                                         --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                         --
--                   T a s k _ S t o r a g e _ P o o l s                   --
--                                                                         --
--                                 S p e c                                 --
--                                                                         --
--                            $Revision: 1.2 $                            --
--                                                                         --
--          Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                         --
-- GNARL is free software; you can redistribute it and/or modify it  under --
-- terms  of  the  GNU  Library General Public License as published by the --
-- Free Software Foundation; either version 2, or  (at  your  option)  any --
-- later  version.   GNARL is distributed in the hope that it will be use- --
-- ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
-- MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
-- eral Library Public License for more details.  You should have received --
-- a  copy of the GNU Library General Public License along with GNARL; see --
-- file COPYING. If not, write to the Free Software Foundation,  675  Mass --
-- Ave, Cambridge, MA 02139, USA.                                          --
--                                                                         --
-----------------------------------------------------------------------------

with System.Storage_Pools;
with System.Storage_Elements;

package System.Task_Storage_Pools is

   type Storage_Pool is new Storage_Pools.Root_Storage_Pool;
   procedure Finalize (Object : in out Storage_Pool);
   procedure Allocate (
         Pool : in out Storage_Pool;
         Storage_Address : out Address;
         Storage_Size : Storage_Elements.Storage_Count;
         Alignment : Storage_Elements.Storage_Count);
   procedure Deallocate (
         Pool : in out Storage_Pool;
         Storage_Address : Address;
         Storage_Size : Storage_Elements.Storage_Count;
         Alignment : Storage_Elements.Storage_Count);
   function Storage_Size (Pool : Storage_Pool)
         return Storage_Elements.Storage_Count;

end System.Task_Storage_Pools;
