-----------------------------------------------------------------------------
--                                                                         --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                         --
--                R T S _ S t o r a g e _ A l l o c a t i o n              --
--                                                                         --
--                                 S p e c                                 --
--                                                                         --
--                            $Revision: 1.2 $                            --
--                                                                         --
--          Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                         --
-- GNARL is free software; you can redistribute it and/or modify it  under --
-- terms  of  the  GNU  Library General Public License as published by the --
-- Free Software Foundation; either version 2, or  (at  your  option)  any --
-- later  version.   GNARL is distributed in the hope that it will be use- --
-- ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
-- MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
-- eral Library Public License for more details.  You should have received --
-- a  copy of the GNU Library General Public License along with GNARL; see --
-- file COPYING. If not, write to the Free Software Foundation,  675  Mass --
-- Ave, Cambridge, MA 02139, USA.                                          --
--                                                                         --
-----------------------------------------------------------------------------

with System.Storage_Elements;

package System.Task_Storage_Allocation is

   procedure Allocate_Block (
         Storage_Address : out System.Address;
         Storage_Size : Storage_Elements.Storage_Count;
         Alignment : in Storage_Elements.Storage_Count);

   procedure Deallocate_Block (Storage_Address : System.Address);

   function Maximum_Storage return Storage_Elements.Storage_Count;

end System.Task_Storage_Allocation;
