------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 R T S _ P r o t e c t e d _ O b j e c t s                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Compiler_Exceptions;
with System.Task_Primitives;
with System.Task_Entries;
with System.Task_IDs;
with System.Task_Entry_Queue; use System.Task_Entry_Queue;

with Unchecked_Conversion;

package System.Task_Protected_Objects is

   Null_Protected_Entry : constant := Task_Entries.Null_Entry;
   Max_Protected_Entry : constant := Task_Entries.Max_Entry;
   type Protected_Entry_Index is new Task_Entries.Entry_Index
         range Null_Protected_Entry .. Max_Protected_Entry;
   type Call_Modes is (Simple_Call, Conditional_Call, Asynchronous_Call);
   function C_M_To_EQ_Call_Modes is new
         Unchecked_Conversion (Call_Modes, EQ_Call_Modes);
   function EQ_C_M_To_Call_Modes is new
         Unchecked_Conversion (EQ_Call_Modes, Call_Modes);

   type Protected_Entry_Queue_Array is
         array (Protected_Entry_Index range <>) of
               System.Task_Entry_Queue.Entry_Queue;
   type Protection (Num_Entries : Protected_Entry_Index) is record
         L : Task_Primitives.Lock;
         Pending_Call : Entry_Call_Link;
         Call_In_Progress : Entry_Call_Link;
         Entry_Queues : Protected_Entry_Queue_Array (1 .. Num_Entries);
   end record;
   type Protection_Access is access all Protection;

   function EQ_P_A_To_Protection_Access is new
         Unchecked_Conversion (EQ_Protection_Access, Protection_Access);
   function P_A_To_EQ_Protection_Access is new
         Unchecked_Conversion (Protection_Access, EQ_Protection_Access);

   procedure Initialize_Protection (
         Object : Protection_Access;
         Ceiling_Priority : Integer);

   procedure Finalize_Protection (Object : Protection_Access);

   procedure Lock (Object : Protection_Access);

   procedure Lock_Read_Only (Object : Protection_Access);

   procedure Unlock (Object : Protection_Access);

   type Communication_Block is record
         Self : Task_IDs.Task_ID;
   end record;

   procedure Protected_Entry_Call
         (Object : Protection_Access;
         E : Protected_Entry_Index;
         Parameter : System.Address;
         Mode : Call_Modes;
         Block : out Communication_Block);

   procedure Wait_For_Completion
         (Call_Cancelled : out Boolean;
         Block : in out Communication_Block);

   procedure Cancel_Protected_Entry_Call
         (Call_Cancelled : out Boolean;
         Block : in out Communication_Block);

   type Barrier_Vector is array (Protected_Entry_Index range <>) of Boolean;

   procedure Next_Entry_Call
         (Object : Protection_Access;
         Barriers : Barrier_Vector;
         Parameter : out System.Address;
         E : out Protected_Entry_Index);

   procedure Complete_Entry_Body
         (Object : Protection_Access;
         Pending_Serviced : out Boolean);

   procedure Exceptional_Complete_Entry_Body (
         Object : Protection_Access;
         Pending_Serviced : out Boolean;
         Ex : Compiler_Exceptions.Exception_ID);

   procedure Requeue_Protected_Entry (
         Object, New_Object : Protection_Access;
         E : Protected_Entry_Index;
         With_Abort : Boolean);

   procedure Requeue_Task_Entry (
         New_Object : Protection_Access;
         T : in out Task_IDs.Task_ID;
         E : Protected_Entry_Index;
         With_Abort : Boolean);

   function Protected_Count (
         Object : Protection;
         E : Protected_Entry_Index) return Natural;

   procedure Broadcast_Program_Error (Object : Protection_Access);

   procedure Raise_Pending_Exception (Block : Communication_Block);

   procedure Check_Exception;

   function Get_Call_In_Progress (Object : Protection) return Entry_Call_Link;

   procedure Set_Call_In_Progress (
         Object : Protection_Access;
         Call : Entry_Call_Link);

end System.Task_Protected_Objects;
