------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                            R T S _ M e m o r y                           --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Primitives; use System.Task_Primitives;

package body System.Task_Memory is

   --  malloc() and free() are not currently thread-safe,
   --  though they should be.
   --  In the meantime, these protected versions are provided.

   Memory_Mutex : Lock;

   procedure Low_Level_Free (A : System.Address) is
      procedure free (Addr : System.Address);
      pragma INTERFACE (C, free);
   begin
      Write_Lock (Memory_Mutex);
      free (A);
      Unlock (Memory_Mutex);
   end Low_Level_Free;

   function Low_Level_New (Size : in Storage_Elements.Storage_Count)
         return System.Address is
      function malloc (Size : in Storage_Elements.Storage_Count)
            return System.Address;

      pragma INTERFACE (C, malloc);
      Temp : System.Address;
   begin
      Write_Lock (Memory_Mutex);
      Temp := malloc (Size);
      Unlock (Memory_Mutex);
      return Temp;
   end Low_Level_New;

   function Unsafe_Low_Level_New (Size : in Storage_Elements.Storage_Count)
         return System.Address is
      function malloc (Size : in Storage_Elements.Storage_Count)
            return System.Address;

      pragma INTERFACE (C, malloc);
   begin
      return malloc (Size);
   end Unsafe_Low_Level_New;

end System.Task_Memory;
