------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                        R T S _ E n t r y _ Q u e u e                     --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

package body System.Task_Entry_Queue is

   --  enqueue Call at the end of entry_queue E
   procedure Enqueue (E : in out Entry_Queue; Call : Entry_Call_Link) is
   begin
      if E.Head = null then
         E.Head := Call;  --  E.Tail should also be null here
      else
         E.Tail.Next := Call;
      end if;
      E.Tail := Call;
      Call.Next := E.Head; --  make circular linked-list
   end Enqueue;

   --  dequeue Call from entry_queue E
   procedure Dequeue (E : in out Entry_Queue; Call : Entry_Call_Link) is
      Prev : Entry_Call_Link;
   begin
      if E.Head = null then
         return;                           --  empty queue, simply return
      end if;
      if E.Head = Call then
         if E.Tail = Call then
            E.Head := null;                  --  case of one element
            E.Tail := null;
         else
            E.Head := Call.Next;
            E.Tail.Next := E.Head;
         end if;
         Call.Next := null;                 --  successfully dequeued
      else
         Prev := E.Head;                    --  at this point, we know that the
         loop                              --  queue has more than one element
            if Prev.Next = Call then
               Prev.Next := Call.Next;
               if E.Tail = Call then
                  E.Tail := Prev;
               end if;
               Call.Next := null;             --  successfully dequeued
               exit;
            end if;
            exit when Prev.Next = E.Tail;   --  Call is not found
            Prev := Prev.Next;
         end loop;
      end if;
   end Dequeue;

   --  return the head of entry_queue E
   function Head (E : in Entry_Queue) return Entry_Call_Link is
   begin
      return E.Head;
   end Head;

   --  remove and return the head of entry_queue E
   procedure Dequeue_Head (
         E : in out Entry_Queue;
         Call : out Entry_Call_Link) is
      Temp : Entry_Call_Link;
   begin
      if E.Head = null then
         Call := null;                   --  empty queue, return null pointer
         return;
      end if;
      Temp := E.Head;
      if E.Head = E.Tail then
         E.Head := null;                 --  case of one element
         E.Tail := null;
      else
         E.Head := Temp.Next;
         E.Tail.Next := E.Head;
      end if;
      Temp.Next := null;                 --  successfully dequeued
      Call := Temp;
   end Dequeue_Head;

   --  return True if Call is on any entry_queue at all
   function Onqueue (Call : Entry_Call_Link) return Boolean is
   begin
      return Call.Next /= null;
      --  utilize the fact that every queue is circular, so if Call
      --  is on any queue at all, Call.Next must NOT be null.
   end Onqueue;

   --  return number of calls on the waiting queue of E
   function Count_Waiting (E : in Entry_Queue) return Natural is
      Count : Natural;
      Temp : Entry_Call_Link;
   begin
      Count := 0;
      if E.Head /= null then
         Temp := E.Head;
         loop
            Count := Count + 1;
            exit when E.Tail = Temp;
            Temp := Temp.Next;
         end loop;
      end if;
      return Count;
   end Count_Waiting;

end System.Task_Entry_Queue;
