------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                            P O S I X _ E r r o r                         --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains those parts of the package POSIX defined in P1003.5
--  (Ada binding to POSIX.1) needed to interface to Pthreads.

package System.POSIX_Error is

   type Return_Code is new Integer;
   Failure : constant Return_Code := -1;

   type Error_Code is new Integer;

   function errno return Error_Code;
   pragma Interface (C, errno);
   --  An interface to the error number of the current thread.  This is updated
   --  by Pthreads at each context switch.

   --  Error number definitions.  These definitions are derived from
   --  /usr/include/errno.h and /usr/include/sys/errno.h.  These are SunOS
   --  errors; they have not yet been checked for POSIX complience.
   EPERM : constant Error_Code := 1;            --  Not owner
   ENOENT : constant Error_Code := 2;           --  No such file or directory
   ESRCH : constant Error_Code := 3;            --  No such process
   EINTR : constant Error_Code := 4;            --  Interrupted system call
   EIO : constant Error_Code := 5;              --  I/O error
   ENXIO : constant Error_Code := 6;            --  No such device or address
   E2BIG : constant Error_Code := 7;            --  Arg list too long
   ENOEXEC : constant Error_Code := 8;          --  Exec format error
   EBADF : constant Error_Code := 9;            --  Bad file number
   ECHILD : constant Error_Code := 10;          --  No children
   EAGAIN : constant Error_Code := 11;          --  No more processes
   ENOMEM : constant Error_Code := 12;          --  Not enough core
   EACCES : constant Error_Code := 13;          --  Permission denied
   EFAULT : constant Error_Code := 14;          --  Bad address
   ENOTBLK : constant Error_Code := 15;         --  Block device required
   EBUSY : constant Error_Code := 16;           --  Mount device busy
   EEXIST : constant Error_Code := 17;          --  File exists
   EXDEV : constant Error_Code := 18;           --  Cross-device link
   ENODEV : constant Error_Code := 19;          --  No such device
   ENOTDIR : constant Error_Code := 20;         --  Not a directory
   EISDIR : constant Error_Code := 21;          --  Is a directory
   EINVAL : constant Error_Code := 22;          --  Invalid argument
   ENFILE : constant Error_Code := 23;          --  File table overflow
   EMFILE : constant Error_Code := 24;          --  Too many open files
   ENOTTY : constant Error_Code := 25;          --  Not a typewriter
   ETXTBSY : constant Error_Code := 26;         --  Text file busy
   EFBIG : constant Error_Code := 27;           --  File too large
   ENOSPC : constant Error_Code := 28;          --  No space left on device
   ESPIPE : constant Error_Code := 29;          --  Illegal seek
   EROFS : constant Error_Code := 30;           --  Read-only file system
   EMLINK : constant Error_Code := 31;          --  Too many links
   EPIPE : constant Error_Code := 32;           --  Broken pipe
   EDOM : constant Error_Code := 33;            --  Argument too large
   ERANGE : constant Error_Code := 34;          --  Result too large
   EWOULDBLOCK : constant Error_Code := 35;     --  Operation would block
   EINPROGRESS : constant Error_Code := 36;     --  Operation now in progress
   EALREADY : constant Error_Code := 37;        --  Operation already in
                                                --  progress
   ENOTSOCK : constant Error_Code := 38;
   --  Socket operation on non-socket
   EDESTADDRREQ : constant Error_Code := 39;    --  Destination address
                                                --  required
   EMSGSIZE : constant Error_Code := 40;        --  Message too long
   EPROTOTYPE : constant Error_Code := 41;      --  Protocol wrong type for
                                                --  socket
   ENOPROTOOPT : constant Error_Code := 42;     --  Protocol not available
   EPROTONOSUPPORT : constant Error_Code := 43; --  Protocol not supported
   ESOCKTNOSUPPORT : constant Error_Code := 44; --  Socket type not supported
   EOPNOTSUPP : constant Error_Code := 45;      --  Operation not supported on
                                                --  socket
   EPFNOSUPPORT : constant Error_Code := 46;    --  Protocol family not
                                                --  supported
   EAFNOSUPPORT : constant Error_Code := 47;    --  Address family not
                                                --  supported
                                                --  by protocol family
   EADDRINUSE : constant Error_Code := 48;      --  Address already in use
   EADDRNOTAVAIL : constant Error_Code := 49;   --  Can't assign requested
                                                --  address
   ENETDOWN : constant Error_Code := 50;        --  Network is down
   ENETUNREACH : constant Error_Code := 51;     --  Network is unreachable
   ENETRESET : constant Error_Code := 52;       --  Network dropped connection
                                                --  on reset
   ECONNABORTED : constant Error_Code := 53;    --  Software caused connection
                                                --  abort
   ECONNRESET : constant Error_Code := 54;      --  Connection reset by peer
   ENOBUFS : constant Error_Code := 55;         --  No buffer space available
   EISCONN : constant Error_Code := 56;         --  Socket is already connected
   ENOTCONN : constant Error_Code := 57;        --  Socket is not connected
   ESHUTDOWN : constant Error_Code := 58;       --  Can't send after socket
                                                --  shutdown
   ETOOMANYREFS : constant Error_Code := 59;    --  Too many references :
                                                --  can't splice
   ETIMEDOUT : constant Error_Code := 60;       --  Connection timed out
   ECONNREFUSED : constant Error_Code := 61;    --  Connection refused
   ELOOP : constant Error_Code := 62;           --  Too many levels of symbolic
                                                --  links
   ENAMETOOLONG : constant Error_Code := 63;    --  File name too long
   EHOSTDOWN : constant Error_Code := 64;       --  Host is down
   EHOSTUNREACH : constant Error_Code := 65;    --  No route to host
   ENOTEMPTY : constant Error_Code := 66;       --  Directory not empty
   EPROCLIM : constant Error_Code := 67;        --  Too many processes
   EUSERS : constant Error_Code := 68;          --  Too many users
   EDQUOT : constant Error_Code := 69;          --  Disc quota exceeded
   ESTALE : constant Error_Code := 70;          --  Stale NFS file handle
   EREMOTE : constant Error_Code := 71;         --  Too many levels of remote
                                                --  in path
   ENOSTR : constant Error_Code := 72;          --  Device is not a stream
   ETIME : constant Error_Code := 73;           --  Timer expired
   ENOSR : constant Error_Code := 74;           --  Out of streams resources
   ENOMSG : constant Error_Code := 75;          --  No message of desired type
   EBADMSG : constant Error_Code := 76;         --  Trying to read unreadable
                                                --  message
   EIDRM : constant Error_Code := 77;           --  Identifier removed
   EDEADLK : constant Error_Code := 78;         --  Deadlock condition.
   ENOLCK : constant Error_Code := 79;          --  No record locks available.
   ENONET : constant Error_Code := 80;          --  Machine is not on
                                                --  thenetwork
   ERREMOTE : constant Error_Code := 81;        --  Object is remote
   ENOLINK : constant Error_Code := 82;         --  the link has been severed
   EADV : constant Error_Code := 83;            --  advertise error
   ESRMNT : constant Error_Code := 84;          --  srmount error
   ECOMM : constant Error_Code := 85;           --  Communication error on send
   EPROTO : constant Error_Code := 86;          --  Protocol error
   EMULTIHOP : constant Error_Code := 87;       --  multihop attempted
   EDOTDOT : constant Error_Code := 88;         --  Cross mount point (not an
                                                --  error)
   EREMCHG : constant Error_Code := 89;         --  Remote address changed
   ENOSYS : constant Error_Code := 90;          --  function not implemented

   ENOTSUP : constant Error_Code := ENOSYS + 1;

end System.POSIX_Error;
