------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                         C a l e n d a r - C o n v                        --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.2 $                            --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

package body Ada.Calendar.Conv is

   Epoch_Time : Calendar.Time := Calendar.Time_Of (1970, 1, 1);

   function Calendar_Time_To_Real_Time_Time (
         T : Ada.Calendar.Time) return System.Real_Time.Time  is
   begin
      return System.Real_Time.Time_Of (0, To_Time_Span (T - Epoch_Time));
   exception
      when others => raise Constraint_Error;
      --  Notice that the whole range of the Calendar.Time can be not converted
      --  to Real_Time.Time
   end Calendar_Time_To_Real_Time_Time;

end Ada.Calendar.Conv;
