#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/file.h>
#include "gifeng.h"
#include "usejpeg.h"
#include "tnpicfont.h"


#define PICS_ACROSS 5        /* gives as 640 pixels across max. */
#define TEXTHI 22

int vkludge=1;


byte *theimage,*palrgb,*redptr,*greenptr,*blueptr;
int outwidth,outheight;
int width,height,numcols;
int scrnwide=128,scrnhigh=96;
int palr[256],palg[256],palb[256]; 


int readgiforjpg(char *,hffunc);
byte *resizepic();



main(argc,argv)
int argc;
char **argv;
{
byte *resizedrgb,*outimage;
char str[1024],*org;
int f,total,cx,cy,xsiz,ysiz;
div_t cxy;

total=argc-2;
if(total<1)
  {
  printf("Usage: tnpic [JPEG collage file] GIF/JPEG_file_1 ... file_n\n\n"
  	 "For example, to create a thumbnail jpeg containing all gif and jpeg\n"
  	 "files in the current directory:\n"
  	 "  tnpic index.jpg *.gif *.jpg\n");
  exit(1);
  }
else
  {
  cxy=div(total,PICS_ACROSS);
  cx=cxy.rem;          /* so we have cx pics across, and cy down */
  xsiz=((cxy.quot+1)==1)?cx*scrnwide:(PICS_ACROSS*scrnwide);
  if(total>1) cxy=div(total-1,PICS_ACROSS);
  ysiz=(cy=cxy.quot+1)*(scrnhigh+TEXTHI);
  /* so now the big RGB collage will be xsiz by ysiz */
  if((outimage=malloc(xsiz*ysiz*3))==NULL)
    {
    printf("Not enough memory for collage image.\n");
    exit(1);
    }
  
  for(f=0;f<total;f++)
    {
    printf("Reading %s...\n",argv[f+2]);
    cxy=div(f,PICS_ACROSS);
    if(readgiforjpg(argv[f+2],NULL)!=0)
      {
      /* JPEG errors are reported automatically...
       * it'll be a GIF if we get here.
       */
      printf("Error reading GIF file.\n");
      exit(1);
      }
    resizedrgb=resizepic();
    addpic(outimage,resizedrgb,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI),xsiz);
    if(strrchr(argv[f+2],'/')!=NULL)
      org=strrchr(argv[f+2],'/')+1;
    else
      org=argv[f+2];
    strcpy(str,org);
    if(strlen(str)>16) str[16]=0;
    addtext(outimage,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI)+scrnhigh+3,str,xsiz);
    sprintf(str,"%d x %d",width,height);
    addtext(outimage,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI)+scrnhigh+10,str,xsiz);
    free(resizedrgb);
    free(theimage);
    free(palrgb);
    }
    
  outwidth=xsiz; outheight=ysiz; /* for JPEG writing routine */
  redptr=outimage;
  greenptr=outimage+1;           /* and so are these */
  blueptr=outimage+2;         
  printf("Writing %s...\n",argv[1]);
  write_JPEG_file(argv[1]);
  free(outimage);
  printf("Done.\n");
  exit(0);
  }
}

int getredbyte()
{
int v;
v=*redptr; redptr+=3;
return(v);
}

int getgreenbyte()
{
int v;
v=*greenptr; greenptr+=3;
return(v);
}

int getbluebyte()
{
int v;
v=*blueptr; blueptr+=3;
return(v);
}


addtext(outimage,xpos,ypos,str,xsiz)
byte *outimage;
int xpos,ypos;
char *str;
int xsiz;
{
int a,b,c,f,x,loc;

x=xpos;
for(f=0;f<strlen(str);f++)
  {
  c=toupper(str[f])-32;
  if((c<0)||(c>63))
    c='_'-32;
  for(b=0;b<5;b++)
    for(a=0;a<tnpicfont[LETTERSIZ*c];a++)
      if(tnpicfont[LETTERSIZ*c+1+b*8+a]=='x')
        {
        loc=3*((ypos+b)*xsiz+x+a);
        outimage[loc  ]=255;
        outimage[loc+1]=255;
        outimage[loc+2]=255;
        }
  x+=tnpicfont[LETTERSIZ*c]+1;
  }
}


addpic(outimage,inimage,xpos,ypos,xsiz)
byte *outimage,*inimage;
int xpos,ypos,xsiz;
{
int x,y;

for(y=0;y<scrnhigh;y++)
  for(x=0;x<scrnwide;x++)
    {
    *(outimage+3*((ypos+y)*xsiz+xpos+x)  )=*(inimage+3*(y*scrnwide+x)  );
    *(outimage+3*((ypos+y)*xsiz+xpos+x)+1)=*(inimage+3*(y*scrnwide+x)+1);
    *(outimage+3*((ypos+y)*xsiz+xpos+x)+2)=*(inimage+3*(y*scrnwide+x)+2);
    }
}


int readgiforjpg(giffn,howfarfunc)
char *giffn;
hffunc howfarfunc;
{
int result,isjpeg;
GIFINFO ginfo;
byte *palette;

if(!strcmp(strrchr(giffn,'.'),".jpg"))
  {
  isjpeg=1;
  ginfo.numcols=256;
  theimage=NULL;
  result=read_JPEG_file(giffn,howfarfunc,&palette);
  if(theimage==NULL)
    result=0;
  else
    if(result==0) free(theimage);
  }
else
  {
  isjpeg=0;
  result=readgif(giffn,&theimage,&palette,howfarfunc);
  if(result==_GIF_OK)
    {
    getgifinfo(&ginfo);
    height=ginfo.height; width=ginfo.width;
    }
  else
    return(result);
  }
numcols=ginfo.numcols;
if(((isjpeg)&&(result==1))||((!isjpeg)&&(result==_GIF_OK)))
  {
  palrgb=palette;
  filterpal(palrgb);
  /********** all memory still allocated **********/
  /* (we lose it later on) */
  }
/* when is a result not a result? */
if(isjpeg) result=!result;
return(result);
}


filterpal(palette)
byte *palette;
{
int f;

for(f=0;f<256;f++)   /* don't *really* need to know number of colours */
  {
  palr[f]=palette[    f];
  palg[f]=palette[256+f];
  palb[f]=palette[512+f];
  }
}




/* this routine is nasty writ big, but about as quick as I can manage */
byte *resizepic()
{
register int a,b,x,yp,yw;
long y,sw,sh,lastyp;
int xoff,yoff;
int c,pixwide,pixhigh,pr,pg,pb;
long place;
int bigimage;
byte *rline;
int tmp1,tmp2,tr,tg,tb,tn;
int xypos;

if((rline=malloc(scrnwide*scrnhigh*3))==NULL) return(0);
for(x=0;x<(scrnwide*scrnhigh*3);x++)
  rline[x]=0;

/* try landscapey */
sw=scrnwide; sh=(int)((scrnwide*((long)height))/((long)width));
if(sh>scrnhigh)
  /* no, oh well portraity then */
  { sh=scrnhigh; sw=(int)((scrnhigh*((long)width))/((long)height)); }

/* so now our zoomed image will be sw x sh */
bigimage=(width>sw)?1:0;   /* 1 if image has been reduced, 0 if made bigger */
if(bigimage)
  /* it's been reduced - easy, just make 'em fit in less space */
  {
  lastyp=-1;
  pixhigh=(int)(((float)height)/((float)sh)+0.5);
  pixwide=(int)(((float)width)/((float)sw)+0.5);
  /*if(pixhigh==0)*/ pixhigh++;
  /*if(pixwide==0)*/ pixwide++;
  for(y=0;y<height;y++)
    {
    yp=(y*sh)/height;
    if(yp!=lastyp)
      {
      yw=y*width;
      if(vkludge) /* we try to resample a bit. get that pentium RSN :) */
        {
        for(x=0;x<width;x++,yw++)
          {
          tr=tg=tb=tn=0;
          for(b=0;(b<pixhigh)&&(y+b<height);b++)
            for(a=0;(a<pixwide)&&(x+a<width);a++)
              {
              tmp2=*(theimage+yw+a+b*width);
              tr+=palr[tmp2];
              tg+=palg[tmp2];
              tb+=palb[tmp2];
              tn++;
              }
          tr/=tn; tg/=tn; tb/=tn;
          xypos=3*(((x*sw)/width)+yp*scrnwide);
          rline[xypos]=tr;
          rline[xypos+1]=tg;
          rline[xypos+2]=tb;
          }
        }
      else
        for(x=0;x<width;x++,yw++)
          {
          tmp2=*(theimage+yw);
          xypos=3*(((x*sw)/width)+yp*scrnwide);
          rline[xypos  ]=palr[tmp2];
          rline[xypos+1]=palg[tmp2];
          rline[xypos+2]=palb[tmp2];
          }
      lastyp=yp;
      }
    }
  }
else
  /* we just leave it the same size */
  {
  for(y=0;y<height;y++)
    for(x=0;x<width;x++)
      {
      c=theimage[y*width+x];
      rline[3*(y*scrnwide+x)  ]=palr[c];
      rline[3*(y*scrnwide+x)+1]=palg[c];
      rline[3*(y*scrnwide+x)+2]=palb[c];
      }
  }
  
return(rline);
}


