/* decoders.c */

#include "mphead.h"

short mb_addr_inc[2048];
unsigned char macro_block_table_p[64],macro_block_table_b[64];
short motion_vector_table[2048];

short coded_block_pattern_table[512] = {
	 0<<4|0, 0<<4|0,39<<4|9,27<<4|9,59<<4|9,55<<4|9,47<<4|9,31<<4|9,
	58<<4|8,58<<4|8,54<<4|8,54<<4|8,46<<4|8,46<<4|8,30<<4|8,30<<4|8,
	57<<4|8,57<<4|8,53<<4|8,53<<4|8,45<<4|8,45<<4|8,29<<4|8,29<<4|8,
	38<<4|8,38<<4|8,26<<4|8,26<<4|8,37<<4|8,37<<4|8,25<<4|8,25<<4|8,
	43<<4|8,43<<4|8,23<<4|8,23<<4|8,51<<4|8,51<<4|8,15<<4|8,15<<4|8,
	42<<4|8,42<<4|8,22<<4|8,22<<4|8,50<<4|8,50<<4|8,14<<4|8,14<<4|8,
	41<<4|8,41<<4|8,21<<4|8,21<<4|8,49<<4|8,49<<4|8,13<<4|8,13<<4|8,
	35<<4|8,35<<4|8,19<<4|8,19<<4|8,11<<4|8,11<<4|8, 7<<4|8, 7<<4|8,
	34<<4|7,34<<4|7,34<<4|7,34<<4|7,18<<4|7,18<<4|7,18<<4|7,18<<4|7,
	10<<4|7,10<<4|7,10<<4|7,10<<4|7, 6<<4|7, 6<<4|7, 6<<4|7, 6<<4|7,
	33<<4|7,33<<4|7,33<<4|7,33<<4|7,17<<4|7,17<<4|7,17<<4|7,17<<4|7,
	 9<<4|7, 9<<4|7, 9<<4|7, 9<<4|7, 5<<4|7, 5<<4|7, 5<<4|7, 5<<4|7,
	63<<4|6,63<<4|6,63<<4|6,63<<4|6,63<<4|6,63<<4|6,63<<4|6,63<<4|6,
	 3<<4|6, 3<<4|6, 3<<4|6, 3<<4|6, 3<<4|6, 3<<4|6, 3<<4|6, 3<<4|6,
	36<<4|6,36<<4|6,36<<4|6,36<<4|6,36<<4|6,36<<4|6,36<<4|6,36<<4|6,
	24<<4|6,24<<4|6,24<<4|6,24<<4|6,24<<4|6,24<<4|6,24<<4|6,24<<4|6,
	62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,
	62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,62<<4|5,
	 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5,
	 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5, 2<<4|5,
	61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,
	61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,61<<4|5,
	 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5,
	 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5, 1<<4|5,
	56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,
	56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,56<<4|5,
	52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,
	52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,52<<4|5,
	44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,
	44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,44<<4|5,
	28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,
	28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,28<<4|5,
	40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,
	40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,40<<4|5,
	20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,
	20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,20<<4|5,
	48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,
	48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,48<<4|5,
	12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,
	12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,12<<4|5,
	32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,
	32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,
	32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,
	32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,32<<4|4,
	16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,
	16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,
	16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,
	16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,16<<4|4,
	 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4,
	 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4,
	 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4,
	 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4, 8<<4|4,
	 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4,
	 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4,
	 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4,
	 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4, 4<<4|4,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
	60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,60<<4|3,
};

unsigned char dct_dc_size_luminance[128] = {
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,
	0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,0<<4|3,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,
	4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,4<<4|3,
	5<<4|4,5<<4|4,5<<4|4,5<<4|4,5<<4|4,5<<4|4,5<<4|4,5<<4|4,
	6<<4|5,6<<4|5,6<<4|5,6<<4|5,7<<4|6,7<<4|6,8<<4|7,0<<4|0,
};

unsigned char dct_dc_size_chrominance[256] = {
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,0<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,1<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,2<<4|2,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,3<<4|3,
	4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,
	4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,4<<4|4,
	5<<4|5,5<<4|5,5<<4|5,5<<4|5,5<<4|5,5<<4|5,5<<4|5,5<<4|5,
	6<<4|6,6<<4|6,6<<4|6,6<<4|6,7<<4|7,7<<4|7,8<<4|8,0<<4|0,
};

unsigned short dct_coeff_tbl_0[256] = {
	0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x052f,0x051f,0x050f,0x04ff,0x183f,0x402f,0x3c2f,0x382f,
	0x342f,0x302f,0x2c2f,0x7c1f,0x781f,0x741f,0x701f,0x6c1f,
	0x028e,0x028e,0x027e,0x027e,0x026e,0x026e,0x025e,0x025e,
	0x024e,0x024e,0x023e,0x023e,0x022e,0x022e,0x021e,0x021e,
	0x020e,0x020e,0x04ee,0x04ee,0x04de,0x04de,0x04ce,0x04ce,
	0x04be,0x04be,0x04ae,0x04ae,0x049e,0x049e,0x048e,0x048e,
	0x01fd,0x01fd,0x01fd,0x01fd,0x01ed,0x01ed,0x01ed,0x01ed,
	0x01dd,0x01dd,0x01dd,0x01dd,0x01cd,0x01cd,0x01cd,0x01cd,
	0x01bd,0x01bd,0x01bd,0x01bd,0x01ad,0x01ad,0x01ad,0x01ad,
	0x019d,0x019d,0x019d,0x019d,0x018d,0x018d,0x018d,0x018d,
	0x017d,0x017d,0x017d,0x017d,0x016d,0x016d,0x016d,0x016d,
	0x015d,0x015d,0x015d,0x015d,0x014d,0x014d,0x014d,0x014d,
	0x013d,0x013d,0x013d,0x013d,0x012d,0x012d,0x012d,0x012d,
	0x011d,0x011d,0x011d,0x011d,0x010d,0x010d,0x010d,0x010d,
	0x282c,0x282c,0x282c,0x282c,0x282c,0x282c,0x282c,0x282c,
	0x242c,0x242c,0x242c,0x242c,0x242c,0x242c,0x242c,0x242c,
	0x143c,0x143c,0x143c,0x143c,0x143c,0x143c,0x143c,0x143c,
	0x0c4c,0x0c4c,0x0c4c,0x0c4c,0x0c4c,0x0c4c,0x0c4c,0x0c4c,
	0x085c,0x085c,0x085c,0x085c,0x085c,0x085c,0x085c,0x085c,
	0x047c,0x047c,0x047c,0x047c,0x047c,0x047c,0x047c,0x047c,
	0x046c,0x046c,0x046c,0x046c,0x046c,0x046c,0x046c,0x046c,
	0x00fc,0x00fc,0x00fc,0x00fc,0x00fc,0x00fc,0x00fc,0x00fc,
	0x00ec,0x00ec,0x00ec,0x00ec,0x00ec,0x00ec,0x00ec,0x00ec,
	0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,0x00dc,
	0x00cc,0x00cc,0x00cc,0x00cc,0x00cc,0x00cc,0x00cc,0x00cc,
	0x681c,0x681c,0x681c,0x681c,0x681c,0x681c,0x681c,0x681c,
	0x641c,0x641c,0x641c,0x641c,0x641c,0x641c,0x641c,0x641c,
	0x601c,0x601c,0x601c,0x601c,0x601c,0x601c,0x601c,0x601c,
	0x5c1c,0x5c1c,0x5c1c,0x5c1c,0x5c1c,0x5c1c,0x5c1c,0x5c1c,
	0x581c,0x581c,0x581c,0x581c,0x581c,0x581c,0x581c,0x581c,
};

unsigned short dct_coeff_tbl_1[16] = {
	0x00bb,0x202b,0x103b,0x00ab,0x084b,0x1c2b,0x541b,0x501b, 
	0x009b,0x4c1b,0x481b,0x045b,0x0c3b,0x008b,0x182b,0x441b, 
};

unsigned short dct_coeff_tbl_2_3[2][4] = {
	{0x4019,0x1429,0x0079,0x0839},
	{0x0449,0x3c19,0x3819,0x1029},
};

unsigned short dct_coeff_next[256] = {
	0xffff,0xffff,0xffff,0xffff,0xf7d5,0xf7d5,0xf7d5,0xf7d5,
	0x0826,0x0826,0x2416,0x2416,0x0046,0x0046,0x2016,0x2016,
	0x1c15,0x1c15,0x1c15,0x1c15,0x1815,0x1815,0x1815,0x1815,
	0x0425,0x0425,0x0425,0x0425,0x1415,0x1415,0x1415,0x1415,
	0x3417,0x0067,0x3017,0x2c17,0x0c27,0x0437,0x0057,0x2817,
	0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,
	0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,
	0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,
	0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,
	0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,
	0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,
	0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,0xfbe1,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
	0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011,
};

unsigned short int dct_coeff_first[256] = {
	0xffff,0xffff,0xffff,0xffff,0xf7d5,0xf7d5,0xf7d5,0xf7d5,
	0x0826,0x0826,0x2416,0x2416,0x0046,0x0046,0x2016,0x2016,
	0x1c15,0x1c15,0x1c15,0x1c15,0x1815,0x1815,0x1815,0x1815,
	0x0425,0x0425,0x0425,0x0425,0x1415,0x1415,0x1415,0x1415,
	0x3417,0x0067,0x3017,0x2c17,0x0c27,0x0437,0x0057,0x2817,
	0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,0x0034,
	0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,0x1014,
	0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,0x0c14,
	0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,
	0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,0x0023,
	0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,
	0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,0x0813,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,0x0412,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
	0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,
};

#define assign_mb_type(end,quant,forw,back,pat,intra,num,a) \
	while (i < end) \
		a[i++] = quant<<7 | forw<<6 | back<<5 | pat<<4 | intra<<3 | num

static
init_mb_type()
{
	int i;

	i = 0;
	assign_mb_type( 1,0,0,0,0,0,0,macro_block_table_p);
	assign_mb_type( 2,1,0,0,0,1,6,macro_block_table_p);
	assign_mb_type( 4,1,0,0,1,0,5,macro_block_table_p);
	assign_mb_type( 6,1,1,0,1,0,5,macro_block_table_p);
	assign_mb_type( 8,0,0,0,0,1,5,macro_block_table_p);
	assign_mb_type(16,0,1,0,0,0,3,macro_block_table_p);
	assign_mb_type(32,0,0,0,1,0,2,macro_block_table_p);
	assign_mb_type(64,0,1,0,1,0,1,macro_block_table_p);
	i = 0;
	assign_mb_type( 1,0,0,0,0,0,0,macro_block_table_b);
	assign_mb_type( 2,1,0,0,0,1,6,macro_block_table_b);
	assign_mb_type( 3,1,0,1,1,0,6,macro_block_table_b);
	assign_mb_type( 4,1,1,0,1,0,6,macro_block_table_b);
	assign_mb_type( 6,1,1,1,1,0,5,macro_block_table_b);
	assign_mb_type( 8,0,0,0,0,1,5,macro_block_table_b);
	assign_mb_type(12,0,1,0,0,0,4,macro_block_table_b);
	assign_mb_type(16,0,1,0,1,0,4,macro_block_table_b);
	assign_mb_type(24,0,0,1,0,0,3,macro_block_table_b);
	assign_mb_type(32,0,0,1,1,0,3,macro_block_table_b);
	assign_mb_type(48,0,1,1,0,0,2,macro_block_table_b);
	assign_mb_type(64,0,1,1,1,0,2,macro_block_table_b);
}

static
assign_motion_vectors(start,end,step,val,num)
int *val;
{
	int j;

	while (start < end) {
		for (j=0; j<step/2; j++)
			motion_vector_table[start++] = *val<<4 | num;
		for (; j<step; j++)
			motion_vector_table[start++] = -*val<<4 | num;
		--*val;
	}
}

static
init_motion_vectors()
{
	int i;

	for (i=0; i<24; i++)
		motion_vector_table[i] = 0;
	i = 16;
	assign_motion_vectors(  24,  36,   2,&i,11);
	assign_motion_vectors(  36,  48,   4,&i,10);
	assign_motion_vectors(  48,  96,  16,&i, 8);
	assign_motion_vectors(  96, 128,  32,&i, 7);
	assign_motion_vectors( 128, 256, 128,&i, 5);
	assign_motion_vectors( 256, 512, 256,&i, 4);
	assign_motion_vectors( 512,1024, 512,&i, 3);
	assign_motion_vectors(1024,2048,1024,&i, 1);
}

static
mb_addr_inc_assign(start,end,step,val,num)
{
	int i,j;

	while (start < end) {
		for (j=0; j<step; j++)
			mb_addr_inc[start++] = val<<4 | num;
		--val;
	}
}

static
init_mb_addr_inc()
{
	int i;

	for (i=0; i<8; i++)
		mb_addr_inc[i] = 0;
	mb_addr_inc[8] = MB_ESCAPE<<4 | 11;
	for (i=9; i<15; i++)
		mb_addr_inc[i] = 0;
	mb_addr_inc[15] = MB_STUFFING<<4 | 11;
	for (i=16; i<24; i++)
		mb_addr_inc[i] = 0;
	mb_addr_inc_assign(  24,   36,    1,33,11);
	mb_addr_inc_assign(  36,   48,    2,21,10);
	mb_addr_inc_assign(  48,   96,    8,15, 8);
	mb_addr_inc_assign(  96,  128,   16, 9, 7);
	mb_addr_inc_assign( 128,  256,   64, 7, 5);
	mb_addr_inc_assign( 256,  512,  128, 5, 4);
	mb_addr_inc_assign( 512, 1024,  256, 3, 3);
	mb_addr_inc_assign(1024, 2048, 1024, 1, 1);
}

init_decoders()
{
	init_mb_addr_inc();
	init_mb_type();
	init_motion_vectors();
}
