.ad l
.nh
.TH convert 1 "10 October 1992" "ImageMagick"
.SH NAME
convert - converts an input file using one image format to an output
file with a differing image format.
.SH SYNOPSIS
.B "convert"
[ \fIoptions\fP ... ] \fIinput_file\fP \fIoutput_file\fP
.SH DESCRIPTION
\fBconvert\fP converts an input file using one image format to an output file
with a differing image format.

\fBconvert\fP recognizes the following image formats:

.TP 6
.B Tag
\fBDescription\fP
.PP
-------------------------------------------------------------------------------
.TP 6
.B ALPHA
Raw alpha bytes.
.TP 6
.B AVS
AVS X image file.
.TP 6
.B BMP
Microsoft Windows bitmap image file.
.TP 6
.B CMYK
Raw cyan, magenta, yellow, and black bytes.
.TP 6
.B EPS
Adobe Encapsulated PostScript file.
.TP 6
.B FAX
Group 3.
.TP 6
.B FITS
Flexible Image Transport System.
.TP 6
.B GIF
Compuserve Graphics image file.
.TP 6
.B GRAY
Raw gray bytes.
.TP 6
.B HISTOGRAM
.TP 6
.B IRIS
SGI RGB image file.
.TP 6
.B JPEG
.TP 6
.B MIFF
Machine Independant file format.
.TP 6
.B MTV
.TP 6
.B PCX
ZSoft IBM PC Paintbrush file.
.TP 6
.B PICT
Apple Macintosh QuickDraw/PICT file.
.TP 6
.B PNM
Portable bitmap.
.TP 6
.B PS
Adobe PostScript file.
.TP 6
.B PS2
Adobe Level II PostScript file.
.TP 6
.B RGB
Raw red, green, and blue bytes.
.TP 6
.B RLE
Utah Run length encoded image file; read only.
.TP 6
.B SUN
SUN Rasterfile.
.TP 6
.B TEXT
raw text file; read only.
.TP 6
.B TGA
Truevision Targa image file.
.TP 6
.B TIFF
Tagged Image File Format.
.TP 6
.B VICAR
read only.
.TP 6
.B VIFF
Khoros Visualization image file.
.TP 6
.B X
select image from X server screen.
.TP 6
.B XC
constant image of X server border color.
.TP 6
.B XBM
X11 bitmap file.
.TP 6
.B XWD
X Window System window dump image file.
.TP 6
.B YUV
Raw Y, U, and V bytes.  U and V, normally -0.5 through 0.5, are normalized
to the range 0 through 255 to fit within a byte.
.PP
.SH EXAMPLES
.PP
To convert a \fIMIFF\fP image of a cockatoo to a SUN raster image, use:
.PP
.B
     convert cockatoo.miff sun:cockatoo.ras
.PP
To convert a multi-page \fIPostscript\fP document to individual FAX pages, use:
.PP
.B
     convert -monochrome document.ps fax:page
.PP
To convert a TIFF image to a \fIPostscript\fP A4 page with the image in
the lower left-hand corner, use:
.PP
.B
     convert -page 595x842+0+0 image.tiff document.ps
.PP
To convert a raw \fBGRAY\fP image to a portable graymap, use:
.PP
.B
     convert -geometry 768x512 gray:raw image.pnm
.SH OPTIONS
.TP 5
.B "-alpha"
store alpha channel if the image has one.
.TP 5
.B "-clip \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the clipped image.  See \fBX(1)\fP for details
about the geometry specification.

Use clipping to crop a particular area of an image.
.TP 5
.B "-colors \fIvalue\fP"
preferred number of colors in the image.

The actual number of colors in the image may be less than your request,
but never more.  Note, this is a color reduction option.  Images with
less unique colors than specified with this option will remain unchanged.
Refer to \fBquantize(9)\fP for more details.

Note, options \fB-dither\fP, \fB-colorspace\fP, and \fB-treedepth\fP affect
the color reduction algorithm.
.TP 5
.B "-colorspace \fIvalue\fP"
the type of colorspace: \fBGRAY\fP, \fBRGB\fP, \fBXYZ\fP, \fBYCbCr\fP,
\fBYIQ\fP, or \fBYUV\fP.

Color reduction, by default, takes place in the RGB color space.
Empirical evidence suggests that distances in color spaces such as YUV
or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Refer to \fBquantize(9)\fP for
more details.

The \fB-colors\fP or \fB-monochrome\fP option is required for this option
to take effect.
.TP 5
.B "-compress \fItype\fP"
the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP 5
.B "-density \fI<width>x<height>
vertical and horizonal density of the image.

This option specifies an image density whose interpretation changes
with the type of image.  The default is 72 dots per inch in the
horizonal and vertical direction for Postscript.  Text files default to
80 characters in width and 60 lines in height.  Use this option to
alter the default density.
.TP 5
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP 5
.B "-dither"
apply Floyd/Steinberg error diffusion to the image.

The basic strategy of dithering is to trade intensity resolution for
spatial resolution by averaging the intensities of several neighboring
pixels.  Images which suffer from severe contouring when reducing colors
can be improved with this option.

The \fB-colors\fP option is required for dithering to take effect.
.TP 5
.B "-font \fIname\fP"
This option specifies the font to be used  for displaying normal text.
The default is \fBfixed\fP.
.TP 5
.B "-geometry \fI<width>x<height>\fP"
the width and height of the image.  

If the specified image size is smaller than the actual image size, the
image is first reduced to an integral of the specified image size with
an antialias digital filter.  The image is then scaled to the exact
specified image size with pixel replication.  If the specified image
size is greater than the actual image size, the image is first enlarged
to an integral of the specified image size with bilinear
interpolation.  The image is then scaled to the exact specified image
size with pixel replication.

Use this option to specify the width and height of raw images whose
dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, and \fBCMYK\fP.
.TP 5
.B "-interlace \fItype\fP"
the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.

This option is used to specify the type of interlacing scheme for raw
image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not
interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline
interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses
plane interlacing (RRRRRR...GGGGGG...BBBBBB...).
.TP 5
.B "-monochrome"
transform the image to black and white.
.TP 5
.B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the Postscript page.

Use this option to specify the dimensions of the Postscript page in picas.  The
default is to center the image on a letter page, 612 by 792 picas.
Other common sizes are:

    540x720   Note
    612x1008  Legal
    842x1190  A3
    595x842   A4
    421x595   A5
    297x421   A6
    709x1002  B4
    612x936   U.S. Foolscap
    612x936   European Foolscap
    396x612   Half Letter
    792x1224  11x17
    1224x792  Ledger

The page geometry is relative to the vertical and horizonal density of the
Postscript page.  See \fB-density\fP for details.
.TP 5
.B "-quality \fIvalue\fP"
JPEG quality setting.

Quality is 0 (worst) to 100 (best). The default is 75.
.TP 5
.B "-scale \fI<width factor>x<height factor>\fP"
preferred size factors of the image.

This option behaves like \fB-geometry\fP except the width and height values
are relative instead of absolute.  The image size is multiplied by the
width and height factors to obtain the final image dimensions.  If only
one factor is specified, both the width and height factors assume the
value.

Factors may be fractional.  To increase the size of an image, use a
scale factor greater than 1.0.  To decrease an image's size, use a
scale factor less than 1.0.  Default is 1.0.
.TP 5
.B "-scene \fIvalue\fP"
image scene number.
.TP 5
.B "-treedepth \fIvalue\fP"
Normally, this integer value is zero or one.  A zero or one tells
\fBconvert\fP to choose a optimal tree depth for the color reduction
algorithm.

An optimal depth generally allows the best representation of the source
image with the fastest computational speed and the least amount of
memory.  However, the default depth is inappropriate for some images.
To assure the best representation, try values between 2 and 8 for this
parameter.  Refer to \fBquantize(9)\fP for more details.

The \fB-colors\fP option is required for this option to take effect.
.TP 5
.B -verbose
print detailed information about the image.

This information is printed: image scene number;  image name;  converted
image name;  image size;  the image class (\fIDirectClass\fP or 
\fIPseudoClass\fP);  the total number of unique colors;  and the number
of seconds to read and convert the image.
.PP
Change '-' to '+' in any option above to reverse its effect.  For
example, specify +alpha to store the image without its alpha channel.
.PP
By default, the image format is determined by its magic number. To
specify a particular image format, precede the filename with an image
format name and a colon (i.e. ps:image) or specify the image type as
the filename suffix (i.e. image.ps).  See \fBDESCRIPTION\fP for a list
of valid formats.
.PP
When you specify \fBX\fP as your image type, the filename has special
meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no
filename is specified, the window is selected by clicking the mouse in
the desired window.
.PP
Specify \fIinput_file\fP as \fI-\fP for standard input,
\fIoutput_file\fP as \fI-\fP for standard output.  If \fIinput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed with
\fBuncompress\fP or \fBgunzip\fP respectively.  If \fIoutput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file size is compressed
using with \fBcompress\fP or \fBgzip\fP respectively.  If
\fIoutput_file\fP already exists, you will be prompted as to whether it
should be overwritten.
.SH ENVIRONMENT
.PP
.TP 5
.B display
To get the default host, display number, and screen.
.SH SEE ALSO
.B
display(1), animate(1), mogrify(1), quantize(9), X(1), miff(5)
.SH COPYRIGHT
Copyright 1993 E. I. du Pont de Nemours & Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
& Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours & Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours & Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours & Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising
out of or in connection with the use or performance of this software.
.SH AUTHORS
John Cristy, E.I. du Pont De Nemours & Company Incorporated
