/****************************************************************************************************************
 *
 *  Copyright (c) 1992 by Antoine Dumesnil de Maricourt. All rights reserved.
 *
 *  This program is distributed in the hope that it will be useful.
 *  Use and copying of this software and preparation of derivative works
 *  based upon this software are permitted, so long as the following
 *  conditions are met:
 *       o credit to the authors is acknowledged following current
 *         academic behaviour
 *       o no fees or compensation are charged for use, copies, or
 *         access to this software
 *       o this copyright notice is included intact.
 *  This software is made available AS IS, and no warranty is made about 
 *  the software or its performance. 
 * 
 *  Bug descriptions, use reports, comments or suggestions are welcome.
 *  Send them to    dumesnil@etca.fr   or to:
 *       
 *       Antoine de Maricourt
 *       ETCA CREA-SP
 *       16 bis, avenue Prieur de la Cote d'Or
 *       94114 Arcueil Cedex
 *       France
 */

#ifndef _Goban_h
#define _Goban_h

/* Resources:

 Name		       Class		  RepType		Default Value
 ----		       -----		  -------		-------------
 autoRedisplay         AutoRedisplay      Boolean         True
 background	       Background	  Pixel		  XtDefaultBackground
 blackStoneBackground  Background	  Pixel		  black
 blackStoneBorder      BorderColor	  Pixel		  black
 blackStoneForeground  Foreground	  Pixel		  white
 border		       BorderColor	  Pixel		  XtDefaultForeground
 borderWidth	       BorderWidth	  Dimension	  1
 cursor                Cursor             Integer         GbGrayCursor
 destroyCallback       Callback		  Pointer	  NULL
 displayCoordinates    DisplayCoordinates Boolean	  True
 font                  Font               XFontStruct*    fixed
 foreground            Foreground         Pixel           XtDefaultForeground
 gameSize              Size               Dimension       19
 height		       Height		  Dimension	  computed at create
 mappedWhenManaged     MappedWhenManaged  Boolean	  True
 pointSize             Size               Dimension       24
 sensitive	       Sensitive	  Boolean	  True
 viewBottom            Position           Position        computed at create
 viewLeft              Position           Position        computed at create
 viewRight             Position           Position        computed at create
 viewTop               Position           Position        computed at create
 whiteStoneBackground  Background	  Pixel		  white
 whiteStoneBorder      BorderColor	  Pixel		  black
 whiteStoneForeground  Foreground	  Pixel		  black
 width		       Width		  Dimension	  computed at create
 x		       Position		  Position	  0
 y		       Position		  Position	  0
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNautoRedisplay         "autoRedisplay"
#define XtNviewBottom            "viewBottom"

#ifndef XtNcursor
#define XtNcursor                "cursor"
#endif

#define XtNgameSize              "gameSize"
#define XtNviewLeft              "viewLeft"
#define XtNdisplayCoordinates    "displayCoordinates"
#define XtNpointSize             "pointSize"
#define XtNviewRight             "viewRight"
#define XtNviewTop               "viewTop"
#define XtNblackStoneBorder      "blackStoneBorder"
#define XtNblackStoneForeground  "blackStoneForeground"
#define XtNblackStoneBackground  "blackStoneBackground"
#define XtNwhiteStoneBorder      "whiteStoneBorder"
#define XtNwhiteStoneForeground  "whiteStoneForeground"
#define XtNwhiteStoneBackground  "whiteStoneBackground"

#define XtCAutoRedisplay         "AutoRedisplay"
#define XtCDisplayCoordinates    "DisplayCoordinates"
#define XtCSize                  "Size"

#define XtEgbWhiteStone          "white"
#define XtEgbBlackStone          "black"
#define XtEgbGrayStone           "gray"

/* declare specific GobanWidget class and instance datatypes */

typedef struct _GobanClassRec*	 GobanWidgetClass;
typedef struct _GobanRec*	 GobanWidget;

/* declare the class constant */

extern WidgetClass gobanWidgetClass;

/* cursors */

#define GbCGrayStone         256
#define GbCBlackStone        257
#define GbCWhiteStone        258

/* special marks */

#define GbMSquareMark        1
#define GbMTriangleMark      2
#define GbMVCrossMark        3
#define GbMDCrossMark        4
#define GbMDiamondMark       5

/* colors */

typedef enum { GbEmptyPoint, GbBlackStone, GbWhiteStone } GbPointState;

/* user functions */

#define GbRemoveMark(w,x,y)  GbSetMark (w, x, y, 0, 0)

extern void GbRedisplayBoard ( /* Widget w */ );
extern void GbClearBoard     ( /* Widget w */ );
extern void GbSetPoint       ( /* Widget w, Position x, Position y, GbPointState color */ );
extern void GbSetNum         ( /* Widget w, Position x, Position y, int num   */ );
extern void GbSetMark        ( /* Widget w, Position x, Position y, unsigned char mark1, unsigned char mark2 */ );

extern Boolean GbGetPositionFromStone ( /* Widget w, Position *x, Position *y */ );
extern Boolean GbGetStoneFromPosition ( /* Widget w, Position *x, Position *y */ );

#endif /* _Goban_h */

