///////////////////////////////////////////////////////////////////////////////
// $Id: TopLevel.hxx,v 1.1 1995/01/08 06:52:27 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// TopLevel.hxx - Top level widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: TopLevel.hxx,v $
// Revision 1.1  1995/01/08  06:52:27  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef TOPLEVEL_HXX
#define TOPLEVEL_HXX

#include "ContainerWidget.hxx"
#include "Command.hxx"

class TopLevel : public ContainerWidget {
  private:
    Command* myCloseCommand;

  protected:
    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

  public:
    // Constructor
    TopLevel(const char *const name, int x, int y, int width, int height,
        Command* closeCommand);

    // Destructor
    virtual ~TopLevel();

    // Answer my class
    virtual const char *const className() const { return("TopLevel"); }
};
#endif

