/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#include <X11/Intrinsic.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "types.h"
#include "network.h"
#include "riskgame.h"
#include "utils.h"
#include "callbacks.h"
#include "gui.h"
#include "dice.h"
#include "help.h"
#include "version.h"
#include "debug.h"

Int     iReadSocket, iWriteSocket;
Int     iThisClient;
String  strClientName;

void FatalError(String strError, Int iRetVal);


/************************************************************************ 
 *  FUNCTION: main
 *  HISTORY: 
 *     01.23.94  ESF  Created.
 *     02.22.94  ESF  Cleaned up a bit, removing warnings.
 *  PURPOSE: 
 *  NOTES: 
 ************************************************************************/
void main(int argc, char **argv)
{
  struct sockaddr_in   server;
  struct hostent      *hp;
  char                 strHostName[MAXHOSTNAMELEN + 1];

  MsgRegisterClient    msgRegisterClient;

  /* Setup memory debugging library */
  MEM_BootStrap("client-memory.log");

  /* Check args */
  if (argc < 2)
    FatalError("Usage: client <server_host> [<xargs>]\n", 0);
  
  /* Create sockets */
  if ((iReadSocket = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    FatalError("Opening stream connection", 1);
  
  if ((iWriteSocket = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    FatalError("Opening stream connection", 1);

  /* Connect socket using name specified by command line */
  server.sin_family = AF_INET;
  
  if ((hp = gethostbyname(argv[1])) == 0)
    FatalError("Cannot connect to specified Risk server", 1);
  
  memcpy(&server.sin_addr, hp->h_addr, hp->h_length);
  server.sin_port = htons(RISK_PORT);

  /* Send the server name information through the sockets so it can ID
   * the sending clients, and discover the pair of sockets that belong
   * to each client.
   */

  gethostname(strHostName, sizeof(strHostName));
  msgRegisterClient.strClientAddress = (String)MEM_Alloc(strlen(strHostName)+16);
  sprintf(msgRegisterClient.strClientAddress, "%s[%d]", strHostName, getpid());
  strClientName = msgRegisterClient.strClientAddress;

  /* Connect to the server */
  if(connect(iWriteSocket, (struct sockaddr *)&server, sizeof(server)) < 0)
    FatalError("Connecting stream socket", 1);
  NET_SendMessage(iWriteSocket, MSG_REGISTERCLIENT, &msgRegisterClient);
  
  if(connect(iReadSocket, (struct sockaddr *)&server, sizeof(server)) < 0)
    FatalError("Connecting stream socket", 1);
  NET_SendMessage(iReadSocket, MSG_REGISTERCLIENT, &msgRegisterClient);

  /* We start with no ID */
  iThisClient = -1;

  /* Initialize everything */
  RISK_Initialize(MODE_CLIENT, iWriteSocket, iReadSocket);
  RISK_SetSendMsgCallback(NET_SendMessage);
  RISK_SetMessageCallback(CBK_ObjectMessage);
  RISK_SetSendSyncMsgCallback(NET_SendSyncMessage);
  GUI_Setup(argc, argv);
  GUI_LoadMap(MAPFILE);
  GUI_AddCallbacks(iReadSocket);
  DICE_Init();
  HELP_Init(HELPFILE);

  /* The version and sign-on message */
  sprintf(strScratch, "Welcome to %s", FRISK_VERSION);
  UTIL_DisplayComment(strScratch);

  GUI_Start();
}


/********************************************/
void FatalError(String strError, Int iRetVal)
{
  perror(strError);
  UTIL_ExitProgram(iRetVal);
}
