#include "players.h"
#include "games.h"

/* #define META    "Mod1"         The modifier you like as META or ALT key */
#define META    "Meta"         /* The modifier you like as META or ALT key */
#define DEFTEXT "\"Press shift left mouse button for more info on a widget.\""
#define SETDEFTEXT "setvalues(*shortHelp, label," DEFTEXT ")"
#define ONENTER(action)                 \
        "Ctrl<Key>j: " action "\\n"     \
        "Ctrl<Key>m: " action "\\n"     \
        "Ctrl<Key>o: " action "\\n"     \
        "<Key>Return:" action "\\n"     \
        "<Key>KP_Enter:" action
#define ONTAB(action)                   \
        "Ctrl<Key>i: " action "\\n"     \
        "<Key>Tab:"    action
#define BACKTAB(action)                 \
        "Shift<Key>Tab:" action

String fallback_resources[] = {
#include "helptext.h"
    "*analyzer.?.width:		                   382",
    "*analyzer.?.height:		           425",
    "*analyzer.translations:                       #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         destroy()",
    "*analyzer.collect*resizeToPreferred:          True",
/*  "*analyzer.collect.?.skipAdjust:               True",
    "*analyzer.collect.scrollboard.skipAdjust:     False", */
    "*analyzer*quit.translations:                   #override \\n"
        "Shift<Btn1Down>: help(analyze_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Quit this analyze session.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*analyzer*undo.translations:                   #override \\n"
        "Shift<Btn1Down>: help(analyze_undo) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Undo the last move.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*analyzer*copy.translations:                   #override \\n"
        "Shift<Btn1Down>: help(analyze_copy) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Make a new copy of the board being analyzed.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*analyzer*scroll.translations:                 #override \\n"
        "Shift<Btn1Down>: help(analyze_scroll) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\") \\n"
        "<LeaveWindow>: ", SETDEFTEXT,
    "*analyzer*board.translations:                  #override \\n"
        "Shift<Btn1Down>: help(analyze_board) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position you are analyzing.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*observe.title:                               %B [%b]%A vs [%w]%a %W",
    "*observe.iconName:                            observing %B vs %W",
    "*observe.?.width:                             382",
    "*observe.?.height:		                   540",
    "*observe.translations:                        #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         destroy()",
    "*observe.collect.info.height:                 80",
    "*observe.collect*resizeToPreferred:           True",
    "*observe.collect.?.skipAdjust:                True",
    "*observe.collect.scrollboard.skipAdjust:      False",
    "*observe*titlePlay*editType:                  edit",
    "*observe*titlePlay.translations:              #override \\n"
        "Shift<Btn1Down>: help(observe_titlePlay) \\n"
        "<EnterWindow>: setfocus() "
            "setvalues(*shortHelp, label,"
            "\"Enter title you want to give this game.\") \\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "changetitle() "
            SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()       \\n"
        META "<Key>w:   widgets()      \\n"
        META "<Key>h:   info()",
    "*observe*titleObserve.displayCaret:           False",
    "*observe*titleObserve.translations:           #override \\n"
        "Shift<Btn1Down>: help(observe_titleObserve) \\n"
        "<EnterWindow>: "
            "setvalues(*shortHelp, label,"
            "\"Title of teaching game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()       \\n"
        META "<Key>w:   widgets()      \\n"
        META "<Key>h:   info()",
    "*observe*quit.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Close board widget.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*observe*undo.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_undo) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Undo your opponents last move.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*observe*pass.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_pass) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Pass.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*observe*done.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_done) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Stop scoring.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*observe*komi.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_komi) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Komi.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*handicap.translations:               #override \\n"
        "Shift<Btn1Down>: help(observe_handicap) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Handicap.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*captures.translations:               #override \\n"
        "Shift<Btn1Down>: help(observe_captures) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Number of stones captured by black and white.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*move.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_moves) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Move number of current position / "
            "Number of moves played.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*time.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_time) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Remaining time for black and white.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*scroll.translations:                 #override \\n"
        "Shift<Btn1Down>: help(observe_scroll) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\") \\n"
        "<LeaveWindow>: ", SETDEFTEXT,
    "*observe*board.translations:                  #override \\n"
        "Shift<Btn1Down>: help(observe_board) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position in a certain game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe*info.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the kibitzes in this game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*observe.collect.input.translations:          #override \\n"
        "Shift<Btn1Down>: help(observe_input) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a kibitz about this game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("kibitz()") "\\n"
        META "<Key>c:   change()   \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",

/*  "*review.title:                                %T", */
    "*review.title:                                %B [%b]%A vs [%w]%a %W",
    "*review.iconName:                             go review",
    "*review.?.width:                              382",
    "*review.?.height:		                   540",
    "*review.translations:                         #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         destroy()",
    "*review.collect.info.height:                  80",
    "*review.collect*resizeToPreferred:            True",
    "*review.collect.?.skipAdjust:                 True",
    "*review.collect.scrollboard.skipAdjust:       False",
    "*review*titleObserve.displayCaret:            False",
    "*review*titleObserve.translations:            #override \\n"
        "Shift<Btn1Down>: help(review_title) \\n"
        "<EnterWindow>: "
            "setvalues(*shortHelp, label,"
            "\"Title of reviewed game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("changetitle()") "\\n"
        META "<Key>c:   change()       \\n"
        META "<Key>w:   widgets()      \\n"
        META "<Key>h:   info()",
    "*review*quit.translations:                    #override \\n"
        "Shift<Btn1Down>: help(review_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Close board widget.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*review*komi.translations:                    #override \\n"
        "Shift<Btn1Down>: help(observe_komi) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Komi.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*handicap.translations:                #override \\n"
        "Shift<Btn1Down>: help(observe_handicap) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Handicap.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*captures.translations:                #override \\n"
        "Shift<Btn1Down>: help(observe_captures) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Number of stones captured by black and white.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*move.translations:                    #override \\n"
        "Shift<Btn1Down>: help(observe_moves) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Move number of current position / "
            "Number of moves played.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*time.translations:                    #override \\n"
        "Shift<Btn1Down>: help(review_time) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Remaining time for black and white.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*scroll.translations:                  #override \\n"
        "Shift<Btn1Down>: help(observe_scroll) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Scroll to older and/or more recent positions.\") \\n"
        "<LeaveWindow>: ", SETDEFTEXT,
    "*review*board.translations:                   #override \\n"
        "Shift<Btn1Down>: help(observe_board) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"View a position in a certain game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*review*info.translations:                    #override \\n"
        "Shift<Btn1Down>: help(review_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the comments for this game.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*players.title:                               Players",
    "*players.iconName:                            go players",
    "*players.translations:                        #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    "*players.?.width:                             816",
#else  /* XAW3D */
    "*players.?.width:                             834",
#endif /* XAW3D */
    "*players.?.height:                            150",
    "*players.allowShellResize:                    True",
    "*players.collect.playerset.allowResize:       True",
/*  "*players.collect.playerset.resizeToPreferred: True", */
/*  "*players.collect.strip.allowResize:           True",
    "*players.collect.strip.resizeToPreferred:     True", */
    "*players.collect.?.skipAdjust:                True",
    "*players.collect.info.skipAdjust:             False",
    "*players.collect.stripform.preferredPaneSize: 50",
/*  "*players.collect.info.height:                 80", */
    "*players.collect.info.preferredPaneSize:      80",
    "*players.collect.stats.label:                 Players may exist",
    "*players*playerset*Command.foreground:        XtDefaultForeground",
    "*players*playerset*Command.background:        #8FBC8F",
    "*players*playerset*playerEntryk.background:   #40B040",
    "*players*playerset*playerEntryd.background:   #32CD32",
    "*players*playerset*playerEntryp.background:   Green",
    "*players*playerset*Command.translations:      #override \\n"
        "Shift<Btn1Down>: help(players_player) \\n"
        "Ctrl<Btn1Down>:  doplayer(" DUMPPLAYER ") \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Shows info on a logged on player.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn3Down>         : set() \\n"
        "<Btn3Up>           : notify() unset() \\n"
        "<Btn1Down>,<Btn1Up>: doplayer(" PLAYERKEY1 ") \\n"
        "<Btn3Down>,<Btn3Up>: doplayer(" PLAYERKEY3 ")",
    "*players*stats.translations:                  #override \\n"
        "Shift<Btn1Down>: help(players_stats) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the number of players and games.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*players*strip.translations:                  #override \\n"
        "Shift<Btn1Down>: help(players_strip) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a graph of the number of logged on players.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*players*info.translations:                   #override \\n"
        "Shift<Btn1Down>: help(players_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a history of connect/disconnect messages.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*games.title:                                 Games",
    "*games.iconName:                              go games",
    "*games.translations:                          #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    "*games.?.width:                               496",
#else  /* XAW3D */
    "*games.?.width:                               505",
#endif /* XAW3D */
    "*games.?.height:                              150",
    "*games.allowShellResize:                      True",
    "*games.collect.gameset.allowResize:           True",
/*  "*games.collect.gameset.resizeToPreferred:     True", */
/*  "*games.collect.strip.allowResize:             True",
    "*games.collect.strip.resizeToPreferred:       True", */
    "*games.collect.stripform.preferredPaneSize:   50",
/*  "*games.collect.info.height:                   80", */
    "*games.collect.info.preferredPaneSize:        80",
    "*games.collect.?.skipAdjust:                  True",
    "*games.collect.info.skipAdjust:               False",
    "*games.collect.strip.skipAdjust:              False",
    "*games*gameset*Toggle.translations:           #override \\n"
        "Shift<Btn1Down>: help(games_game) \\n"
        "Ctrl<Btn1Down>:  dogame(" DUMPGAME ") \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Shows information about a game in progress.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "<Btn1Down>,<Btn1Up>: toggle() dogame(" GAMEKEY1 ")          \\n"
        "<Btn2Down>,<Btn2Up>: toggle() dogame(" GAMEKEY2 ") toggle() \\n"
        "<Btn3Down>,<Btn3Up>: toggle() dogame(" GAMEKEY3 ") toggle()",
    "*games*gameset*Toggle.foreground:             XtDefaultForeground",
    "*games*gameset*Toggle.background:             #8FBC8F",
    "*games*gameset*gameEntryk.background:         #40B040",
    "*games*gameset*gameEntryd.background:         #32CD32",
    "*games*gameset*gameEntryp.background:         Green",
    "*games*strip.translations:                    #override \\n"
        "Shift<Btn1Down>: help(games_strip) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a graph of the number of games in progress.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*games*info.translations:                     #override \\n"
        "Shift<Btn1Down>: help(games_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows a history of messages about the games.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*reviews.title:                               Reviews",
    "*reviews.iconName:                            go reviews",
    "*reviews.translations:                        #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
#ifndef   XAW3D
    "*reviews.?.width:                             500",
    "*reviews*reviewset*Command.width:             490",
#else  /* XAW3D */
    "*reviews.?.width:                             509",
    "*reviews*reviewset*Command.width:             499",
#endif /* XAW3D */
    "*reviews.?.height:                            150",
    "*reviews.allowShellResize:                    True",
/*  "*reviews*reviewset*resizeToPreferred:         True", */
    "*reviews*reviewset*Command.translations:      #override \\n"
        "Shift<Btn1Down>: help(reviews_game) \\n"
        "Ctrl<Btn1Down>:  dogame(" DUMPGAME ") \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Shows information about a game you can review.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Down>,<Btn1Up>: doreview(" GAMEKEY1 ") \\n"
        "<Btn2Down>,<Btn2Up>: doreview(" GAMEKEY2 ") \\n"
        "<Btn3Down>,<Btn3Up>: doreview(" GAMEKEY3 ") ",
    "*reviews*reviewset*Command.foreground:         XtDefaultForeground",
    "*reviews*reviewset*Command.background:         #8FBC8F",
    "*reviews*reviewset*reviewEntry.background:     Green",
    "*reviews*reviewset*reviewEntryPending.background: #32CD32",
    "*reviews*reviewset*reviewEntryDone.background: #40B040",

    "*igsMessages.translations:                    #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
    "*igsMessages.title:                           IGS messages",
    "*igsMessages.iconName:                        IGS messages",
    "*igsMessages.?.width:                         715",
    "*igsMessages.?.height:                        210",
    "*igsMessages*quit.translations:               #override \\n"
        "Shift<Btn1Down>: help(messages_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the window with IGS messages.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*igsMessages*save.translations:               #override \\n"
        "Shift<Btn1Down>: help(messages_save) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current IGS messages to a file.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*igsMessages*info.translations:               #override \\n"
        "Shift<Btn1Down>: help(messages_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows important IGS related messages.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*events.translations:                         #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
    "*events.title:                                Events",
    "*events.iconName:                             go events",
    "*events.?.width:                              800",
    "*events.?.height:                             210",
    "*events*quit.translations:                    #override \\n"
        "Shift<Btn1Down>: help(events_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the window with event related messages.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*events*save.translations:                    #override \\n"
        "Shift<Btn1Down>: help(events_save) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current event related messages to a file.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*events*info.translations:                    #override \\n"
        "Shift<Btn1Down>: help(events_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows event related messages.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,

    "*broadcasts.translations:                     #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
    "*broadcasts.title:                            Broadcasts",
    "*broadcasts.iconName:                         go broadcasts",
    "*broadcasts.?.width:                          530",
    "*broadcasts.?.height:                         210",
    "*broadcasts.collect.?.resizeToPreferred:      True",
    "*broadcasts.collect.?.skipAdjust:             True",
    "*broadcasts.collect.info.skipAdjust:          False",
    "*broadcasts*quit.translations:                #override \\n"
        "Shift<Btn1Down>: help(broadcasts_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the broadcasts window.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*broadcasts*save.translations:                #override \\n"
        "Shift<Btn1Down>: help(broadcasts_save) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current broadcasts (shouts) to a file.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*broadcasts*info.translations:                #override \\n"
        "Shift<Btn1Down>: help(broadcasts_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current broadcasts (shouts).\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*broadcasts.collect.input.translations:       #override \\n"
        "Shift<Btn1Down>: help(broadcast_input) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a message to everybody on the server (shout).\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("broadcast()") "\\n"
        META "<Key>c:   change()   \\n"
        META "<Key>w:   widgets()   \\n"
        META "<Key>h:   info()",

    "*yells.translations:                          #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",
    "*yells.title:                                 Channels",
    "*yells.iconName:                              go channels",
    "*yells.?.width:                               530",
    "*yells.?.height:                              210",
    "*yells.collect.?.resizeToPreferred:           True",
    "*yells.collect.?.skipAdjust:                  True",
    "*yells.collect.info.skipAdjust:               False",
    "*yells*quit.translations:                     #override \\n"
        "Shift<Btn1Down>: help(yells_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Popdown the channels window.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*yells*save.translations:                     #override \\n"
        "Shift<Btn1Down>: help(yells_save) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current channel messages (yells) to a file.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*yells*channels.translations:                     #override \\n"
        "Shift<Btn1Down>: help(yells_channels) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Show who is on which channel.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*yells*channel*string:                        (None)",
    "*yells*channel*editType:                      edit",
    "*yells*channel.displayCaret:                  True",
    "*yells*channel.resize:                        never",
    "*yells*channel.translations:                  #override \\n"
        "Shift<Btn1Down>: help(yells_channel) \\n"
        "<EnterWindow>: setfocus() "
            "setvalues(\"textSource(*yells*channel)\", string,\"\") "
            "setvalues(*shortHelp, label,"
            "\"Enter channel you want to move to.\") \\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "changechannel() "
            SETDEFTEXT "\\n"
        ONENTER("changechannel()") "\\n"
        META "<Key>c:   change()       \\n"
        META "<Key>w:   widgets()      \\n"
        META "<Key>h:   info()",
    "*yells*title.translations:                    #override \\n"
        "Shift<Btn1Down>: help(yells_title) \\n"
        "<EnterWindow>: setfocus() "
            "setvalues(*yells*title, displayCaret, True) "
            "setvalues(*shortHelp, label,"
            "\"Shows the title of the channel you are on.\") \\n"
        "<LeaveWindow>: setfocus(\"*input\") "
            "setvalues(*yells*title, displayCaret, False) "
            "changechanneltitle() "
            SETDEFTEXT "\\n"
        ONENTER("changechanneltitle()"),
    "*yells*title*editType:                        edit",
    "*yells*title.displayCaret:                    False",
    "*yells*moderator.translations:                #override \\n"
        "Shift<Btn1Down>: help(yells_moderator) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the moderator of the channel you are on.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*yells*moderator.width:                       1",
    "*yells*moderator.displayCaret:                False",
    "*yells*state.translations:                    #override \\n"
        "Shift<Btn1Down>: help(yells_state) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the state of the channel you are on.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*yells*state.width:                           1",
    "*yells*state.displayCaret:                    False",
    "*yells*info.translations:                     #override \\n"
        "Shift<Btn1Down>: help(yells_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current channel messages (yells).\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*yells.collect.input.translations:            #override \\n"
        "Shift<Btn1Down>: help(yells_input) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Sends a message (yell) on the current channel.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("yell()") "\\n"
        META "<Key>c:   change()   \\n"
        META "<Key>w:   widgets()   \\n"
        META "<Key>h:   info()",

    "*tell.title:                                  Talking to %N[%n]%A",
    "*tell.iconName:                               talking to %N[%n]%A",
    "*tell.?.width:                                530",
    "*tell.?.height:                               210",
    "*tell.translations:                           #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         destroy()",
    "*tell*getStats.label:                         stats",
    "*tell.collect.?.allowResize:                  True",
    "*tell.collect*resizeToPreferred:              True",
    "*tell.collect.?.skipAdjust:                   True",
    "*tell.collect.info.skipAdjust:                False",
    "*tell*quit.translations:                      #override \\n"
        "Shift<Btn1Down>: help(tell_quit) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Quit talking and destroy window.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT "\\n"
        "<Btn1Down>,<Btn1Up>: destroy(\"\")",
    "*tell*save.translations:                      #override \\n"
        "Shift<Btn1Down>: help(tell_save) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Save the current messages to a file.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*tell*bug.translations:                       #override \\n"
        "Shift<Btn1Down>: help(tell_bug) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Send a bug (beep) command to the other person.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*tell*getStats.translations:                     #override \\n"
        "Shift<Btn1Down>: help(tell_stats) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Get extra info about the other person.\") \\n"
        "<LeaveWindow>: reset() " SETDEFTEXT,
    "*tell*info.translations:                      #override \\n"
        "Shift<Btn1Down>: help(tell_info) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Shows the current messages.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*tell.collect.input.translations:             #override \\n"
        "Shift<Btn1Down>: help(tell_input) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Send a message to the other person.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("tell()") "\\n"
        META "<Key>c:   change()   \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",

    "*stats.title:                                 Stats of %N[%n]%A",
    "*stats.iconName:                              stats of %N[%n]%A",
    "*stats.?.width:                               570",
    "*stats.translations:                          #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         destroy()",
    "*stats.collect.?*foreground:                  XtDefaultForeground",
    "*stats.collect.?*background:                  Green",
    "*stats.collect.quit.foreground:               Yellow",
    "*stats.collect.quit.background:               Red",
#ifndef   XAW3D
    "*stats.collect.quit.shapeStyle:               roundedRectangle",
#endif /* XAW3D */
    "*stats*Text.resize:                           both",
    "*stats*Text.displayCaret:                     False",

    "*title:                                       %N v %V",
    "*iconName:                                    %N",
    "?.translations:                               #override \\n"
/*
        "<LeaveWindow>: setvalues(*shortHelp, label,"
            "\"Hey, where is your pointer going ?\") \\n"
        "<EnterWindow>: setvalues(*shortHelp, label," DEFTEXT ") \\n"
*/
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         echo(Please log out in a clean way)\\n"
        "<ClientMessage>XGOSPEL_TRIP_PROBE: tripmessage()",
    "*main.?.width:                                570",
    "*main.?.height:                               400",
    "*main.collect.?.resizeToPreferred:            True",
    "*main.collect.?.skipAdjust:                   True",
    "*main.collect.info.skipAdjust:                False",
    "*main*shortHelp.label: "
        "Press shift left mouse button for more info on a widget.",
#ifdef    XAW3D
    "*main*shortHelp.shadowWidth:                  0",
#endif /* XAW3D */
    "*main*info.translations:                      #override \\n"
        "Shift<Btn1Down>: help(main_info)",
    "*main*quit.cursorName:                        pirate",
    "*main*quit.state:                             True",
    "*main*quit.translations:                      #override \\n"
        "Shift<Btn1Down>: help(main_quit) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Terminate with extreme prejudice.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT,
    "*main*gamesButton.translations:               #override \\n"
        "Shift<Btn1Down>: help(main_games) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of games in progress.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*games, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*games) setvalues(*games, iconic, false)",
    "*main*playersButton.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_players) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of players logged on.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*players, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*players) setvalues(*players, iconic, false)",
    "*main*messageButton.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_messages) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of important server messages.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*igsMessages, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*igsMessages) setvalues(*igsMessages, iconic, false)",
    "*main*broadcastButton.translations:           #override \\n"
        "Shift<Btn1Down>: help(main_broadcasts) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of broadcast widget.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*broadcasts, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*broadcasts) setvalues(*broadcasts, iconic, false)",
    "*main*yellButton.translations:                #override \\n"
        "Shift<Btn1Down>: help(main_channels) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of channel widget.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "<Btn2Down>,<Btn2Up>: toggle() usercommand(channels) toggle() \\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*yells, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*yells) setvalues(*yells, iconic, false)",
    "*main*reviewsButton.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_reviews) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of available saved games.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*reviews, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*reviews) setvalues(*events, iconic, false)",
    "*main*eventsButton.translations:              #override \\n"
        "Shift<Btn1Down>: help(main_events) \\n"
        "<EnterWindow>: highlight(Always) setvalues(*shortHelp, label,"
            "\"Toggle display of events.\") \\n"
        "<LeaveWindow>: unhighlight() " SETDEFTEXT "\\n"
        "Ctrl<Btn3Down>,<Btn3Up>: setvalues(*events, iconic, true) \\n"
        "<Btn3Down>,<Btn3Up>: setvalues(,state, true)  popup(*events) setvalues(*events, iconic, false)",
    "*main*localTime.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_localTime) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays your local time.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*main*universalTime.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_universalTime) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays universal time.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*main*serverTime.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_serverTime) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Displays IGS server local time.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*main*shortHelp.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_shortHelp) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Gives short help on widget.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT,
    "*main.collect.input.translations:             #override \\n"
        "Shift<Btn1Down>: help(main_input) \\n"
        "<EnterWindow>: setvalues(*shortHelp, label,"
            "\"Enter server commands.\") \\n"
        "<LeaveWindow>: " SETDEFTEXT "\\n"
        ONENTER("igscommand()") "\\n"
        META "<Key>c:   change()   \\n"
        META "<Key>w:   widgets()  \\n"
        META "<Key>h:   info()",
    "*main*wantConnect.state:                      True",
    "*main*connect.label:                          connection with %S %P:",
    "*main*hasConnect.label:                       have it",
    "*main*wantConnect.label:                      want it",

    "*quitConfirm*confirm.label:                   Do you really want to quit ?",
    "*quitConfirm*Paned.?.showGrip:                False",
    "*quitConfirm*Paned*Paned.orientation:         horizontal",
    "*quitConfirm*Paned*Paned.?.skipAdjust:        True",
    "*quitConfirm*Paned*Paned.filler.skipAdjust:   False",
    "*quitConfirm*ok.label:                        Ok",
    "*quitConfirm*ok.cursorName:                   pirate",
    "*quitConfirm*filler.width:                    1",
    "*quitConfirm*filler.height:                   1",
    "*quitConfirm*cancel.label:                    Cancel",
    "*quitConfirm*cancel.translations:             #override \\n"
        "<Btn1Up>: notify() popdown() unset()",
    "*quitConfirm.title:                           Confirm",
    "*quitConfirm.iconName:                        Confirm",
    "*quitConfirm.translations:                    #override \\n"
        "<ClientMessage>WM_PROTOCOLS:   WMprotocol() \\n"
        "<ClientMessage>DELETE:         popdown()",

    "*askString*allowShellResize:                  True",
    "*askString*Label.background:                  Green",
    "*askString*userPassword.label:                Enter user and password",
    "*askString*userLabel.label:                   User:    ",
    "*askString*passwordLabel.label:               Password:",
    "*askString*sgfFilenameLabel.label:            sgf filename:",
    "*askString*psFilenameLabel.label:             ps filename:",
    "*askString*kibitzFilenameLabel.label:         kibitz filename:",
    "*askString*broadcastFilenameLabel.label:      broadcasts filename:",
    "*askString*yellFilenameLabel.label:           channels filename:",
    "*askString*tellFilenameLabel.label:           tell filename:",
    "*askString*serverFilenameLabel.label:         igs messages filename:",
    "*askString*eventsFilenameLabel.label:         events filename:",
    "*askString*mainFilenameLabel.label:           session filename:",
    "*askString*analyzeSizeLabel.label:            analyzeboard size:",
    "*askString*replayTimeoutLabel.label:          replay rate:      ",
    "*askString*whoTimeoutLabel.label:             who    rate:      ",
    "*askString*gamesTimeoutLabel.label:           games  rate:      ",
    "*askString*reviewsTimeoutLabel.label:         review rate:      ",
    "*askString*playersTimeoutLabel.label:         playerwindow rate:",
    "*askString*serverTimeoutLabel.label:          server timeout:   ",
    "*askString*quitTimeoutLabel.label:            quit timeout:     ",
    "*askString*sortPlayersTimeoutLabel.label:     players by strength:",
    "*askString*sortGamesTimeoutLabel.label:       games   by strength:",
    "*askString*tersePlayLabel.label:              terse  play traffic:",
    "*askString*Text*editType:                     edit",
    "*askString*Text.resize:                       both",
    "*askString*Text.displayCaret:                 False",
    "*askString*password*Text*echo:                False",
    "*askString*Paned.?.showGrip:                  False",
    "*askString*Paned.?.allowResize:               True",
    "*askString*Paned.?.resizeToPreferred:         True",
    "*askString*collect.orientation:               vertical",
    "*askString*collect*Paned.orientation:         horizontal",
    "*askString*Text.translations:                 #override \\n"
        ONTAB("nexttext()") "\\n"
        ONENTER("endtext()") "\\n"
        META "<Key>c:   change()  \\n"
        META "<Key>w:   widgets() \\n"
        META "<Key>h:   info()",

    "*popMessage*Label.background:                 Green",
    "*popMessage*ok.foreground:                    Yellow",
    "*popMessage*ok.background:                    Red",
    "*popMessage*Paned.?.showGrip:                 False",
    "*popMessage*ok.translations:                  #override \\n"
        "<Btn1Down>,<Btn1Up>: destroy(\"\")",
    "*buttons*quit.foreground:                     Yellow",
    "*buttons*quit.background:                     Red",
    "*buttons.beep.foreground:                     Yellow",
    "*buttons.beep.background:                     #6B238E",
    "*buttons*?.foreground:                        XtDefaultForeground",
    "*buttons*?.background:                        Green",
    "*buttons*quit.label:                          Quit",
    "*buttons*gamesButton.label:                   Games",
    "*buttons*playersButton.label:                 Players",
    "*buttons*messageButton.label:                 Messages",
    "*buttons*broadcastButton.label:               Broadcasts",
    "*buttons*yellButton.label:                    Channels",
    "*buttons*analyzeButton.label:                 Analyze",
    "*buttons*eventsButton.label:                  events",
    "*buttons*reviewsButton.label:                 reviews",
    "*buttons*Text.resize:                         both",
    "*buttons*Text.displayCaret:                   False",
#ifndef   XAW3D
    "*buttons*shapeStyle:                          roundedRectangle",
#endif /* XAW3D */
    "*times*?.foreground:                          XtDefaultForeground",
    "*times*?.background:                          Green",
    "*times*Text.resize:                           both",
    "*times*Text.displayCaret:                     False",
#ifndef   XAW3D
    "*times*shapeStyle:                            roundedRectangle",
#endif /* XAW3D */

    "*scrollboard.orientation:                     horizontal",
    "*scrollboard.?.showGrip:                      False",

#ifdef    XAW3D
    "*Label.borderWidth:                           0",
#endif /* XAW3D */
    "*options.label:                               Options",
    "*commands.label:                              Commands",
    "*undo.label:                                  Undo",
    "*copy.label:                                  Copy",
    "*pass.label:                                  Pass",
    "*done.label:                                  Done",
    "*save.label:                                  Save",
    "*options.translations:                        #override\\n"
        "~Shift<Btn1Down>: reset() popupmenu(optionMenu) \\n"
        " Shift<Btn1Down>: help(help_options) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Press left mouse button for a menu with options.\") \\n"
        "<LeaveWindow>: reset() setvalues(*shortHelp, label," DEFTEXT ")",
    "*commands.translations:                       #override\\n"
        "~Shift<Btn1Down>: reset() popupmenu(commandMenu) \\n"
        " Shift<Btn1Down>: help(help_commands) \\n"
        "<EnterWindow>: highlight() setvalues(*shortHelp, label,"
            "\"Press left mouse button for a menu with commands.\") \\n"
        "<LeaveWindow>: reset() setvalues(*shortHelp, label," DEFTEXT ")",

    "*optionMenu*?.HorizontalMargins:              30",
    "*optionMenu*SmeLabel.HorizontalMargins:       4",
    "*optionMenu*sgfFromStart.state:               True",
    "*optionMenu*psFromStart.state:                True",
    "*optionMenu*messageLabel.label:               On message:",
    "*optionMenu*fileLabel.label:                  Save file:",
    "*optionMenu*file.label:                       filename",
    "*optionMenu*othersLabel.label:                Other options:",
    "*optionMenu*analyzeSize.label:                analyze size",
    "*optionMenu*programSettings.label:            program settings",
    "*optionMenu*observeMoveLabel.label:           On move:",
    "*optionMenu*moveBeep.label:                   beep",
    "*optionMenu*moveRaise.label:                  raise",
    "*optionMenu*errorLabel.label:                 On Error:",
    "*optionMenu*errorBeep.label:                  beep",
    "*optionMenu*errorRaise.label:                 raise",
    "*optionMenu*outputLabel.label:                On Output:",
    "*optionMenu*bugLabel.label:                   On Bug:",
    "*optionMenu*bugBeep.label:                    beep",
    "*optionMenu*bugRaise.label:                   raise",
    "*optionMenu*kibitzActionLabel.label:          On Kibitz:",
    "*optionMenu*kibitzBeep.label:                 beep",
    "*optionMenu*kibitzRaise.label:                raise",
    "*optionMenu*sgfLabel.label:                   Sgf file:",
    "*optionMenu*sgfFile.label:                    filename",
    "*optionMenu*sgfOverwrite.label:               overwrite",
    "*optionMenu*sgfFromStart.label:               from start",
    "*optionMenu*psLabel.label:                    Ps file:",
    "*optionMenu*psFile.label:                     filename",
    "*optionMenu*psOverwrite.label:                overwrite",
    "*optionMenu*psFromStart.label:                from start",
    "*optionMenu*kibitzLabel.label:                Kibitz file:",
    "*optionMenu*kibitzFile.label:                 filename",
    "*optionMenu*kibitzOverwrite.label:            overwrite",

    "*commandMenu*declineAdjourn.label:            decline adjourn",
    "*commandMenu*sgfSave.label:                   save game",
    "*commandMenu*psSave.label:                    save postscript",
    "*commandMenu*kibitzSave.label:                save kibitzes",
    "*commandMenu*talkBlack.label:                 talk to %B",
    "*commandMenu*talkWhite.label:                 talk to %W",
    "*commandMenu*statsBlack.label:                stats %B",
    "*commandMenu*statsWhite.label:                stats %W",
    "*commandMenu*statsMe.label:                   stats %N",

    "*textForm.text*borderWidth:                   0",
    "*textForm.?.resizable:                        True",
    "*buttons*optionMenu*background:               XtDefaultBackground",
    "*buttons*commandMenu*background:              XtDefaultBackground",
    "*options.menuName:                            optionMenu",
    "*igsMessages*raise.state:                     True",
    "*igsMessages*errorRaise.state:                True",
    "*SmeBell.state:                               True",
    "*blink.state:                                 True",
    "*info.scrollVertical:                         whenNeeded",
    "*Text.wrap:                                   word",
    "*input*editType:                              edit",
    "*board.background:                            #FFA54F",
    "*StripChart.jumpScroll:                       1",
    "*background:                                  #BFD8D8",
    "*?*accelerators:                              #augment \\n"
        META "<Key>c: change() \\n"
        META "<Key>w: widgets() \\n"
        META "<Key>h: info()",
#ifdef    XAW3D
    "*shadowWidth:                                 3",
#endif /* XAW3D */
    "*widgetTree: (,ApplicationShell "
                     "(main.Paned"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Toggle"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "("
                                         " outputLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         " line.SmeLine"
                                         " connect.SmeLabel"
                                         " line.SmeLine"
                                         " hasConnect.SmeToggle"
                                         " wantConnect.SmeToggle"
                                         " line.SmeLine"
                                         " othersLabel.SmeLabel"
                                         " line.SmeLine"
                                         " analyzeSize.SmeBSB"
                                         " programSettings.SmeBSB"
                                         " stdout.SmeToggle"
                                         ")"
                                     ")"
                                 " commands.Command"
                                     "(commandMenu.SimpleMenu"
                                         "(analyzeButton.SmeBSB"
                                         " save.SmeBSB"
                                         " statsMe.SmeBSB.statsMe"
                                         ")"
                                     ")"
                                 " gamesButton.Toggle"
                                 " playersButton.Toggle"
                                 " messageButton.Toggle"
                                 " broadcastButton.Toggle"
                                 " yellButton.Toggle"
                                 " reviewsButton.Toggle"
                                 " eventsButton.Toggle"
                                 ")"
                             " times.Box"
                                 "(localTime.AsciiText     [string.localTime]"
                                 " universalTime.AsciiText [string.universalTime]"
                                 " serverTime.AsciiText    [string.serverTime]"
                                 ")"
                             " shortHelp.Label"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " quitConfirm.TopLevelShell"
                         "(buttons.Paned"
                             "(confirm.Label"
                             " confirmContainer.Paned"
                                 "(ok.Command"
                                 " filler.Core"
                                 " cancel.Command"
                                 ")"
                             ")"
                         ")"
                     " askString.TopLevelShell.askString [title.title][iconName.title]"
                         "(collect.Box"
                             "(user.Paned.user"
                                 "(userLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText"
                                     ")"
                                 ")"
                             " password.Paned.password"
                                 "(passwordLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText"
                                     ")"
                                 ")"
                             " sgfFilename.Paned.sgfFilename"
                                 "(sgfFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " psFilename.Paned.psFilename"
                                 "(psFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " kibitzFilename.Paned.kibitzFilename"
                                 "(kibitzFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " broadcastFilename.Paned.broadcastFilename"
                                 "(broadcastFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " yellFilename.Paned.yellFilename"
                                 "(yellFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " tellFilename.Paned.tellFilename"
                                 "(tellFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " serverFilename.Paned.serverFilename"
                                 "(serverFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " eventsFilename.Paned.eventsFilename"
                                 "(serverFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " mainFilename.Paned.mainFilename"
                                 "(mainFilenameLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.filename]"
                                     ")"
                                 ")"
                             " analyzeSize.Paned.analyzeSize"
                                 "(analyzeSizeLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.size]"
                                     ")"
                                 ")"
                             " replayTimeout.Paned.replayTimeout"
                                 "(replayTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " whoTimeout.Paned.whoTimeout"
                                 "(whoTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " gamesTimeout.Paned.gamesTimeout"
                                 "(gamesTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " reviewsTimeout.Paned.reviewsTimeout"
                                 "(reviewsTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " playersTimeout.Paned.playersTimeout"
                                 "(playersTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " serverTimeout.Paned.serverTimeout"
                                 "(serverTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " quitTimeout.Paned.quitTimeout"
                                 "(quitTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.timeout]"
                                     ")"
                                 ")"
                             " sortPlayersTimeout.Paned.sortPlayersTimeout"
                                 "(sortPlayersTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.sort]"
                                     ")"
                                 ")"
                             " sortGamesTimeout.Paned.sortGamesTimeout"
                                 "(sortGamesTimeoutLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.sort]"
                                     ")"
                                 ")"
                             " tersePlay.Paned.tersePlay"
                                 "(tersePlayLabel.Label"
                                 " textForm.Form"
                                     "(text.AsciiText[string.boolean]"
                                     ")"
                                 ")"
                             ")"
                         ")"
                     " popMessage.TopLevelShell.popMessage [title.title][iconName.title]"
                         "(collect.Paned"
                             "(message.Label[label.text]"
                             " ok.Command"
                             ")"
                         ")"
                     " players.TopLevelShell.players"
                         "(collect.Paned"
                             "(playerset.Box"
                             " stats.Label"
#ifndef   NOSTRIP
                             " stripform.Form"
                                 "(strip.StripChart"
                                 ")"
#endif /* NOSTRIP */
                             " info.AsciiText"
                             ")"
                         ")"
                     " games.TopLevelShell.games"
                         "(collect.Paned"
                             "(gameset.Box"
#ifndef   NOSTRIP
                             " stripform.Form"
                                 "(strip.StripChart"
                                 ")"
#endif /* NOSTRIP */
                             " info.AsciiText"
                             ")"
                         ")"
                     " reviews.TopLevelShell.reviews"
                         "(reviewset.Box[insertPosition.insertReview]"
                             "(reviewEntry.Command.reviewEntry"
                             " reviewEntryPending.Command.reviewEntryPending"
                             " reviewEntryDone.Command.reviewEntryDone"
                             ")"
                         ")"
                     " igsMessages.TopLevelShell.igsMessages"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(messageLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         ")"
                                     ")"
                                 " save.Command"
                                 ")"
                             " info.AsciiText"
                             ")"
                         ")"
                     " events.TopLevelShell.events"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(messageLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         ")"
                                     ")"
                                 " save.Command"
                                 ")"
                             " info.AsciiText"
                             ")"
                         ")"
                     " broadcasts.TopLevelShell.broadcasts"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(messageLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         ")"
                                     ")"
                                 " save.Command"
                                 ")"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " yells.TopLevelShell.yells"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(messageLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         ")"
                                     ")"
                                 " save.Command"
                                 " channels.Command"
                                 " channel.AsciiText"
                                 " moderator.AsciiText"
                                 " state.AsciiText"
                                 ")"
                             " title.AsciiText"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " tell.TopLevelShell.tell"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(messageLabel.SmeLabel"
                                         " line.SmeLine"
                                         " beep.SmeBell"
                                         " raise.SmeToggle"
                                         " line.SmeLine"
                                         " bugLabel.SmeLabel"
                                         " line.SmeLine"
                                         " bugBeep.SmeBell"
                                         " bugRaise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " fileLabel.SmeLabel"
                                         " line.SmeLine"
                                         " file.SmeBSB"
                                         " overwrite.SmeToggle"
                                         ")"
                                     ")"
                                 " save.Command"
                                 " bug.Command"
                                 " getStats.Command"
                                 ")"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " stats.TopLevelShell.stats"
                         "(collect.Box"
                             "(quit.Command"
                             " info.Label.info"
                             " text.Label.text[label.text]"
                             ")"
                         ")"
                     " review.TopLevelShell.review"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(observeMoveLabel.SmeLabel"
                                         " line.SmeLine"
                                         " moveBeep.SmeBell"
                                         " moveRaise.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzActionLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzBeep.SmeBell"
                                         " kibitzRaise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " sgfLabel.SmeLabel"
                                         " line.SmeLine"
                                         " sgfFile.SmeBSB"
                                         " sgfFromStart.SmeToggle"
                                         " sgfOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " psLabel.SmeLabel"
                                         " line.SmeLine"
                                         " psFile.SmeBSB"
                                         " psFromStart.SmeToggle"
                                         " psOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzFile.SmeBSB"
                                         " kibitzOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " othersLabel.SmeLabel"
                                         " line.SmeLine"
                                         " blink.SmeToggle"
                                         " replay.SmeToggle"
                                         ")"
                                     ")"
                                 " commands.Command"
                                     "(commandMenu.SimpleMenu"
                                         "(refresh.SmeBSB"
                                         " dup.SmeBSB"
                                         " analyze.SmeBSB"
                                         " sgfSave.SmeBSB"
                                         " psSave.SmeBSB"
                                         " kibitzSave.SmeBSB"
                                         ")"
                                     ")"
                                 " komi.Label     [label.komi]"
                                 " handicap.Label [label.handicap]"
                                 " captures.Label [label.captures]"
                                 " move.Label     [label.move]"
                                 " time.AsciiText [string.time]"
                                 ")"
                             " titleObserve.AsciiText[string.title]"
                             " scrollboard.Paned"
                                 "(scroll.Scrollbar"
                                 " board.Board [boardSize.boardSize]"
                                 ")"
                             " info.AsciiText"
                             ")"
                         ")"
                     " observe.TopLevelShell.observe"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(observeMoveLabel.SmeLabel"
                                         " line.SmeLine"
                                         " moveBeep.SmeBell"
                                         " moveRaise.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzActionLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzBeep.SmeBell"
                                         " kibitzRaise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " sgfLabel.SmeLabel"
                                         " line.SmeLine"
                                         " sgfFile.SmeBSB"
                                         " sgfFromStart.SmeToggle"
                                         " sgfOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " psLabel.SmeLabel"
                                         " line.SmeLine"
                                         " psFile.SmeBSB"
                                         " psFromStart.SmeToggle"
                                         " psOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzFile.SmeBSB"
                                         " kibitzOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " othersLabel.SmeLabel"
                                         " line.SmeLine"
                                         " blink.SmeToggle"
                                         " replay.SmeToggle"
                                         ")"
                                     ")"
                                 " commands.Command"
                                     "(commandMenu.SimpleMenu"
                                         "(refresh.SmeBSB"
                                         " observers.SmeBSB"
                                         " dup.SmeBSB"
                                         " analyze.SmeBSB"
                                         " sgfSave.SmeBSB"
                                         " psSave.SmeBSB"
                                         " kibitzSave.SmeBSB"
                                         " talkBlack.SmeBSB"
                                         " talkWhite.SmeBSB"
                                         " statsBlack.SmeBSB"
                                         " statsWhite.SmeBSB"
                                         ")"
                                     ")"
                                 " komi.Label     [label.komi]"
                                 " handicap.Label [label.handicap]"
                                 " captures.Label [label.captures]"
                                 " move.Label     [label.move]"
                                 " time.AsciiText [string.time]"
                                 ")"
                             " titleObserve.AsciiText[string.title]"
                             " scrollboard.Paned"
                                 "(scroll.Scrollbar"
                                 " board.Board [boardSize.boardSize]"
                                 ")"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " observe.TopLevelShell.play"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(observeMoveLabel.SmeLabel"
                                         " line.SmeLine"
                                         " moveBeep.SmeBell"
                                         " moveRaise.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzActionLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzBeep.SmeBell"
                                         " kibitzRaise.SmeToggle"
                                         " line.SmeLine"
                                         " errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " sgfLabel.SmeLabel"
                                         " line.SmeLine"
                                         " sgfFile.SmeBSB"
                                         " sgfFromStart.SmeToggle"
                                         " sgfOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " psLabel.SmeLabel"
                                         " line.SmeLine"
                                         " psFile.SmeBSB"
                                         " psFromStart.SmeToggle"
                                         " psOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " kibitzLabel.SmeLabel"
                                         " line.SmeLine"
                                         " kibitzFile.SmeBSB"
                                         " kibitzOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " othersLabel.SmeLabel"
                                         " line.SmeLine"
                                         " blink.SmeToggle"
                                         " replay.SmeToggle"
                                         ")"
                                      ")"
                                 " commands.Command"
                                     "(commandMenu.SimpleMenu"
                                         "(resume.SmeBSB"
                                         " adjourn.SmeBSB"
                                         " declineAdjourn.SmeBSB"
                                         " refresh.SmeBSB"
                                         " observers.SmeBSB"
                                         " dup.SmeBSB"
                                         " analyze.SmeBSB"
                                         " sgfSave.SmeBSB"
                                         " psSave.SmeBSB"
                                         " kibitzSave.SmeBSB"
                                         " talkBlack.SmeBSB"
                                         " talkWhite.SmeBSB"
                                         " statsBlack.SmeBSB"
                                         " statsWhite.SmeBSB"
                                         ")"
                                     ")"
                                 " undo.Command"
                                 " pass.Command"
                                 " done.Command"
                                 " komi.Label     [label.komi]"
                                 " handicap.Label [label.handicap]"
                                 " captures.Label [label.captures]"
                                 " move.Label     [label.move]"
                                 " time.AsciiText [string.time]"
                                 ")"
                             " titlePlay.AsciiText[string.title]"
                             " scrollboard.Paned"
                                 "(scroll.Scrollbar"
                                 " board.Board [boardSize.boardSize]"
                                 ")"
                             " info.AsciiText"
                             " input.AsciiText"
                             ")"
                         ")"
                     " analyzer.TopLevelShell.analyzer"
                         "(collect.Paned"
                             "(buttons.Box"
                                 "(quit.Command"
                                 " options.Command"
                                     "(optionMenu.SimpleMenu"
                                         "(errorLabel.SmeLabel"
                                         " line.SmeLine"
                                         " errorBeep.SmeBell"
                                         " errorRaise.SmeToggle"
                                         " line.SmeLine"
                                         " sgfLabel.SmeLabel"
                                         " line.SmeLine"
                                         " sgfFile.SmeBSB"
                                         " sgfFromStart.SmeToggle"
                                         " sgfOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " psLabel.SmeLabel"
                                         " line.SmeLine"
                                         " psFile.SmeBSB"
                                         " psFromStart.SmeToggle"
                                         " psOverwrite.SmeToggle"
                                         " line.SmeLine"
                                         " othersLabel.SmeLabel"
                                         " line.SmeLine"
                                         " blink.SmeToggle"
                                         ")"
                                     ")"
                                 " commands.Command"
                                     "(commandMenu.SimpleMenu"
                                         "(reset.SmeBSB"
                                         " analyze.SmeBSB"
                                         " sgfSave.SmeBSB"
                                         " psSave.SmeBSB"
                                         ")"
                                     ")"
                                 " undo.Command"
                                 " copy.Command"
                                 ")"
                             " scrollboard.Paned"
                                 "(scroll.Scrollbar"
                                 " board.Board [boardSize.boardSize]"
                                 ")"
                             ")"
                         ")"
                     ")"
                 ")",
    NULL
};
