%x ERROR

%{
#include <stdlib.h>
#include "mymalloc.h"

extern int   isatty(int fd);
static const char *Ptr;
static int         StrLength;

#define YYTEXT  ((char *) yytext)
#define YYLENG            yyleng
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size)                                 \
        if (max_size > StrLength) result = StrLength;                   \
        else                   result = max_size;                       \
        memcpy(buf, Ptr, result);                                       \
        Ptr += result;                                                  \
        StrLength -= result;
#define YY_BREAK

#include "widgettree.h"
#include "ywidgettree.tab.h"

TreeTemplate *TreeResult;
NameClassList NameBase;
extern int yyparse(void);
%}
WHITE             [ \t\f\v\r\n]
ID                [^ \[\]().,\n\t\f\v\r]+
DIGIT             [0-9]
NUM               ({DIGIT}+)
%%
{ID}                          { yylval.Name = mystrndup(YYTEXT, YYLENG);
                                return NAME; }
{WHITE}                       { break; }
.                             { return YYTEXT[0]; }

<ERROR>(.|\n){0,40}           { yylval.Name = mystrndup(YYTEXT, YYLENG);
                                yymore();
                                return NAME; }
%%
TreeTemplate *treeParse(const NameClassList Base, const char *Str, int Len)
{
    Ptr = Str;
    if (Len < 0) StrLength = strlen(Ptr);
    else         StrLength = Len;
    NameBase = Base;

    yy_init = 1;
    yyparse();
    return TreeResult;
}

char *TreeText(void)
{
    static char Error[42];

    BEGIN(ERROR);
    yymore();
    yylex();
    if (YYLENG < sizeof(Error)) strcpy(Error, yylval.Name);
    else {
        memcpy(Error, yylval.Name, sizeof(Error)-1);
        Error[sizeof(Error)-1] = 0;
    }
    myfree(yylval.Name);
    return Error;
}

/****************************************** flex fun **********************/
/*
void yy_flex_free(void *Data)
{
    myfree(Data);
}

void *yy_flex_alloc(int size)
{
    return mymalloc(size);
}

void *yy_flex_realloc(void *ptr, int size)
{
    return myrealloc(ptr, size);
}
*/

int yywrap(void)
{
    return 1;
}

/* Kludge to shut up some compiler warnings */
#include "except.h"
static void loopy(void)
{
    yy_flex_strcpy(NULL, NULL);
}

static void yy_flex_strcpy(char *s1, const char *s2)
{
    Raise1(AssertException, "flex kludge function called");
    yy_push_state(s1 == s2);
    yy_pop_state();
    yy_top_state();
    unput(' ');
    loopy();
}
