#ifndef GOINTER_H
# define GOINTER_H

# ifndef HAVE_NO_STDARG_H
extern void Warning(const char *Comment, ...);
# else  /* HAVE_NO_STDARG_H */
extern void Warning();
# endif /* HAVE_NO_STDARG_H */

extern int IgsYYparse(void);

typedef struct _NameVal {
    struct _NameVal *Next, *Previous;
    char            *Name;
    char            *Value;
} NameVal;

typedef struct _NumVal {
    struct _NumVal  *Next, *Previous;
    int              Num;
    char            *Value;
} NumVal;

typedef struct _NameList {
    struct _NameList *Next, *Previous;
    char             *Name;
} NameList;

typedef struct _NumNameListList {
    struct _NumNameListList *Next, *Previous;
    int                      Num;
    NameList                *Value;
} NumNameListList;

typedef struct _GameDesc {
    int   Id;
    char *BlackName,    *WhiteName;
    int   BlackCaptures, WhiteCaptures;
    int   BlackTime,     WhiteTime;
    int   BlackByo,      WhiteByo;
} GameDesc;

typedef struct ChannelData ChannelData;
extern NameList *NameListDup(const NameList *Model);
extern void FreeNameList(NameList *Header);
extern void FreeNameValList(NameVal *Header);
extern void FreeNumValList(NumVal *Header);
extern void FreeNumNameListList(NumNameListList *Header);
extern void FreeGameDesc(GameDesc *Desc);
#endif /* GOINTER_H */
