#ifndef CONNECT_H
# define CONNECT_H
# include <X11/Intrinsic.h>

typedef struct _Connection *Connection;
extern Connection Conn;

# ifndef   HAVE_NO_STDARG_H
extern       void SendCommand(Connection conn, XtPointer Context,
                              const char *Command, ...);
extern       void MoveCommand(Connection conn, const char *Command, ...);
extern       void UserSendCommand(Connection conn, XtPointer Context,
                                  const char *Command, ...);
extern       void AutoCommand(Connection conn, const char *Command, ...);
extern       void LastCommand(Connection conn, const char *Command, ...);
extern       void UserCommand(Connection conn, const char *Command, ...);
extern       void FirstCommand(Connection conn, const char *Command, ...);
extern       void ForceCommand(Connection conn, const char *Command, ...);
# else  /* HAVE_NO_STDARG_H */
extern       void SendCommand();
extern       void MoveCommand();
extern       void UserSendCommand();
extern       void AutoCommand();
extern       void LastCommand();
extern       void UserCommand();
extern       void FirstCommand();
extern       void ForceCommand();
# endif /* HAVE_NO_STDARG_H */

extern       void  SiteLogon(Connection conn, const char *Host);
extern const char *LogonSite(Connection conn);
extern const char *GetHostname(void);
extern const char *GetUserId(void);
extern        int  ConnectedP(Connection conn);
extern        int  GetInput(Connection conn, char *buffer, int size);
extern       void  InitConnect(Widget toplevel);
extern       void  CleanConnect(void);
extern       void  ReConnect(Connection conn);
extern Connection  Connect(const char *Site, int Port);
extern const char *Parsing(Connection conn);
extern       void  RemoveMoves(Connection conn);
extern       void  SetCommand(Connection conn, int value);
extern       void  ChangeCommand(Connection conn, int value);
extern       void  ResyncCommand(Connection conn);
extern       void  ConnectTime(long Diff);
extern        int  WhatCommand(Connection conn, const char *Command);
extern const char *ArgsCommand(Connection conn, const char *Command);
extern const char *StripArgsCommand(Connection conn, const char *Command);
extern const char *StripFirstArgCommand(Connection conn, const char *Command);
extern        int UserCommandP(Connection conn);
extern XtPointer  CommandClosure(Connection conn);
extern       void CallSendCommand(Widget w,
                                  XtPointer clientdata, XtPointer calldata);
#endif /* CONNECT_H */

