/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  global.h                                                *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

#define XK_MISCELLANY
#define XK_LATIN1

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/keysymdef.h>
#include <X11/xpm.h>

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <errno.h>

typedef int BOOL;

#define TRUE		1
#define FALSE		0

#define MIN(a,b) 	(((a)<(b))?(a):(b))
#define MAX(a,b) 	(((a)>(b))?(a):(b))
#define ABS(a)		(((a)<0)?(-a):(a))

#define WIN_XPOS	0
#define WIN_YPOS	0
#define WIN_XSIZE	640
#define WIN_YSIZE	400
#define FIELDX		16
#define FIELDY		12

#define BACK		0
#define DOOR		1
#define	FONTBIG		2
#define FONTSMALL	3
#define MAGICOLOR	4
#define DB_BACK		5
#define DB_DOOR		6

#define NUM_XPM		5
#define NUM_PIXMAPS	7

#define MAX_PLAYERS	10
#define MAX_NAMELEN	10+1

struct picture
{
  char *name;
  char *name2;
};

struct DamageList
{
  int Nr,Wk;
  int XP,YP;
  int Mr;
};

struct HiScore
{
  char Name[8];
  int Score;
};

struct PacMan
{
  int XP,YP;
  int Dr;
};

struct XY
{
  int x,y;
};

#ifndef MAIN_H
extern struct 		picture pic[];

extern Display	       *display;
extern int		screen;
extern Window  		window;
extern GC      		gc, line_gc[2];
extern GC		clip_gc[];
extern XImage 	       *image[];
extern Pixmap		clipmask[];
extern Pixmap		pix[];
extern XImage	       *imagemask;
extern XpmAttributes 	xpm_att[];
extern Drawable    	drawto;
extern Colormap		cmap;

extern int		sound_pipe[2];
extern int		sound_device;
extern char	       *sound_device_name;
extern int     		width, height;
extern unsigned long	pen_fg, pen_bg, pen_ray, pen_magicolor[2];

extern int		game_status;
extern int		button_status;
extern int		color_status;
extern int		sound_status, sound_on;
extern int		toons_status;

extern BOOL		redraw[16][12];
extern int		redraw_mask;
extern int		redraw_tiles;

extern char		AkName[MAX_NAMELEN], Names[MAX_PLAYERS][MAX_NAMELEN];
extern int		Ray[FIELDX][FIELDY], Ur[FIELDX][FIELDY];
extern int		Hit[FIELDX][FIELDY], Box[FIELDX][FIELDY];
extern int		level, actual_level, leveltime;
extern int		handicap[MAX_PLAYERS];
extern int		player_nr;

extern struct DamageList	DamList[300],G[2],First;
extern struct HiScore		highscore[MAX_PLAYERS];
extern struct PacMan		Pac[192],Cyc[192];
extern struct XY		Step[16];

extern short		Sign[16];
extern short		Els[];

extern short 		RayList[300][2];
extern short 		RP,DP,GP,DR,SC,OV,AW;
extern short 		DBM,ABM,TWO,MS2,PLY,IRQ,SPK;
extern short 		SR,PM,EL,EN,LW,BL,SL,LP,WN,PT,DO,OB,BK,S1,RT,RY;
extern short		SRx,SRy;
extern short 		LX,LY,XS,YS,EX,EY, OK,BT,MT,OL,CR,MB,CB,CC[4];
extern short 		Pal,r,d,x,y,k,l,ll;
extern short 		Sprite[3],EC,Ec,OC,Oc,PC,Pc,CT,Ct,i,j;

extern char	       *progname;
#endif


/* often used screen positions */
#define SX		8
#define SY		8
#define DX		534
#define DY		60
#define TILEX		32
#define TILEY		32
#define SXSIZE		FIELDX*TILEX
#define SYSIZE		FIELDY*TILEY
#define DXSIZE		100
#define DYSIZE		280

/* values for cartoon figures */
#define DWARF_X		6
#define DWARF_Y		290
#define DWARF_XSIZE	40
#define DWARF_YSIZE	48
#define JUMPER_X	6
#define JUMPER_Y	338
#define JUMPER_XSIZE	48
#define JUMPER_YSIZE	56
#define CLOWN_X		442
#define CLOWN_Y		284
#define CLOWN_XSIZE	80
#define CLOWN_YSIZE	110
#define BIRD_X		8
#define BIRD_Y		232
#define BIRD_XSIZE	32
#define BIRD_YSIZE	30

#ifdef NO_TOONS
#define TOONS_STATUS	FALSE
#else
#define TOONS_STATUS	TRUE
#endif

/* font type and colors */
#define FS_SMALL	0
#define FS_BIG		1
#define FC_RED		0
#define FC_BLUE		1
#define FC_GREEN	2
#define FC_YELLOW	3

/* values for game_status */
#define MAINMENU	0
#define PLAYING		1
#define LEVELED		2
#define HELPSCREEN	3
#define CHOOSENAME	4
#define TYPENAME	5
#define HALLOFFAME	6
#define EXITGAME	7

/* values for color_status */
#define STATIC_COLORS	0
#define	DYNAMIC_COLORS	1

/* values for sound_status */
#define SND_AMOEBE	0
#define SND_ANTIGRAV	1
#define SND_AUTSCH	2
#define SND_BONG	3
#define SND_FUEL	4
#define SND_HALLOFFAME	5
#define SND_HOLZ	6
#define SND_HUI		7
#define SND_KABUMM	8
#define SND_KINK	9
#define SND_KLING	10
#define SND_LASER	11
#define SND_OEFFNEN	12
#define SND_QUIEK	13
#define SND_RHYTHMLOOP	14
#define SND_ROAAAR	15
#define SND_SIRR	16
#define SND_SLURP	17
#define SND_VOYAGER	18
#define SND_WARNTON	19
#define SND_WHOOSH	20

#define NUM_SOUNDS	21

#define SOUND_OFF	0
#define	SOUND_AVAILABLE	1

#ifndef SND_PATH
#define SND_PATH	"./sounds"
#endif

#define DEV_AUDIO	"/dev/audio"
#define DEV_DSP		"/dev/dsp"

#ifdef	SNDDEV_DSP
#define SOUND_DEVICE   	DEV_DSP
#else
#define SOUND_DEVICE	DEV_AUDIO
#endif

#ifdef NO_SOUNDS
#define SOUND_STATUS	SOUND_OFF
#else
#define SOUND_STATUS	SOUND_AVAILABLE
#endif

#ifndef GFX_PATH
#define GFX_PATH	"./graphics"
#endif

#ifndef CFG_PATH
#define CFG_PATH	"."
#endif
#define LEVEL_NAME	"RAY.level"
#define SCORE_NAME	"RAY.score"
#define NAMES_NAME	"RAY.names"
#define LEVEL_FILE	CFG_PATH "/" LEVEL_NAME
#define SCORE_FILE	CFG_PATH "/" SCORE_NAME
#define NAMES_FILE	CFG_PATH "/" NAMES_NAME

/* values for button_status */
#define MB_UNPRESSED  	0
#define MB_PRESSED   	(button_status+!button_status)
#define MB_LEFT		1
#define MB_MIDDLE	2
#define MB_RIGHT	3

/* values for redraw_mask */
#define REDRAW_ALL	(1L<<0)
#define REDRAW_FIELD	(1L<<1)
#define REDRAW_TILES	(1L<<2)
#define REDRAW_DOOR	(1L<<3)
#define REDRAWTILES_TH	FIELDX*FIELDY/2

/* I have forgotten what these values stand for... */
#define glx 		38
#define gly 		24
#define gbx 		30
#define gby 		64
#define gsx 		24
#define gsy 		102
#define gex 		8
#define gey 		158
#define gox 		60
#define goy 		158
#define geey 		(gey+98)
#define goey 		(goy+100)
#define GLX 		(DX+glx)
#define GLY 		(DY+gly)
#define GBX 		(DX+gbx)
#define GBY 		(DY+gby)
#define GSX 		(DX+gsx)
#define GSY 		(DY+gsy)
#define GEX 		(DX+gex)
#define GEY 		(DY+gey)
#define GOX 		(DX+gox)
#define GOY 		(DY+goy)
#define GEEY 		(DY+geey)
#define GOEY 		(DY+goey)

/* sound control */
#define ST(x) 		(-(x)-1)
#define SOUNDS 		19

#endif
