
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#ifndef _XLCHIP
#define _XLCHIP
 
#include "xlscroll.h"


/*
 *
 *      -----  win_scroll ---- win_chip
 *
 *
 */

#define SPRITE_MAX            1024

class win_cmap;
class win_chip : public win_scroll{

    /*************************** chip ***************************/
    
  protected:
    GC set_gc, and_gc, or_gc;
    int csx,csy;
    Pixmap p_store;
    Pixmap chip, chip_mask;
    struct _sprite{
        int x, y, h, v;
    } sprite[SPRITE_MAX];
    _sprite *spr_max;
    
  public:
    win_chip(int vsizex, int vsizey, int csizex = 320, int csizey = 240); 
    ~win_chip();
    void make(win *back, int wx, int wy, int sizex, int sizey);
    void torus_copy_from_chip_and_store(int x, int y, int h, int v,
                                        int x1, int x2);
    inline void copy_from_chip_sprite(int x, int y, int h, int v,
                                      int x1, int x2);
    void store();
    void restore();
    friend int link_tiff(unsigned char *data,
                               win_cmap& wcm, win_chip& wch);
    friend int load_tiff(char *file_name,
                               win_cmap& wcm, win_chip& wch);
};

inline void win_chip::copy_from_chip_sprite(int x, int y, int h, int v,
                                            int x1, int x2)
{
    XCopyArea(disp, chip_mask, p, and_gc, x, y, h, v, x1, x2);
    XCopyArea(disp, chip,      p, or_gc,  x, y, h, v, x1, x2);
    spr_max->x = x1;
    spr_max->y = x2;
    spr_max->h = h;
    spr_max->v = v;
    spr_max++;
}

#endif // _XLCHIP
