
/*
 * XKOBO, a video-oriented game
 * Copyright (C) 1995  Akira Higuchi
 *     a-higuti@math.hokudai.ac.jp
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdlib.h>
#include "xkobo.h"
#include "screen.h"
#include "myship.h"
#include "radar.h"

int _radar::sx = MAP_SIZEX;
int _radar::sy = MAP_SIZEY;
int _radar::mx_old;
int _radar::my_old;


void _radar::prepare()
{
    int i, j;
    wradar.foreground(RADAR_FOREGROUND1);
    wradar.background(RADAR_BACKGROUND);
    wradar.clear();
    for (i=0; i<sx; i++)
      for (j=0; j<sy; j++){
          int a = screen.get_chip_number(i, j);
          if (a == CORE){
              wradar.foreground(RADAR_FOREGROUND1);
              wradar.point_back(i, j);
          }
          else if ((a==U_MASK) || (a==R_MASK) || (a==D_MASK) || (a==L_MASK)){
              wradar.foreground(RADAR_FOREGROUND2);
              wradar.point_back(i, j);
          }
          else if ((a & HIT_MASK)){
              wradar.foreground(RADAR_FOREGROUND2);
              wradar.point_back(i, j);
          }
      }
    wradar.back();
    mx_old = -1;
    my_old = -1;
}

void _radar::erase(int x, int y)
{
    wradar.foreground(RADAR_BACKGROUND);
    wradar.point(x, y);
}

void _radar::trace_myship()
{
    int mx_new = (myship.get_x() & (SCREEN_SIZEX-1)) >> 4;
    int my_new = (myship.get_y() & (SCREEN_SIZEY-1)) >> 4;
    if ((mx_new == mx_old) && (my_new == my_old)) return;
    if (screen.get_chip_number(mx_new, my_new) != SPACE) return;
    wradar.foreground(RADAR_FOREGROUND0);
    wradar.point(mx_new, my_new);
    if (mx_old >= 0){
        wradar.foreground(RADAR_BACKGROUND);
        wradar.point(mx_old, my_old);
    }
    mx_old = mx_new;
    my_old = my_new;
}
