/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef TRUECOLOR


inline void draw_wall_slice(Pixel *start, Pixel *end, Pixel *tex_base,
			    fixed tex_y, fixed tex_dy, int fb_width, 
			    int tex_height, int npix)
{
     int count = start - end;

     
     if (npix < 0)
	  return;

     if (tex_height == 64) {
	  tex_y <<= 10;
	  tex_dy <<= 10;

__asm__ volatile("movl %6, %%ebp\n\t"
		 "andl $3, %%eax\n\t"
		 "jz   4f\n\t"
		 "cmpl $1, %%eax\n\t"
		 "je   3f\n\t"
		 "cmpl $2, %%eax\n\t"
		 "je   2f\n\t"
		 "\t1:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t2:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "\t3:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t4:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "jns   1b\n"
		 :
		 :"b" (count), "c" (tex_base), "d" (tex_dy),
		  "S" (end), "D" (tex_y), "a" (npix), "m" (fb_width)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );

} else {
     tex_y <<= 9;
     tex_dy <<= 9;

__asm__ volatile("movl %6, %%ebp\n\t"
		 "andl $3, %%eax\n\t"
		 "jz   4f\n\t"
		 "cmpl $1, %%eax\n\t"
		 "je   3f\n\t"
		 "cmpl $2, %%eax\n\t"
		 "je   2f\n\t"
		 "\t1:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t2:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "\t3:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t4:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax), %%al\n\t"
		 "movb %%al, (%%esi,%%ebx)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "jns   1b\n"
		 :
		 :"b" (count), "c" (tex_base), "d" (tex_dy),
		  "S" (end), "D" (tex_y), "a" (npix), "m" (fb_width)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );
     }
}


inline void draw_floor_slice(Pixel *start, Pixel *tex,
			     fixed x, fixed y, fixed dx, fixed dy,
			     int tex_width)
{
     if (*start != 0xff)
	  return;

     if (tex_width == 128) {
	  
	  y <<= 9;
	  dy <<= 9;
	  x <<= 2;
	  dx <<= 2;

__asm__ volatile("movl %%ecx, %%ebp\n"
		 "\t1:\n\t"
		 "movl %%edx, %%ecx\n\t"
		 "andl $0x01ffffff, %%eax\n\t"
		 "andl $0xfe000000, %%ecx\n\t"
		 "addl %%eax, %%ecx\n\t"
		 "shrl $18, %%ecx\n\t"
		 "addl %%ebp, %%edx\n\t"
		 "movb (%%edi,%%ecx), %%cl\n\t"
		 "movb %%cl, (%%ebx)\n\t"
		 "incl %%ebx\n\t"
		 "addl %%esi, %%eax\n\t"
		 "cmpb $0xff, (%%ebx)\n\t"
		 "je   1b\n"
		 :
                 :"b" (start), "D" (tex), "a" (x), "d" (y), "S" (dx), "c" (dy)
		 :"eax", "ebx", "ecx", "edx", "edi", "esi", "ebp" );

     } else {
	  
	  y <<= 10;
	  dy <<= 10;
	  x <<= 4;
	  dx <<= 4;

__asm__ volatile("movl %%ecx, %%ebp\n"
		 "\t1:\n\t"
		 "movl %%edx, %%ecx\n\t"
		 "andl $0x03ffffff, %%eax\n\t"
		 "andl $0xfc000000, %%ecx\n\t"
		 "addl %%eax, %%ecx\n\t"
		 "shrl $20, %%ecx\n\t"
		 "addl %%ebp, %%edx\n\t"
		 "movb (%%edi,%%ecx), %%cl\n\t"
		 "movb %%cl, (%%ebx)\n\t"
		 "incl %%ebx\n\t"
		 "addl %%esi, %%eax\n\t"
		 "cmpb $0xff, (%%ebx)\n\t"
		 "je   1b\n"
		 :
		 :"b" (start), "D" (tex), "a" (x), "d" (y), "S" (dx), "c" (dy)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );
     }
}


#else /* TRUECOLOR */


inline void draw_wall_slice(Pixel *start, Pixel *end, Pixel *tex_base,
			    fixed tex_y, fixed tex_dy, int fb_width, 
			    int tex_height, int npix)
{
     int count = start - end;

     
     if (npix < 0)
	  return;

     if (tex_height == 64) {
	  tex_y <<= 10;
	  tex_dy <<= 10;

__asm__ volatile("movl %6, %%ebp\n\t"
		 "andl $3, %%eax\n\t"
		 "jz   4f\n\t"
		 "cmpl $1, %%eax\n\t"
		 "je   3f\n\t"
		 "cmpl $2, %%eax\n\t"
		 "je   2f\n\t"
		 "\t1:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t2:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "\t3:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t4:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $26, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movb (%%ecx,%%eax,2), %%ax\n\t"
		 "movb %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "jns   1b\n"
		 :
		 :"b" (count), "c" (tex_base), "d" (tex_dy),
		  "S" (end), "D" (tex_y), "a" (npix), "m" (fb_width)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );

} else {
     tex_y <<= 9;
     tex_dy <<= 9;

__asm__ volatile("movl %6, %%ebp\n\t"
		 "andl $3, %%eax\n\t"
		 "jz   4f\n\t"
		 "cmpl $1, %%eax\n\t"
		 "je   3f\n\t"
		 "cmpl $2, %%eax\n\t"
		 "je   2f\n\t"
		 "\t1:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t2:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "\t3:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n"
		 "\t4:\n\t"
		 "movl %%edi, %%eax\n\t"
		 "shrl $25, %%eax\n\t"
		 "addl %%edx, %%edi\n\t"
		 "movw (%%ecx,%%eax,2), %%ax\n\t"
		 "movw %%ax, (%%esi,%%ebx,2)\n\t"
		 "subl %%ebp, %%ebx\n\t"
		 "jns   1b\n"
		 :
		 :"b" (count), "c" (tex_base), "d" (tex_dy),
		  "S" (end), "D" (tex_y), "a" (npix), "m" (fb_width)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );
     }
}


inline void draw_floor_slice(Pixel *start, Pixel *tex,
			     fixed x, fixed y, fixed dx, fixed dy,
			     int tex_width)
{
     if (*start != 0xffff)
	  return;

     if (tex_width == 128) {
	  
	  y <<= 9;
	  dy <<= 9;
	  x <<= 2;
	  dx <<= 2;

__asm__ volatile("movl %%ecx, %%ebp\n"
		 "\t1:\n\t"
		 "movl %%edx, %%ecx\n\t"
		 "andl $0x01ffffff, %%eax\n\t"
		 "andl $0xfe000000, %%ecx\n\t"
		 "addl %%eax, %%ecx\n\t"
		 "shrl $18, %%ecx\n\t"
		 "addl %%ebp, %%edx\n\t"
		 "movw (%%edi,%%ecx,2), %%cx\n\t"
		 "movw %%cx, (%%ebx)\n\t"
		 "addl $2, %%ebx\n\t"
		 "addl %%esi, %%eax\n\t"
		 "cmpw $0xffff, (%%ebx)\n\t"
		 "je   1b\n"
		 :
                 :"b" (start), "D" (tex), "a" (x), "d" (y), "S" (dx), "c" (dy)
		 :"eax", "ebx", "ecx", "edx", "edi", "esi", "ebp" );

     } else {
	  
	  y <<= 10;
	  dy <<= 10;
	  x <<= 4;
	  dx <<= 4;

__asm__ volatile("movl %%ecx, %%ebp\n"
		 "\t1:\n\t"
		 "movl %%edx, %%ecx\n\t"
		 "andl $0x03ffffff, %%eax\n\t"
		 "andl $0xfc000000, %%ecx\n\t"
		 "addl %%eax, %%ecx\n\t"
		 "shrl $20, %%ecx\n\t"
		 "addl %%ebp, %%edx\n\t"
		 "movw (%%edi,%%ecx,2), %%cx\n\t"
		 "movw %%cx, (%%ebx)\n\t"
		 "addl $2, %%ebx\n\t"
		 "addl %%esi, %%eax\n\t"
		 "cmpw $0xffff, (%%ebx)\n\t"
		 "je   1b\n"
		 :
		 :"b" (start), "D" (tex), "a" (x), "d" (y), "S" (dx), "c" (dy)
		 :"eax", "ebx", "ecx", "edx", "esi", "edi", "ebp" );
     }
}

#endif  /* TRUECOLOR */
