// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.


#include "Explosion.h"


PtrList<Explosion> Boom::list;


Explosion::Explosion( int xp, int yp, int size, int dur,
		      double xv, double yv )
		      : Vsize(size), Life(dur)
	{
	if (Vsize > BMAX) Vsize=BMAX;
	
	register int i;
	
	for(i=0; i<Vsize; i++)
		{
		Vbit[i].setPos(xp,yp);
		Vbit[i].randomDir( (rand()>>2)%7 + 3 );
		Vbit[i].addVel( xv, yv );
		}
	}

void Boom::tick()
	{
    	Explosion* e;
    	list.gotoFirst();
    	while ( (e=list.current())!=NULL)
    		{
    		e->tick(); 
    		if (!e->isAlive()) list.remove();
    		else	list.gotoNext();
    		}
    	}

void Boom::draw()
	{
    	Explosion* e;
    	list.gotoFirst();
    	while ( (e=list.current())!=NULL)
    		{
    		e->draw(); 
    		list.gotoNext();
    		}
    	}

