/*
 * Keyboard handling
 *
 * Copyright (C) Evan Harris, 1994, 1995.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include <vga.h>
#include "key.h"

/*
 * We probably should use the svgalib keyboard_() functions, but the warnings
 * scared me.  8-)
 */

int
key_getkey()
{
    int key;

    if ((key = vga_getkey()) != 0x1b) {
	return key;		/* not ESC */
    }
    if ((key = vga_getkey()) != '[') {
	return 0x1b;		/* it was ESC */
    }
    switch (key = vga_getkey()) {
      case 'A':
	return KEY_CURSORUP;	/* up */
      case 'B':
	return KEY_CURSORDOWN;	/* down */
      case 'C':
	return KEY_CURSORRIGHT;	/* right */
      case 'D':
	return KEY_CURSORLEFT;	/* left */
      default:
	return -1;		/* ignore */
	break;
    }
}
