/*
 * Card games
 *
 * Copyright (C) Evan Harris, 1994, 1995.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include <stdlib.h>
#include <time.h>
#include <vga.h>

#include "common.h"


void
EndDisplay()
{
    vga_setmode(TEXT);
#if defined(CARDSMOUSE)
    mouse_close();
#endif    
}


void
InitRandom(unsigned char state)
{
    static long seed;
    
    if (state == NEW) {
	seed = time(NULL);
    }
    srand48(seed);
}


long
Random(long max)
{
    return lrand48() % max;
}
