/*
 * Imperium
 *
 * (C) 1990-91 by David Wright
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ImpLib.h,v 3.4.1.2 1993/11/23 04:44:26 davewt Exp $
 *
 * $Log: ImpLib.h,v $
 * Revision 3.4.1.2  1993/11/23  04:44:26  davewt
 * patch4: Change for IMPERIUM_PRIVATE_SIZE.
 *
 * Revision 3.4.1.1  1993/11/19  06:22:29  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:01:26  davewt
 * New revision.
 *
 * Revision 3.3  1993/10/16  04:33:11  davewt
 * New  release.
 *
 * Revision 3.2  1993/10/07  02:06:22  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:51:55  davewt
 * patch1: First patch to initial version.
 *
 * Revision 1.1  1993/08/25  02:07:02  davewt
 * Initial revision
 *
 * Revision 1.27  1992/12/19  22:52:33  DaveWT
 * Change for size again...
 *
 * Revision 1.26  1992/11/29  15:08:23  DaveWT
 * Change for IMP_PRIVATE_SIZE
 *
 * Revision 1.25  1992/11/25  04:50:22  DaveWT
 * Change for the private size
 *
 * Revision 1.24  1992/07/29  22:27:38  DaveWT
 * Change to IMP_PRIVATE_SIZE
 *
 * Revision 1.23  1992/02/01  23:04:06  DaveWT
 * Now has the rq_text[] field.
 *
 * Revision 1.22  92/01/30  23:51:18  DaveWT
 * Dumb mistake
 * 
 * Revision 1.21  92/01/30  23:38:21  DaveWT
 * Had to change the size of the request structure for the new specialFlags field
 * 
 * Revision 1.20  92/01/08  21:44:27  DaveWT
 * Changes for the new fields is_conWidth and is_conLength
 * 
 * Revision 1.19  92/01/07  22:38:34  DaveWT
 * Changed IMP PRIVATE size for the expanded random number seed.
 * 
 * Revision 1.18  91/12/27  22:35:08  DaveWT
 * Added the new is_specialFlags stuff
 * 
 * Revision 1.17  91/12/26  23:10:29  DaveWT
 * Now supports reading the stack size desired for clients
 * 
 * Revision 1.16  91/10/01  23:09:34  DaveWT
 * Added is_argPoint
 * 
 * Revision 1.15  91/10/01  22:53:46  DaveWT
 * Now has the is_extEdit() function in ImpState_t
 * 
 *
 */

/*
 * ImpLib.h - definitions for using the Imperium library.
 */

#define IMPERIUM_PORT	"imperium.port"
#define IMP_TEST_PORT	"imp.test.port"

#define INPUT_BUFFER_SIZE       500
#define OUTPUT_BUFFER_SIZE      500
#define REQUEST_PRIVATE_SIZE    2048
#define IMPERIUM_PRIVATE_SIZE   2642

/* Alas, I would like to use an enum type, but that wastes 3 bytes */
#define rt_nop          0       /* no operation                     */
#define rt_log          1       /* log a string                     */
#define rt_startClient  2       /* start a new client               */
#define rt_stopClient   3       /* stop this client                 */
#define rt_shutDown     4       /* shut down the server             */
#define rt_flush        5       /* request flush of all data        */
#define rt_poll         6       /* check to see if we should exit   */
#define rt_writeWorld   7       /* write out the world buffer       */

    /* Please note the following request types are NOT for */
    /* "normal" client program uses!                       */
#define rt_acOut        8       /* AC power is out - for utilities  */
#define rt_acBack       9       /* AC power came back online        */
#define rt_battLow      10      /* UPS battery is low, exit immed.  */
#define rt_backStart    80      /* request a backup lock on the     */
                                /* system. Will NOT return until OK */
                                /* to start the backup              */
#define rt_backDone     81      /* indicate to the server you are   */
                                /* done with a backup               */
#define rt_broadcastMsg 82      /* send a message to all clients    */

  /* note that there are many others that are private! */
typedef UBYTE RequestType_t;

typedef struct
    {
        ULONG
                    rq_clientId,        /* id of this client            */
                    rq_time,            /* time from server             */
                    rq_whichUnit,       /* unit identifier              */
                    rq_otherUnit,       /* identifier of other in pair  */
                    rq_specialFlags;    /* special flags - CAUTION      */
        RequestType_t
                    rq_type;            /* type of request              */
        char        rq_text[133];       /* holds C-style string to be   */
                                        /* broadcast w/rt_broadcastMsg  */
        char rq_private[REQUEST_PRIVATE_SIZE];
        /* rq_private is 'char' so we can use it for rt_log requests    */
    } Request_t;

/*
 * Special flag definitions for use in the "is_specialFlags" field in
 *          ImpState_t.
 *          Note that some of these flags may be set by clients or
 *          the library itself. Please check for and honor them
 *          even if you didn't set them yourself!
 */

#define ISF_NONE      0x00L /* no flags set                             */
#define ISF_POW_WARN  0x01L /* Please log out, AC power out. This       */
                            /* should be broadcasted to the user every  */
                            /* 3 or 4 commands.                         */
#define ISF_POW_CRIT  0x02L /* Log out right away, battery power low.   */
                            /* This should be broadcasted to the user   */
                            /* EVERY command, and possibly FORCE a      */
                            /* log out after the 3rd or 4th time.       */
#define ISF_SERV_DOWN 0x04L /* Please log out, the server wants to go   */
                            /* down. This is just a general request     */
                            /* which you should broadcast every 5 or 10 */
                            /* commands                                 */
#define ISF_OFF_IMM   0x08L /* Log out immediately                      */
#define ISF_BACKUP    0x10L /* System wants to do a backup              */


/*
 * ImpState_t - The main "Imperium State" structure
 */

typedef struct
    {
        /* fields used to interface to the library caller */

        void (*is_serverRequest)(void);
        void (*is_writeUser)(void);
        void (*is_readUser)(void);
        void (*is_timedReadUser)(void); /* This is basically the same as */
                                        /* readUser, but should time out */
                                        /* after 1 sec or so if the user */
                                        /* does not start typing or the  */
                                        /* input line is empty           */
        void (*is_echoOff)(void);
        void (*is_echoOn)(void);
        void (*is_gotControlC)(void);
        void (*is_sleep)(void);
        void (*is_log)(void);
        void (*is_extEdit)(void);
        Request_t   is_request;
        char        is_textIn[INPUT_BUFFER_SIZE];
        char        is_textOut[OUTPUT_BUFFER_SIZE];
        char        *is_textInPos;
        USHORT      is_textOutPos;

        /* the next two fields are READ ONLY for clients and reflect    */
        /* the users desired screen size. These will be valid as soon   */
        /* as the "last on" message is displayed when the user logs in  */
        USHORT      is_conWidth,
                    is_conLength;   /* for both these fields '0' values */
                                    /* indicate the user does not want  */
                                    /* that feature activated           */


        /* the next fields hold values used for communication with the  */
        /* call-back functions */
        BOOL        is_argBool;     /* used to hold BOOL values         */
        USHORT      is_argShort;    /* used to hold short values        */
        ULONG       is_argLong;     /* used to hold long values         */
        ULONG       is_specialFlags;/* special flags, see above         */
        char       *is_argPoint;    /* used to hold char pointer values */

        /* fields private to the Imperium library itself */

        UBYTE       is_impPrivate[IMPERIUM_PRIVATE_SIZE];
    } ImpState_t;
#define IMP register ImpState_t *IS

extern void ImpCntrl(register ImpState_t *);
extern ImpState_t *ImpAlloc(void);
extern void ImpFree(register ImpState_t *);
extern void Imperium(register ImpState_t *);
