/* $Id: tf.h,v 30000.22 1993/05/18 08:58:21 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef TF_H
#define TF_H

/****************************************
 * TinyFugue global types and variables. *
 ****************************************/

#define SAVEGLOBAL    1000     /* global history size */
#define SAVEWORLD     1000     /* world history size */
#define SAVELOCAL      100     /* local history size */
#define SAVEINPUT       50     /* command history buffer size */
#define WATCHLINES       5     /* number for watchdog to change */
#define NAMEMATCHNUM     4     /* ask to gag if this many last lines by same */
#define STRINGMATCHNUM   2     /* ignore if this many of last lines identical */
#define MAXQUIET        25     /* max # of lines to suppress during login */

#define PRIVATEINIT    "~/.tfrc"
#define CONFIGFILE     "~/.tinytalk"          /* for backward compatibility */

typedef void NDECL((NFunc));
typedef int FDECL((Handler),(char *arguments));
#define HANDLER(name) int FDECL(name,(char *arguments))
typedef void NDECL((Toggler));
#define TOGGLER(name) void NDECL(name)
typedef int FDECL(Cmp,(CONST GENERIC *, CONST GENERIC *)); /* generic compare */

typedef char smallstr[65];     /* Short buffer */

typedef struct Aline {         /* shared line, with attributes */
    char *str;
    short links, attrs;
    TIME_T time;
} Aline;

#define Queue List

#define F_NORM       00001
#define F_GAG        00002
#define F_NOHISTORY  00004
#define F_SUPERGAG   (F_GAG | F_NOHISTORY)
#define F_UNDERLINE  00010
#define F_REVERSE    00020
#define F_FLASH      00040
#define F_DIM        00100
#define F_HILITE     00200
#define F_BELL       00400
#define F_BOLD       01000
#define F_ALL        01777
#define F_NEWLINE    02000
#define F_INDENT     04000

#include "malloc.h"
#include "tfio.h"
#include "variable.h"

#endif /* TF_H */
