/* $Id: socket.h,v 30000.20 1993/05/04 22:39:36 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef SOCKET_H
#define SOCKET_H

#include "world.h"

#define SOCKDEAD     0001      /* connection dead */
#define SOCKPENDING  0002      /* connection not yet established */
#define SOCKLOGIN    0004      /* autologin */
#define SOCKACTIVE   0010      /* text has arrived but not been displayed */
#define SOCKEOR      0020      /* server will send EOR after prompts */
#define SOCKECHO     0040      /* do local keyboard echo */
#define SOCKEDIT     0100      /* do local editing */
#define SOCKTRAP     0200      /* do local signal trapping */
#define SOCKLINEMODE 0400      /* do telnet LINEMODE negotiation */

typedef struct Sock {          /* an open connection to a world */
    int fd;                    /* socket to tf.connect or world */
    FILE *fp;                  /* pipe to connector */
    short flags;
    short numquiet;            /* # of lines to suppress after connecting */
    struct World *world;       /* world to which socket is connected */
    struct Sock *next, *prev;
    Stringp current_output;
    char state;
} Sock;


extern void NDECL(init_sock);
extern void NDECL(main_loop);
extern int  FDECL(is_active,(int fd));
extern void FDECL(readers_clear,(int fd));
extern void FDECL(readers_set,(int fd));
extern TOGGLER(tog_background);
extern void FDECL(mapsock,(void FDECL((*func),(struct World *world))));
extern struct World *NDECL(fworld);
extern struct World *NDECL(xworld);
extern void FDECL(background_hook,(char *line));
extern int  FDECL(connect_to,(struct World *w, int autologin));
extern int  FDECL(disconnect,(char *args));
extern void FDECL(movesock,(int dir));
extern void NDECL(no_sock);
extern void NDECL(disconnect_all);
extern void NDECL(listsockets);
extern void FDECL(world_output,(struct World *w, char *str, int attrs));
extern int  FDECL(do_send,(char *args));
extern int  FDECL(transmit,(char *s, unsigned int len));
extern void NDECL(clear_refresh_pending);
extern void NDECL(set_refresh_pending);
extern int  NDECL(is_refresh_pending);
extern void NDECL(set_done);

#endif /* SOCKET_H */
