/* $Id: history.h,v 30000.21 1993/05/25 00:57:15 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef HISTORY_H
#define HISTORY_H

typedef struct History {       /* circular list of Alines, and logfile */
    struct Aline **alines;
    int size, maxsize, pos, index, num;
    TFILE *logfile;
    char *logname;
} History;


extern void   NDECL(init_histories);
extern void   FDECL(free_history,(History *hist));
extern void   FDECL(record_world,(History *hist, Aline *aline));
extern void   FDECL(record_global,(Aline *aline));
extern void   FDECL(record_local,(Aline *aline));
extern void   FDECL(record_input,(char *line));
extern int    FDECL(recall_history,(char *args, TFILE *file));
extern void   FDECL(recall_input,(Stringp str, int dir));
extern int    FDECL(do_saveline,(char *args));
extern int    FDECL(is_suppressed,(History *hist, char *line));
extern void   FDECL(history_sub,(char *pattern));
extern int    FDECL(do_log,(char *args));

#endif /* HISTORY_H */
