/* $Id: help.c,v 30000.21 1993/05/18 08:56:20 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/


/****************************************************************
 * Fugue help handling                                          *
 *                                                              *
 * Uses the help index to search the helpfile for a topic.      *
 *                                                              *
 * Algorithm developed by Leo Plotkin.  Code rewritten by Greg  *
 * Hudson and Ken Keys to work with rest of program.            *
 ****************************************************************/

#include "port.h"
#include "dstring.h"
#include "tf.h"
#include "util.h"

int FDECL(do_help,(char *what));

int do_help(what) 
    char *what;
{
    static Stringp indexfname, input;
    static int strings_inited = FALSE;
    char *name;
    FILE *indexfile;
    TFILE *helpfile;
    long offset = -1;
    char *place;

    if (!strings_inited) {
        Stringinit(indexfname);
        Stringinit(input);
        strings_inited = TRUE;
    }
    if (!*what) what = "summary";

    name = tfname(NULL, "HELPFILE");
    if ((helpfile = tfopen(name, "r")) == NULL) {
        operror(name);
        return 0;
    }
    Sprintf(indexfname, "%s.index", name);
    if ((indexfile = fopen(indexfname->s, "r")) == NULL) {
        operror(indexfname->s);
        tfclose(helpfile);
        return 0;
    }

    while (fgetS(input, indexfile) != NULL) {
        place = strchr(input->s, ':');
        if (place == NULL) {
            tfputs("% Error in indexfile", tferr);
            return 0;
        } else place++;
        if (!cstrcmp(place, what)) {
            offset = atol(input->s);
            break;
        }
    }
    fclose(indexfile);
    if (offset < 0) {
        oprintf("%% Help on subject %s not found.", what);
        tfclose(helpfile);
        return 0;
    }

    /* find offset and skip lines starting with "@@@@" */
    tfjump(helpfile, offset);
    while (tfgetS(input, helpfile) != NULL)
        if (strncmp(input->s, "@@@@", 4) != 0) break;

    oprintf("Help on topic %s:", what);
    do {
        if (strncmp(input->s, "@@@@", 4) == 0) break;
        oputs(input->s);
    } while (tfgetS(input, helpfile) != NULL);
    tfclose(helpfile);
    return 1;
}
