/* player.c */

#include "copyright.h"
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>

#include "config.h"
#include "db.h"
#include "interface.h"
#include "externs.h"


extern char *ctime();

int password_check(player, password)
     dbref player;
     char *password;
{
  ATTR *a;

  /* read the password and compare it */
  if ((a = atr_get_noparent(player, "XYXXY")) &&
      strcmp(uncompress(a->value), password) &&
      strcmp(crypt(password, "XX"), uncompress(a->value)))
    return 0;

  /* prevent direct entry of the raw encrypted password */
  if ((strlen(password) == 13) &&
      (password[0] == 'X') && (password[1] == 'X'))
    return 0;

  /* we're okay */
  return 1;
}

dbref connect_player(name, password)
    const char *name;
    const char *password;
{
  dbref player;
 
  /* validate name */
  if ((player = lookup_player(name)) == NOTHING)
    return NOTHING;

  /* validate password */
  if (!password_check(player, password))
    return NOTHING;
 
  db[player].parent = NOTHING;
  return player;
}

dbref create_player(name, password, host)
     const char *name;
     const char *password;
     const char *host;
{
  dbref player;
  time_t tt;
  char *s;
  if (!ok_player_name(name) || !ok_password(password))
    return NOTHING;

  /* else he doesn't already exist, create him */
  tt = time((time_t *) 0);
  s = ctime(&tt);
  s[strlen(s) - 1] = 0;
  player = new_object();

  /* initialize everything */
  SET(db[player].name, name);
  db[player].location = PLAYER_START;
  db[player].exits = PLAYER_START;	/* home */
  db[player].owner = player;
  db[player].parent = NOTHING;
  db[player].flags = TYPE_PLAYER;
  db[player].flags |= options.player_flags;
  db[player].toggles |= options.player_toggles;
  s_Pass(player, crypt(password, "XX"));
  giveto(player, START_BONUS);	/* starting bonus */
  (void) atr_add(player, "LAST", s, GOD, NOTHING);
  (void) atr_add(player, "LASTSITE", host, GOD, NOTHING);
#ifdef QUOTA
  (void) atr_add(player, "RQUOTA", START_QUOTA, GOD, NOTHING);
#endif /* QUOTA */
  /* link him to PLAYER_START */
  PUSH(player, db[PLAYER_START].contents);

  add_player(player, NULL);

  return player;
}

void do_password(player, old, newobj)
    dbref player;
    const char *old;
    const char *newobj;
{

#ifdef GUEST_RESTRICT
  if (Guest(player)) {
    notify(player, "Guests may not change their passwords.");
    return;
  }
#endif

  if (!password_check(player, old)) {
    notify(player, "Sorry");
  } else if (!ok_password(newobj)) {
    notify(player, "Bad new password.");
  } else {
    s_Pass(player, crypt(newobj, "XX"));
    notify(player, "Password changed.");
  }
}

void check_last(player, host)
     dbref player;
     const char *host;
{
  time_t tt;
  char *s;
  ATTR *a;
  ATTR *h;
  char last_time[MAX_COMMAND_LEN / 8];
  char last_place[MAX_COMMAND_LEN / 8];

  tt = time((time_t *) 0);
  s = ctime(&tt);
  s[strlen(s) - 1] = 0;
  /* compare to last connect see if player gets salary */
  a = atr_get_noparent(player, "LAST");
  if (a && (strncmp(uncompress(a->value), s, 10) != 0))
    giveto(player, PAY_CHECK);

  /* tell the player where he last connected from */
  h = atr_get_noparent(player, "LASTSITE");
  if (h) {
    strcpy(last_place, uncompress(h->value));
    strcpy(last_time, uncompress(a->value));
    notify(player, tprintf("Last connect was from %s on %s.",
			   last_place, last_time));
  }
  /* if there is no Lastsite, then the player is newly created.
   * the extra variables are a kludge to work around some weird
   * behavior involving uncompress.
   */

  /* set the new attributes */
  (void) atr_add(player, "LAST", s, GOD, NOTHING);
  (void) atr_add(player, "LASTSITE", host, GOD, NOTHING);
}
