/* chat.h */
 
#ifndef __CHAT_H
#define __CHAT_H
 
#include "config.h"

#if (CHAT_SYSTEM >= 2)

#include "db.h"
#include "externs.h"

extern void channel_broadcast();
extern void do_channel_who();

#define Channels(x)   (db[(x)].channels)

typedef struct chat_entry CHTAB;

struct chat_entry {
  char *name;
  int perms;
};

extern CHTAB chantab[];
 
/* channel permissions */
#define CHP_FORBID   0x0
#define CHP_PUBLIC   0x1
#define CHP_ADMIN    0x2
#define CHP_WIZARD   0x3
#define CHP_MASK     0x7
 
/* channel permission macros */
#define ChanPrivs(c)   (chantab[nchan(c)].perms & CHP_MASK)
#define NChanPrivs(c)  (chantab[(c)].perms & CHP_MASK)
 
/* macro to determine if player x can listen to channel c */
#define ChannelPermit(x,c)  ((ChanPrivs(c) == CHP_PUBLIC) || \
			     Wizard(x) || \
			     ((ChanPrivs(c) == CHP_ADMIN) && \
			      (Hasprivs(x) || (Powers(x) & CHAT_PRIVS))))
 
/* name of numeric channel */
#define NChanName(c)   (chantab[(c)].name)
 
/* is player x listening to channel c? */
#define OnChannel(x,c) (db[(x)].channels & c)

#endif				/* CHAT_SYSTEM */
 
#endif				/* __CHAT_H */
