/* unparse.c */
/* $Id: unparse.c,v 1.6 1993/03/21 01:47:03 nils Exp $ */

#include "db.h"

#include "externs.h"
#include "config.h"
#include "interface.h"
#include "nalloc.h"
extern NALLOC *glurp;


 char *unparse_flags(thing)
     dbref thing;
{
  int c;
  static char buf[BUFFER_LEN];
  char *p;
 char *type_codes = "R-E-----PPPPPPPP";
  
  p = buf;
  c = type_codes[Typeof(thing)];
  if ( c != '-' )
    *p++ = c;
  if(db[thing].flags & ~TYPE_MASK) {
    /* print flags */
#ifdef DESTROY	
    if(db[thing].flags & GOING) *p++ = 'G';
#endif /* DESTROY	                                */
    if(db[thing].flags & PUPPET) *p++ = 'p';
    if(db[thing].flags & STICKY) *p++ = 'S';
    if(db[thing].flags & DARK) *p++ = 'D';
    if(db[thing].flags & LINK_OK) *p++ = 'L';
    if(db[thing].flags & HAVEN) *p++ = 'H';
    if(db[thing].flags & CHOWN_OK) *p++='C';
    if(db[thing].flags & ENTER_OK) *p++='e';
    if(db[thing].flags & SEE_OK) *p++='v';
    /*    if(db[thing].flags & UNIVERSAL) *p++='U';*/
    if(db[thing].flags & OPAQUE)
      if (Typeof(thing) == TYPE_EXIT) *p++ = 'T';
      else *p++='o';
    if(db[thing].flags & INHERIT_POWERS) *p++='I';
    if(db[thing].flags & QUIET) *p++='q';
    if(db[thing].flags & BEARING) *p++='b';
    switch(Typeof(thing)) {
    case TYPE_PLAYER:
      if (db[thing].flags & PLAYER_SLAVE)
	*p++='s';
      if (db[thing].flags & PLAYER_CONNECT)
	*p++='c';
      if (db[thing].flags & PLAYER_TERSE)
	*p++='t';
      if (db[thing].flags & PLAYER_MORTAL)
	*p++='m';
      if (db[thing].flags & PLAYER_NEWBIE)
	*p++='n';
      if (db[thing].flags & PLAYER_NO_WALLS)
	*p++='N';
      break;	    
    case TYPE_EXIT:
      if(db[thing].flags & EXIT_LIGHT)
	*p++='l';
      break;
    case TYPE_THING:
      if (db[thing].flags & THING_KEY)
	*p++='K';
      if (db[thing].flags & THING_DEST_OK)
	*p++='d';
      /*	   if (db[thing].flags & THING_ROBOT)
       *p++='r'; */
      if (db[thing].flags & THING_SACROK)
	*p++='X';
      if (db[thing].flags & THING_LIGHT)
	*p++='l';
      if (db[thing].flags & THING_ZONED)
	*p++='z';
      break;
    case TYPE_ROOM:
      if (db[thing].flags & ROOM_TEMPLE)
	*p++='T';
      if (db[thing].flags & ROOM_JUMP_OK)
	*p++='J';    
      if (db[thing].flags & ROOM_AUDITORIUM)
	*p++='A';
      if (db[thing].flags & ROOM_FLOATING)
	*p++='f';
#ifdef USE_SPACE  /*  Flag added by Eric Wallace  */
      if (db[thing].flags & ROOM_ZEROG)
	*p++='Z';
#endif
      break;
    }
  }
  *p = '\0';
  return buf;
}
char *unparse_object_a(player,loc)
     dbref player;
     dbref loc;
{
  char *xx;
  char *zz=unparse_object(player,loc);
  xx=na_alloc(glurp,strlen(zz)+1);
  strcpy(xx,zz);
  return xx;
}
 char *unparse_object(player,loc)
     dbref player;
     dbref loc;
{
  static char buf[BUFFER_LEN];
  
  Access(loc);
  switch(loc) {
  case NOTHING:
    return "*NOTHING*";
  case HOME:
    return "*HOME*";
  default:
    if((IS(player,TYPE_PLAYER,PLAYER_NEWBIE))
         ?(db[loc].owner == player)
         :(controls(player, loc, POW_BACKSTAGE) ||
           can_link_to(player, loc, POW_BACKSTAGE) ||
           (IS(loc, TYPE_ROOM, ROOM_JUMP_OK)) ||
           (db[loc].flags & CHOWN_OK) ||
           (db[loc].flags & SEE_OK) ||
           power(player,POW_BACKSTAGE))) { 
      /* show everything */
      sprintf(buf, "%s(#%d%s)", db[loc].name, loc, unparse_flags(loc));
      return buf;
    } else {
      /* show only the name */
      return db[loc].name;
    }
  }
}

