/* log.c */
/* $Id: log.c,v 1.5 1993/03/18 22:26:26 nils Exp $ */

#include <stdio.h>
#include "db.h"
#include "config.h"
#include "nalloc.h"
#include "externs.h"
#include "log.h"

struct log
  important_log = { NULL, -1, "logs/important", "*log_imp" },
  sensitive_log = { NULL, -1, "logs/sensitive", "*log_sens" },
  error_log = { NULL, -1, "logs/error", "*log_err" },
  ioerr_log = { NULL, -1, "logs/ioerr", "*log_ioerr" },
  io_log = { NULL, -1, "logs/io", "*log_io" },
  gripe_log = { NULL, -1, "logs/gripe", "log_gripe" }
#ifdef LOG_FAILED_COMMANDS
, huh_log = { NULL, -1, "logs/huh", NULL }
#endif
;

void com_errlog(str)
     char *str;
{
  static char buf[2048];
  sprintf(buf,"[%s] * %s",DBINFO_CHAN, str);
  com_send(DBINFO_CHAN, buf);
}

void muse_log(l,str)
     struct log *l;
     char *str;
{
  struct timeval t;
  struct tm *bdown;

  if (l->com_channel) {
    static char buf[2048];
    sprintf(buf,"[%s] * %s",l->com_channel, str);
    com_send(l->com_channel, buf);
  }

  if (!l->fptr) {
    l->fptr = fopen(l->filename, "a");
    if (!l->fptr) {
      mkdir("logs",0755);
      l->fptr = fopen(l->filename, "a");
      if (!l->fptr) {
	fprintf(stderr,"BLEEEP! couldn't open log file %s\n",l->filename);
	return;
      }
    }
  }
  gettimeofday(&t,NULL);
  bdown = localtime(&t.tv_sec);
  fprintf(l->fptr, "%02d/%02d:%02d:%02d:%02d| %s\n", bdown->tm_mon+1,bdown->tm_mday,bdown->tm_hour,bdown->tm_min,bdown->tm_sec,str);
  fflush(l->fptr);
  if (l->counter--<0) {
    l->counter = 100;
    fclose(l->fptr);
    l->fptr = NULL;
  };
}

#ifdef LOG_FAILED_COMMANDS
void do_mailhuh(player)
     dbref player;
{
  char buf[4096];		/* just in case. this isn't run very often,
				 * so we can have a huge buf. */
  FILE *l_huh;
  struct huh_struct {
    struct huh_list *huhs;
    dbref player;
    struct huh_struct *next;
  };
  struct huh_list {
    char *dat;
    struct huh_list *next;
  };
  struct huh_struct *huhs=NULL;
  extern NALLOC *glurp;
  
  if (huh_log.fptr) {
    fclose(huh_log.fptr);
    huh_log.fptr = NULL;
  }
  l_huh=fopen("logs/huh","r");
  if(!l_huh) {
    notify(player,"Can't open huh log for reading.");
    log_error("Can't open huh log for reading.");
    perror("mailing huhs");
    return;
  }
  while(fgets(buf,4095,l_huh)) {
    dbref player;
    struct huh_struct *x;
    struct huh_list *y;
    player=atoi(strchr(buf,'|')+1); /* grab the playnum. */
    for(x=huhs;x && x->player!=player;x=x->next);
    if(!x) {
      x=(struct huh_struct *)na_alloc(glurp,sizeof(struct huh_struct));
      x->next=huhs;
      x->huhs=NULL;
      x->player=player;
      huhs=x;
    }
    y=x->huhs;
    x->huhs=(struct huh_list *)na_alloc(glurp,sizeof(struct huh_list));
    buf[strlen(buf)-1]='\0';
    x->huhs->next=y;
    x->huhs->dat=na_alloc(glurp,strlen(buf)+1);
    strcpy(x->huhs->dat,buf);
  }
  log_io("Done loading HUHs. mailing.");
  fclose(l_huh);

  for(;huhs;huhs=huhs->next)	/* discard the huhs.. they're dfreed at
				 * the beginning of each process_command,
				 * as they're glurp. */
    if (huhs->player>=0 && huhs->player<db_top)
      if (*atr_get(huhs->player,A_HUHTO)) {
	struct huh_list *x;
	
	
	notify(player,tprintf("Doing %d",huhs->player));
	
	l_huh = popen(tprintf("cat | /usr/local/bin/elm -s 'HUH logs' %s\n",atr_get(huhs->player,A_HUHTO)),"w");
	fprintf(l_huh,"\n\nHuh logs from %s on %s.\n\n",unparse_object(huhs->player, huhs->player),MUSE_NAME);
	for (x=huhs->huhs; x; x=x->next)
	  fprintf(l_huh,"%s",x->dat);
	fprintf(l_huh,"\n\n");
	pclose(l_huh);
	/* fprintf(l_huh,"\nmail %s\n\n",atr_get(huhs->player,A_HUHTO));
	   fprintf(l_huh,"These are all the Huh?s from your rooms on MicroMUSE.\n");
	   fputc('\n',l_huh);
	   for(x=huhs->huhs;x;x=x->next)
	   fprintf(l_huh,"%s\n",x->dat);
	   fprintf(l_huh,"\n\n.\n"); */
      }
  fclose(huh_log.fptr);
  huh_log.fptr = NULL;
  unlink("logs/huh.log");	/* so we don't mail them the same huhs
				 * again. */
}
#endif
