/*
 *	openable.c
 *
 *	For objects you can open and close.
 *	eg. doors, boxes, etc;
 */
#include "door_logic.h"

private	int	is_open;

int query_is_open() {
	return is_open;
}

void set_is_open(int	new_value)
{
	is_open = new_value;
}

/*
 *	open
 *	return 0 or 1 for "was already open", "was closed, is now open"
 */
int open()
{
	if (!is_open) {
		is_open = 1;
		return DOORLOGIC_DOOR_OPENS;
	};
	return DOORLOGIC_DOOR_ALREADY_OPEN;
}

/*
 *	close
 *	return 0 or 1 for "was already closed", "was open, is now closed"
 */
int close()
{
	if (is_open) {
		is_open = 0;
		return DOORLOGIC_DOOR_CLOSES;
	};
	return DOORLOGIC_DOOR_ALREADY_CLOSED;
}

/*
 *	toggle
 *	return new state of is_open
 */
int toggle()
{
	if (is_open) {
		is_open = 0;
	}
	else {
		is_open = 1;
	};
	return query_is_open();
}
