/*
 * Used for debuggin.
 */

private string spaces(int n) {
    if (n == 0)
	return "";
    return extract("                                                    ",
		   0, n);
}

private void dump_item(mixed val, int indent);

private void dump_item(mixed val, int indent) {
    if (intp(val)) {
	write(spaces(indent) + "INT    " + val + "\n");
	return;
    }
    if (objectp(val)) {
	write(spaces(indent) + "OBJECT " + file_name(val) + "\n");
	return;
    }
    if (stringp(val)) {
	write(spaces(indent) + "STRING '" + val + "'\n");
	return;
    }
    if (pointerp(val)) {
	int i;
	write(spaces(indent) + "ARRAY " + sizeof(val) + ":\n");
	for (i=0; i<sizeof(val); i++)
	    dump_item(val[i], indent+2);
	return;
    }
    write("UNKOWN\n");
}

void dump_value(mixed val) {
    dump_item(val, 0);
}
