#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "plane.h"

main()
{
    FILE    *fp, *fopen();
    int     plnf, x, n, numplanes;
    struct plnstr *pp;
    struct plnstr all[2000];
    char    *sprintf(), buf[80];

    if ((fp=fopen("plane.ascii", "r")) == (FILE *)0){
        fprintf(stderr,"Cannot open plane.ascii!\n");
        exit(-1);
    }

    fscanf(fp,"%d",&numplanes);

    pp = all;
    for(x=0;x<numplanes;x++,pp++)
        read_plane(pp, fp);
    fclose(fp);

    unlink(sprintf(buf,"%s/plane",DATADIR));
    plnf = open(sprintf(buf,"%s/plane",DATADIR), O_WRONLY|O_CREAT, 0);
    n=write(plnf, all, numplanes*sizeof(struct plnstr));
    close(plnf);

    printf("Writing %s/plane\n",DATADIR);
    printf("wrote %d bytes out of %d!\n",n,numplanes*sizeof(struct plnstr));
}

read_plane(pp, fp, cnum)
struct plnstr *pp;
FILE *fp;
int  cnum;
{
    int x, y, ind, relate, reject;
    float f;
    long l;
    char c;

    fscanf(fp,"%d ",&x);
    pp->pln_x = (coord)x;
    fscanf(fp,"%d ",&x);
    pp->pln_y = (coord)x;
    fscanf(fp,"%d ",&x);
    pp->pln_own = (natid)x;
    fscanf(fp,"%d ",&x);
    pp->pln_type = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_effic = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_mobil = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_sell = (short)x;
    fscanf(fp,"%d ",&x);
    pp->pln_tech = (short)x;
    fscanf(fp,"%d ",&x);
    pp->pln_uid = (short)x;
    fscanf(fp,"%d ",&x);
    pp->pln_wing = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_range = (u_char)x;
#ifdef RANGEEDIT
    fscanf(fp,"%d ",&x);
    pp->pln_range_max = (u_char)x;
#endif /* RANGEEDIT */
    fscanf(fp,"%d ",&x);
    pp->pln_ship = (short)x;
    fscanf(fp,"%d ",&x);
    pp->pln_att = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_def = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_harden = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_nuketype = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_nukeamt = (char)x;
    fscanf(fp,"%d ",&x);
    pp->pln_flags = (char)x;
#ifdef ORBIT
    fscanf(fp,"%f ",&f);
    pp->pln_theta = (float)f;
#endif /* ORBIT */
}
