# object.tcl --
#
#	The code in this file was adapted from work by Jean-Luc Fontaine
#	(jfontain@pluton.experdata.fr) as part of his "textundo 1.0" package.
#	I changed it to use the namespace facility introduced in Tcl 8.
#

namespace eval NSObject {

variable classNewId 0

# NSObject::New --
#
#	Create a new object of the given class by getting a new
#	unique OOP ID and calling the class constructor (if present).
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc New {className args} {

    # calls the constructor for the class with optional arguments
    # and returns a unique object identifier independent of the class name

    variable classNewId

    # use local variable for id for new can be called recursively
    set id [incr classNewId]

    if {[llength [namespace eval ::$className info procs $className]] > 0} {

        # avoid catch to track errors
        eval ${className}::$className $id $args
    }

    return $id
}

# NSObject::Delete --
#
#	Delete object of given class by calling destructor and
#	deleting any global arrays associated with the object.
#
# Arguments:
#	arg1					about arg1
#
# Results:
#	What happened.

proc Delete {className id} {

    # calls the destructor for the class and delete all the object data members

    if {[llength [namespace eval ::$className info procs ~$className]] > 0} {

        # avoid catch to track errors
        ${className}::~$className $id
    }

    global $className

    # and delete all this object array members if any (assume that they were stored as $className($id,memberName))
    foreach name [array names $className "$id,*"] {
        unset ${className}($name)
    }
}

}
