/*
 *  exec.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef EXEC_DOT_H
#define EXEC_DOT_H
#include "ObjProGen/errcode.h"
#include "ObjProDSP/tmdbg.h"
#include "ObjProDSP/portable.h"

class TargetNode ;
class NetworkStateControl ;


class ExecuteState {
	NetworkStateControl** StateControl ;
	enum ExecState {ExecStateInit,ExecStateInitDo, ExecStateContinuous,
		ExecStateContinuousDo} TheExecState ;
	int MadeProgress ;
	int AnyProgress ;
protected:
	int GlobalSequenceIndex ;
	int GlobalExecutionIndex ;
	ErrCode ExecutionState ;
	TargetNode ** TheNodes ;
	TargetNode ** CurrentNode ;
	TargetNode ** TheFeedbackNodes ;
	int InitLength ;
	int ExecLength ;
	static int32 exec_count ;
	static int show_nodes ;
	int count_left ;
public:
	ExecuteState(TargetNode ** node_thread, TargetNode ** feedback_nodes,
		int Init_Length, int Exec_Length, NetworkStateControl** con=0);
	ErrCode ExecuteNetwork();
	ErrCode DoExecuteNetwork();
	ErrCode ResumeExecuteNetwork(int& AnyProgress);
	void ClearFeedbackFlags() ;
	ErrCode ExecuteNetworkKernel(int TableLimit) ;
	ErrCode ExecuteNetworkDynamicKernel() ;
	ErrCode SetAllSequences(int index) ;
	ErrCode Reset();
	int GetGlobalSequenceIndex() const { return GlobalSequenceIndex ;}
	int GetGlobalExecutionIndex() const { return GlobalExecutionIndex ;}
	// The following two routines are mainly used for single thread
	// networks.
	TargetNode * GetFirstNode(int n=0);
			// returns first node of nth thread
	TargetNode * GetLastNode(int n=0) ;
			// returns last node in nth terminating path
	ErrCode CheckProcess();
	ErrCode DoCallAtEnd();
	static void process_args(int, char **);
	static int show() {return show_nodes;}
};

extern ExecuteState * TheState ;

#endif /* #ifdef EXEC_DOT_H */
