/*
 *  hrdcmp.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef HRDCMP_DOT_H
#define HRDCMP_DOT_H
/* hrdcmp.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <float.h>
#include "ObjProArith/hrdarth.h"
/***************************
	int operator<(AccMachWord);
	int operator>(AccMachWord);
	int operator<=(AccMachWord);
	int operator>=(AccMachWord);
	int operator==(AccMachWord);
	int operator!=(AccMachWord);
**************/

#define DeclareMachWordOperators(MachWord,float) 			\
inline void MachWord::operator+=(MachWord x) {value += (float) x;}\
inline void MachWord::operator-=(MachWord x) {value -= (float) x;}\
inline void MachWord::operator*=(MachWord x) {value *= (float) x;}\
inline void MachWord::operator/=(MachWord x) {value /= (float) x;}\
inline int MachWord::operator<(MachWord x) const {return value < (float) x;}\
inline int MachWord::operator>(MachWord x) const {return value > (float) x;}\
inline int MachWord::operator<=(MachWord x) const {return value<=(float) x;}\
inline int MachWord::operator>=(MachWord x) const {return value>=(float) x;}\
inline int MachWord::operator==(MachWord x) const {return value==(float) x;}\
inline int MachWord::operator!=(MachWord x) const {return value!=(float) x;}\
inline MachWord operator+(MachWord a,MachWord b) 			\
	{return (float) ((float) a + (float) b);}			\
inline MachWord operator-(MachWord a,MachWord b) 	 		\
	{return (float) ((float) a - (float) b);}			\
MachWord operator*(MachWord a,MachWord b) ; 		 		\
inline MachWord operator/(MachWord a,MachWord b) 	 		\
	{return (float) ((float) a / (float) b);}			\

DeclareMachWordOperators(MachWord,float);
DeclareMachWordOperators(AccMachWord,float);


#define DeclareCxMachWordOperators(CxMachWord,MachWord)		\
CxMachWord operator+(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator-(const CxMachWord& a,const CxMachWord& b) ;		\
inline CxMachWord operator*(const CxMachWord& a,const CxMachWord& b) 	\
	{return CxMachWord( \
		MachReal(a) * MachReal(b) - \
		MachImag(a) * MachImag(b), \
		MachReal(a) * MachImag(b) + \
		MachReal(b) * MachImag(a));} \
CxMachWord operator*(MachWord a,const CxMachWord& b) ;			\
CxMachWord operator*(const CxMachWord& a,MachWord b) ;			\
CxMachWord operator/(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator/(const CxMachWord& a,MachWord b) ;			\

DeclareCxMachWordOperators(CxMachWord,MachWord) ;
DeclareCxMachWordOperators(CxAccMachWord,AccMachWord) ;


inline CxMachWord MakeCxMachWord(const complex& arg)
{
 	return ((float) real(arg), (float) imag(arg));
}
 
inline CxAccMachWord MakeCxAccMachWord(const complex& arg)
{
 	return ((float) real(arg), (float) imag(arg));
}


#define DefineCxMachWordOperators(CxMachWord,MachWord,rl,ig,float)	\
inline void CxMachWord::operator+=(const CxMachWord& x)			\
{								\
	rl += MachReal(x);					\
	ig += MachImag(x);					\
}								\
								\
inline void CxMachWord::operator-=(const CxMachWord& x)			\
{								\
	rl -= MachReal(x);					\
	ig -= MachImag(x);					\
}								\
								\
								\
inline void CxMachWord::operator*=(MachWord x)			\
{								\
	rl = rl * x ;						\
	ig = ig * x ;						\
}								\
								\
inline void CxMachWord::operator/=(const CxMachWord& x)			\
{								\
	complex C = complex(rl,ig) /((complex) x) ;		\
	rl = (float) real(C);					\
	ig = (float) imag(C);					\
}								\
								\
inline void CxMachWord::operator/=(MachWord x)			\
{								\
	rl = rl / x ;						\
	ig = ig / x ;						\
}								\
								\
								\
								\
inline CxMachWord operator+(const CxMachWord& a,const CxMachWord& b)	\
{								\
	float xrl = MachReal(a) + MachReal(b) ;			\
	float xig = MachImag(a) + MachImag(b) ;			\
	return CxMachWord(xrl,xig);				\
}								\
								\
inline CxMachWord operator-(const CxMachWord& a,const CxMachWord& b)	\
{								\
	float xrl = MachReal(a) - MachReal(b) ;			\
	float xig = MachImag(a) - MachImag(b) ;			\
	return CxMachWord(xrl,xig);				\
}								\
								\
inline CxMachWord operator*(const CxMachWord& a,MachWord b)		\
{								\
	float xrl = MachReal(a) * b ;				\
	float xig = MachImag(a) * b ;				\
	return CxMachWord(xrl,xig);				\
}								\
								\
inline CxMachWord operator*(MachWord b,const CxMachWord& a)		\
{								\
	float xrl = MachReal(a) * b ;				\
	float xig = MachImag(a) * b ;				\
	return CxMachWord(xrl,xig);				\
}								\
								\
inline CxMachWord operator/(const CxMachWord& a,const MachWord& b)	\
{								\
	complex C = ((complex) a)/((double) b) ;		\
	return CxMachWord((float)real(C),(float)imag(C));	\
}								\
								\
inline CxMachWord operator/(const CxMachWord& a,const CxMachWord& b)	\
{								\
	complex C = ((complex) a)/((complex) b) ;		\
	return CxMachWord((float)real(C),(float)imag(C));	\
}								\
								\

DefineCxMachWordOperators(CxMachWord,MachWord,rl,ig,float) 
DefineCxMachWordOperators(CxAccMachWord,AccMachWord,Real,Imag,float)


#include "ObjProArith/fltstrm.h"
#endif /* #ifdef HRDCMP_DOT_H */
