/*
 *  makedir.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  makedir.C   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved					*/
#include <iostream.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "makedir.h"
#include "usercom.h"

#include "cgidbg.h"
#include "yacintfc.h"

int CheckSubDir(const char * Name)
{
	DIR * Directory = opendir(Name) ;
	if (Directory) closedir(Directory) ;
	else {
		int mode = S_IEXEC | S_IREAD | S_IROTH | S_IWRITE | S_IXGRP | S_IXOTH ;
		int status = mkdir(Name,mode);
		if (status != 0) {
			HelpOut << "Cannot create directory `" << Name << "'.\n" ;
			SystemErrorMessage();
			return 0 ;
		}
	}
	return 1 ;
}


