/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          ls.cr                                              */
/*  Author:        P. D. Fox                                          */
/*  Created:       21 Mar 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  CRISP Directory & File manager                      */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"crisp.cr"

/**********************************************************************/
/*   How to display size of file.				      */
/**********************************************************************/
# define	SIZE_BYTES	0
# define	SIZE_BLOCKS	1
# define	SIZE_K		2

int	dm_size = SIZE_K;
int	dm_num = 0;

/**********************************************************************/
/*   Current  nesting  level of popups. Used so we can avoid exiting  */
/*   macro when we select the '..' entry in the first popup.	      */
/**********************************************************************/
int	ls_level = 0;
/**********************************************************************/
/*   This  macro  is  a  sort  of  interactive  'ls'  extending  the  */
/*   facilities of the filename completion popup menus.		      */
/**********************************************************************/
void
ls(string dir)
{	int	curbuf;
	int	curwin;
	string	curdir;
	int	buf;
	string	name, tmp;
	int	size, mtime, ctime, mode;
	int	win;
	
	curbuf = inq_buffer();
	curwin = inq_window();

	getwd(NULL, curdir);
	/***********************************************/
	/*   If  no  directory specified, use current  */
	/*   one.				       */
	/***********************************************/
	if (dir != "") {
		cd(dir);
		getwd(NULL, tmp);
		}
	else
		tmp = curdir;
		
	/***********************************************/
	/*   Create buffer to put information in.      */
	/***********************************************/
	buf = create_buffer(tmp, "ls-" + dm_num++, TRUE);
	set_buffer(buf);
	
	/***********************************************/
	/*   Match  on  all  files. This forces us to  */
	/*   match on files starting with '.'	       */
	/***********************************************/
	file_pattern("?*");
	
	/***********************************************/
	/*   Get   info   on  each  file  in  current  */
	/*   directory.				       */
	/***********************************************/
	while (find_file(name, size, mtime, ctime, mode)) {
		/***********************************************/
		/*   Ignore entry for current directory.       */
		/***********************************************/
		if (name == ".")
			continue;
		if (mode & S_IFDIR)
			name += "/";
		sprintf(tmp, "%-16s %7d\n", 
			name, dm_size == SIZE_BYTES ? size : 
				((size / 1024) + ((size & 1023) != 0)));
		insert(tmp);
		}
	delete_line();
	sort_buffer();
	/***********************************************/
	/*   Now create popup window.		       */
	/***********************************************/
	win = sized_window(inq_lines()+1, inq_line_length(), "");
	select_buffer(buf, win, SEL_NORMAL, ls_keys());
	delete_buffer(buf);
	set_buffer(curbuf);
	set_window(curwin);
	attach_buffer(curbuf);
	cd(curdir);
}
void
ls_keys()
{
	assign_to_key("<Enter>", "ls_walk");
}
/**********************************************************************/
/*   Function  called  when user hits <Enter> on a file name. If its  */
/*   a  directory  walk  into  it  by  recursing,  so that the other  */
/*   window  stays  on  the  screen. If its an upper layer directory  */
/*   (i.e. ..), then force current macro to return.		      */
/**********************************************************************/
void
ls_walk()
{
	string	s;
	extern int window_offset;
	extern int top_line;
	int	i;
	
	s = read();
	i = index(s, " ");
	s = substr(s, 1, i-1);
# if 0
	if (ls_level != 0 && s == "../") {
		exit();
		return;
		}
# endif
	
	if (substr(s, strlen(s)) == "/") {
		top_line++;
		window_offset += 10;
		ls_level++;
		ls(s);
		ls_level--;
		window_offset -= 10;
		top_line--;
		}
}
