.ll 6i
.PH "'CRISP Macro Primitives''Page %''"
.PF "'CRISP Release 2.2''July 1991'"
.de P
.LP
..
.de SY
.ps +3
.ps
..
.de HU
.\" NINFO:stop
.ne 1.5i
.sp 1
.ft HB
.ps +4
.ce
_______________________________________________
.ps
.sp 1
.SH
.ps +4
.ce
.nf
.\" NINFO:start $1
..
.fi
.de Fo
.br
.fi
.ft R
.ps
.ps +0
.ne 4v
.in -.5i
.sp 1
\fB\\$1 \\$2 \\$3 \\$4 \\$5 \\$6\fR
.in +.5i
.br
..
.\"""""""""""""""""""""""""""""""""""""""""""""""""""""""""/
.SP 10
.ce
\s+5\s+9\s+9\f(HBC\s-9RISP  Primitives Reference Guide\fR\s-9\s-5
.SP 8
.nf
.in +2i
\s+5\f(HBVersion:	2.2

Author:	Paul Fox

Date:		July 1991
.in
\s-5\fR
.SP 9
.in +1i
.ll -1i
.ce
\f(HBCopyright Notice\fR
.SP 2
.fi
This document and the software it describes is Copyright (C) 1991
by Foxtrot Systems Ltd and Paul Fox. This copyright notice will remain
in effect at all times.
This manual may be reproduced under the terms of the CRISP copyright notice
associated with the distribution software.
.in
.ll
.SP 4
.nf
Foxtrot Systems Ltd
8, Theobalds Way
Frimley,
Surrey,
England GU16 5RF
.fi
.bp
.H 1 Introduction
.P
This manual contains a description of each primitive function available
in CRISP. The function definitions are described in terms of the
CRUNCH language syntax, although the crunch compiler maps these to the
lisp-language equivalent.
.P
The information in this manual is available on line, by using
the \f(HBexplain\fR macro or selecting the '\f(HBMacro Primitives\fR'
option from the help menu.
.H 2 Nomenclature
.P
The following syntax is used for describing the primitives:
.TS
center allbox;
cB cB
l lw(4i).
Notation	Description
\f(CW[...]\fR	T{
An argument in square brackets represents an
optional argument which may be omitted in function calls. Trailing optional
arguments may be omitted altogether. When an argument is optional but
not at the end of an argument list, the keyword \f(HBNULL\fR should
be used as a place holder for that argument.
T}
.TE
.H 2 "Overview"
.P
The primitives defined in this manual are mostly an integral part of
CRISP. A few of these primitives are prvided for compatability with the
BRIEF macro language. Where the BRIEF environment provides DOS specific
functions which are a subset of the Unix/POSIX functionality, emulation
functions are supplied. These primitives have a note in their manual entry.
For example, BRIEF provides the \fIinq_environment()\fR primitive
which is identical to the standard \fIgetenv()\fR function.
.P
CRISP & CRUNCH will hopefully evolve into a fairly complete
C-like interpreter supporting ANSI-C and POSIX style functions.
.P
Primitives which are based on underlying system calls will set
the global variable \fIerrno\fR to the result of the underlying
system call. For example, if the \fIremove()\fR function fails, then
the global variable \fIerrno\fR will be set to the value
set by the underlying system call.
.P
This manual attempts to describe completely the operation of each primitive
but in the interests of portability and compactness, not all error
returns are necessarily documented, especially those related to 
ANSI-C/POSIX style functions. If a system call fails, and \fIerrno\fR
is set, then the user should first consult the manual entry in this
document for a reason as to why the call failed, and if their is 
insufficient information documented here, check the operating
system manual pages for further information.
This is necessary because it is not possible to control what errors
may occur especially as CRISP is ported to different operating environments.
.P
Certain functions described in this manual are not actually primitives
built into CRISP but are callback extensions. For example the
\fI_bad_key()\fR function is called by CRISP when the user hits an illegal
key at the command prompt. Normally these functions are defined by the
CRISP macros supplied as part of the system. However, users can write their
own versions of these macros to trap certain actions.
.bp
.HU !
! iexpr
.Fo DESCRIPTION
Returns the logical not of the expression expr. expr must
evaluate to an integer expression.
.Fo EXAMPLES
.DS
	int	i = 23;

	i = !i;
	/* i now has the value of 0. */

	if (!i)
		message("i is zero");
	else
		message("i is not zero");
.DE
.Fo RETURN VALUE
Returns 1 if expr evaluates to zero; returns 0 if expr is
non-zero.
.HU !=
expr1 != expr2
.Fo RETURN VALUE
Returns 1 if expr1 is not equal to expr2; 0 if expr1 is
equal to expr2.
.HU %
iexpr1 % iexpr2
.Fo DESCRIPTION
This is the modulus function. The example below shows the
results of using negative numbers.

.Fo EXAMPLES
The following example show the various pathological cases of
the (%) function:
.DS
.ft CW
	mod_test()
	{
		message("%d %d %d %d %d",
			4 % -3,
			4 % -3,
			-4 % 3,
			-4 % -4,
			-4 % 0);
	}
.ft R
.DE

The output is:
.DS
.ft CW
    	1 1 -1 -1 0
.ft R
.DE
.Fo RETURN VALUE
Returns the integral remainder of the expression
(iexpr1)/(iexpr2).

.HU %=
ivar %= iexpr
.Fo DESCRIPTION
This macro is the same as:
.DS
.ft CW
    		ivar = ivar % iexpr;
.ft R
.DE
.P
ivar is the name of an integer variable; iexpr is an
expression which evaluate to an integer.

See (%) for details on the pathological use of negative
numbers.
.Fo RETURN VALUE
Returns the value assigned to ivar.
.HU &
iexpr1 & iexp2
.Fo RETURN VALUE
Returns the bit-wise AND of iexpr1 and iexpr2. A 32-bit
integer result is returned.
.HU &=
ivar &= iexpr1;

.Fo RETURN VALUE
The value of ivar logically ANDed with iexpr.
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar & iexpr;
.ft R
.DE
.HU &&
expr1 && expr2
.Fo DESCRIPTION
This is the conditional AND macro. If expr1 evaluates to
non-zero, then expr2 is evaluated. If expr1 evaluates to
zero, then expr2 is not evaluated. Thus, it is safe for
expr1 and expr2 to have side-effects.
.Fo EXAMPLES
The following example tests var1 and if it is non-zero,
increments var2 and tests to see if it is greater than 10.
.DS
.ft CW
	if (var1 && ++var2 > 10)
		message("var2 > 10 and var1 is non-zero");
.ft R
.DE
.Fo RETURN VALUE
Returns 1 if expr1 evaluates to non-zero and expr2 evaluates
to non-zero; 0 otherwise.
.HU *
expr1 * expr2
.Fo DESCRIPTION
The '*' operator is used to multiply two numbers together (either floating
point or integer). Automatic co-oercion between float and integer is performed.
If either argument is a float, then the result will be a float.

If either expr1 or expr2 is a string, then string duplication will be performed.
For example, 4*"x" will return the string "xxxx". The number and string
may be in either order.

All other combinations of types are invalid.
.Fo RETURN VALUE
The value of iexpr1 multiplied by iexpr2 or the specified string replicated
the number of times.
.HU *=
ivar *= iexpr1;
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar * iexpr;
.ft R
.DE
.Fo RETURN VALUE
The value of ivar multiplied by iexpr.
.HU +
expr1 + expr2
.Fo DESCRIPTION
The plus operator is used to add, or concatenate two expressions.
The operation is dependent on the type of the two specified expressions.
The processing is performed in the following order.
.P
If expr1 or expr2 is a list, then a new list is returned which is the
concatenation of expr1 and expr2.
.P
If expr1 or expr2 is a string, then the other operand is converted to
a string, and a string is returned.
.P
If either operand is a floating point number then the other the result
is the sum of the two expressions.
.P
Otherwise the integer value of the sum of the two expressions is returned.
.Fo RETURN VALUE
A list value if either operand is a list; a string if either operand is
a string; a float if either operand is a float; otherwise an integer value.
.Fo EXAMPLES
The following example illustrates how to convert a number to a string:
.DS
.ft CW
	string s = "" + 2.3;
.ft R
.DE
.HU ++
++ivar
.Fo DESCRIPTION
This macro forms the pre-increment instruction. (There is no
post-increment equivalent, due to limitations in the syntax
of the language).
.P
The variable ivar is incremented and the value may then be
used in an expression.
.Fo EXAMPLES
The following example can be used for controlling loops:
.DS
.ft CW
    	int	i = 0;
	while (++i < 10) {
		..
		..
		}
.ft R
.DE
.Fo RETURN VALUE
Returns the value (ivar+1).
.HU +=
var += expr;
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	var = var + expr;
.ft R
.DE
.Fo RETURN VALUE
Adds the expression expr to the variable 'var' and returns
the value. Addition is performed the same as the '+'
operator, i.e. float's and int's will be cast appropriately.
.HU -
iexpr1 - iexpr2
.Fo DESCRIPTION
iexpr1 and iexpr2 must both evaluate to integer expressions.
.Fo RETURN VALUE
Returns the integer value iexpr1 minus iexpr2.
.HU --
--ivar
.Fo DESCRIPTION
This macro forms the pre-decrement instruction. (There is no
post-increment equivalent, due to limitations in the syntax
of the language).
.P
The variable ivar is decremented and the value may then be
used in an expression.
.Fo RETURN VALUE
Returns the value (ivar-1).
.HU -=
ivar -= iexpr
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar - iexpr;
.ft R
.DE
.Fo RETURN VALUE
Returns the value (ivar-iexpr).
.HU /
expr1 / iexpr2
.Fo DESCRIPTION
If iexpr2 is zero, then iexpr1 is returned.
.Fo RETURN VALUE
Returns the value of iexpr1 divided by iexpr2.
.HU /=
ivar /= iexpr
.Fo RETURN VALUE
Returns the value ivar divided by iexpr.
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar / iexpr;
.ft R
.DE
.HU <
expr1 < expr2
.Fo DESCRIPTION
expr1 & expr2 must either be both integer expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
less than expr2; returns 1 if expr1 & expr2 are string
expressions and expr1 lexicographically preceeds expr2.
Returns 0 otherwise.
.HU <<
expr1 << expr2
.Fo RETURN VALUE
Returns expr1 shifted left by expr2 bit positions. expr1 and
expr2 must be integer expressions.
.HU <=
expr1 <= expr2
.Fo DESCRIPTION
expr1 & expr2 must either be both integer expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
less than or equal to expr2; returns 1 if expr1 & expr2 are
string expressions and expr1 lexicographically preceeds
expr2 or is equal to expr2. Returns 0 otherwise.
.HU =
var = expr
.Fo DESCRIPTION
This is the assignment operator. var is the name of a
symbol, and expr must be an expression which evaluates to
the same type as 'var', unless 'var' has been declared as a
polymorphic variable. (See (declare)).
.P
var and expr must agree in type. They can have integer,
string or list type. For list variables, it is acceptable
for expr to be NULL or omitted, in which case the storage
allocated to the variable var is freed.
.Fo RETURN VALUE
Returns the value of expr.
.Fo EXAMPLES
.DS
.ft CW
	int	i;
	string	s;
	list	l;
	
	i = 1 + 2;
	s = "fred" + " bloggs";
	l = quote_list(1, 2, 3);
	l = NULL;
.ft R
.DE
.HU <<=
var <<= expr
.Fo RETURN VALUE
Returns value of var shifted left by expr bit positions. var
must be an integer variable and expr must be an integer
expression.
.HU ==
expr1 == expr2
.Fo DESCRIPTION
Lists cannot be compared.
.Fo RETURN VALUE
Returns 1 if expr1 is equal to expr2. Returns 0 otherwise.
.HU >
expr1 > expr2
.Fo DESCRIPTION
expr1  &  expr2  must  either be both numeric expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
greater than expr2; returns 1 if expr1 & expr2 are string
expressions and expr1 lexicographically follows expr2.
Returns 0 otherwise.
.HU >=
expr1 >= expr2
.Fo DESCRIPTION
expr1 & expr2 must either be both numeric expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
greater than or equal to expr2; returns 1 if expr1 & expr2
are string expressions and expr1 lexicographically preceeds
expr2 or is equal to expr2. Returns 0 otherwise.
.HU >>
expr1 >> expr2
.Fo RETURN VALUE
Returns expr1 shifted right by expr2 bit positions. expr1
and expr2 must be integer expressions.
.HU >>=
var >>= expr
.Fo RETURN VALUE
Returns value of var shifted right by expr bit positions.
var must be an integer variable and expr must be an integer
expression.
.HU |
iexpr1 | iexpr2
.Fo RETURN VALUE
Returns the logical OR of integer expression iexpr1 and
iexpr2.
.HU |=
ivar |= iexpr1
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar | iexpr;
.ft R
.DE
.Fo RETURN VALUE
The value of ivar logically ORed with iexpr.
.HU ||
expr1 || expr2
.Fo RETURN VALUE
Returns 1 if expr1 OR expr2 evaluate to non-zero.
.Fo DESCRIPTION
This is the conditional OR function. If expr1 evaluates to
non-zero then expr2 is not evaluated. If expr1 evaluates to
zero, then the result of expr2 is returned.
.HU ^
iexpr1 ^ iexpr2
.Fo RETURN VALUE
Returns the logical XOR of integer expression iexpr1 and
iexpr2.
.HU ^=
ivar ^= iexpr1
.Fo RETURN VALUE
The value of ivar logically XORed with iexpr.
.Fo DESCRIPTION
This is equivalent to:
.DS
.ft CW
	ivar = ivar ^ iexpr;
.ft R
.DE
.HU ~
~iexpr
.Fo RETURN VALUE
Returns the 1's complement of the integer expression iexpr.
.HU _bad_key
_bad_key()
.Fo DESCRIPTION
\fI_bad_key()\fR is not actually a built-in primitive, but is used
by CRISP to implement the command history and abbreviation
features.
.P
The macro _bad_key is called from within CRISP when a bad
key is pressed during a prompt. This macro can use the
\fIinq_message()\fR and \fIinq_cmd_line()\fR macros to see what the
state of the status line is. It can also call \fIread_char()\fR to
retrieve the key which caused the problem -- this allows the
_bad_key macro to distinguish between context sensitive
help, or abbreviations etc.

The macro should return a string value, in which case this
is taken as the current input for the response field (it
will be highlited as the default value). The \fIpush_back()\fR
macro can be used to force acceptance of a default response.

See the history.m macro file for an example of how to use
the \fI_bad_key()\fR macro.
.Fo RETURN VALUE
A string.
.HU abort
abort()
.Fo DESCRIPTION
This macro is used to abort CRISP - it causes an
unconditional exit from CRISP after resetting the keyboard
state.

It should be used with extreme care since no checks are made
to see if buffers need to be saved, etc.

Its primary use will be in debugging macros.
.Fo RETURN VALUE
Nothing.
.HU above
above(expr1, expr2)
.Fo DESCRIPTION
This function provides a functional form of the '>' operator.
expr1 & expr2 must either be both integer expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
greater than expr2; returns 1 if expr1 & expr2 are string
expressions and expr1 lexicographically follows expr2.
Returns 0 otherwise.
.HU above_eq
above_eq(expr1, expr2)
.Fo DESCRIPTION
This function is a functional form of the '>=' operator.
expr1 & expr2 must either be both integer expressions or
string expressions. 
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
greater than or equal to expr2; returns 1 if expr1 & expr2
are string expressions and expr1 lexicographically follows
expr2 or is equal to expr2. Returns 0 otherwise.
.HU access
access(string file, int mode)
.Fo DESCRIPTION
This function is used to check the accessability of a file. The \fIfile\fR
parameter is the name of a directory or file which is to be tested and
\fImode\fR are a set of access bits which are used to check the
effective access.
.P
The meaning of mode is operating system dependent (refer to <unistd.h> or
\fIaccess(2)\fR). Most operating systems support the following bit definitions:
.DS
	0	Check if file exists
	1	Check to see if file is executable
	2	Check if file is writable
	3	Check if file is readable
.DE
.Fo RETURN VALUE
On successful return this function returns >= 0; -1 is returned
on an error, and the global variable \fIerrno\fR is set to
the reason for the failure.
.HU acos
acos(float_expr)
.Fo DESCRIPTION
Returns the inverse cosine value of the expression, in the
range [-pi/2, pi/2]. float_expr must be in the range [-1, 1].
.Fo RETURN VALUE
Arc-cosine of the passed argument (in radians).
.HU asin
asin(float_expr)
.Fo DESCRIPTION
Returns the inverse sine value of the expression, in the
range [-pi/2, pi/2]. float_expr must be in the range [-1, 1].
.Fo RETURN VALUE
Arc-sine of the passed argument (in radians).
.HU atan
atan(float_expr)
.Fo DESCRIPTION
Returns the inverse tangent value of the expression, in the
range [-pi/2, pi/2].
.Fo RETURN VALUE
Arc-tangent of the passed argument (in radians).
.HU atan2
atan2(x, y)
.Fo DESCRIPTION
Returns the inverse tangent of y/x in the range [-pi, pi].
.Fo RETURN VALUE
Arc-tangent of (y/x) (in radians).
.HU assign_to_key
assign_to_key([key], [macro])
.Fo DESCRIPTION
This macro is used to bind a macro to a function key. The
key is given by the string parameter, key, and if omitted is
prompted for. key may be specified as either an internal key
code, or may be specified by a portable abbreviation. The
portable abbreviations are given below.

macro is a string containing the name of a macro to execute
when that key is pressed.

If key evaluates to more than one keystroke, then this is
defined as a multi-key sequence, i.e. more than one key must
be pressed to execut the macro. In this case, an internal
key code is assigned for this key, as if it were a builtin
key. This internal key code is returned as the value of this
macro. Muilti-key sequences do not time out between key
presses unlike the other internal keys when there is an
ambiguity.

(The backslash character can be used to turn off the
effect of the special characters). key is a string which may
take one of the following forms:
.ne 2i
.TS H
center allbox;
cB cB
lw(1i) lw(4.5i).
Key	Description
=
.TH
x	The actual key 'x'.
^x	The key control-x.
#123	T{
The key whose internal key code is 123. This method of
defining keys is not recommended. It is provided for
compatability with BRIEF, but is useless since BRIEF allows
PC keyboard scancodes to be entered in this way. PC keyboard
scancodes have very little relevance outside of DOS.
T}
xyz	T{
The sequence of keys x, followed by y, followed by z. This
allows multiple keys to be bound to a macro. Note that this
is not the same as using set_term_keyboard() to define a key.
T}
<Fn>	T{
when n is in the range 1..255. This is a synonym for Function
Key n.
T}
T{
.nf
<Ctrl-Fn>
<Shift-Fn>
<Alt-Fn>
<Meta-Fn>
.fi
T}	T{
Ctrl, Shift and Alt versions of function
keys. (Alt-Fn and Meta-Fn are synonymous).
T}
T{
<Alt-x>
.br
<Meta-x>
T}	T{
where n is an upper or lower case letter. The case of the
letter is ignored. On the Sun keyboard, LEFT/RIGHT act as
the ALT key for the main keyboard only.
T}
T{
<Alt-n>
.br
<Meta-n>
T}	T{
where n is in the range 0..9. On a PC keyboard this means
the top numeric keys with the ALT key pressed. On a Sun-3
keyboard, this is the same as LEFT/RIGHT pressed whilst
hitting a digit key.
T}
<Ins>	The keypad Insert key.
<Del>	The DELETE key.
<Backspace>	The backspace key.
<Keypad-minus>	T{
The '-' key on the keypad.
T}
<Keypad-plus>	T{
The '+' key on the keypad.
T}
<Enter>	The ENTER or RETURN key.
T{
<Esc>, <Tab>, 
.br
<PgDn>, <PgUp>, 
.br
<Left>, <Right>, 
.br
<Up>, <Down>,
.br
<Home>, <End>
T}	T{
Same as keys labelled as such on keyboard. On keyboards
which dont have markings for these keys, various
approximations are possible. Refer to the tty/*.cr files for
further details.
T}
.TE
.Fo RETURN VALUE
Key  value  assigned  to  sequence  or  -1  if  key sequence
invalid or operation aborted.
.HU atoi
atoi(string, [char])
.Fo DESCRIPTION
This macro converts string, which is a string representation
of a decimal number to binary. If char is specified and is
zero, then the ascii value of the first character in string
is returned.
.Fo RETURN VALUE
Returns integer value of argument string treated as an ascii
number or the ascii value of the first character in string
if char is zero.
.HU attach_buffer
attach_buffer(bufnum)
.Fo DESCRIPTION
This command attaches the specified buffer to the currently
selected window. This means that the next time the window is
refreshed the specified buffer will be displayed in the
current window.

When the specified buffer is attached to the current window,
the top title of the window is changed to reflect the buffer
or filename associated with the buffer.

This call is necessary after changing a window with
\fIset_window()\fR. Take care to ensure that when a window is
refreshed on the screen that it always has a buffer attached
to it, otherwise CRISP may core dump.

This command is only intended for use by macro programmers,
and macros using \fIattach_buffer()\fR should be frequently saved
during development to avoid unexpected crashes.
.Fo RETURN VALUE
No value is returned.
.Fo EXAMPLES
The following example shows the outline of a macro which
attaches a new buffer to the current window.
.DS
.ft CW
	int	newbuf = user_func();
	attach_buffer(newbuf);
	
	/* Refresh screen with new buffer contents. */
	refresh();
.ft R
.DE
.Fo SEE ALSO
create_buffer(), 
create_window(),
inq_buffer(), 
inq_window()
.HU autoload
autoload(file, macro1, [macro2], ..)
.Fo DESCRIPTION
This macro is used to define the whereabouts of macros.
Whenever CRISP encounters a reference to a macro which is
not currently defined, it searches an internal list to see
if an \fIautoload()\fR macro has mentioned it. If so, the file
parameter says in which file it can find the macro.

file should be specified as the basename of the macro file
(i.e. without a .m or .cm suffix). This lets CRISP search the
BPATH variable to see if it can find a .m or .cm file.

If it finds the file, it then performs a \fIload_macro()\fR
operation. If the macro definition is still not resolved
after auto-loading the macro file, then CRISP prints an
error message.

An arbritrary number of macro names may appear after the
file parameter.

autoloading is a useful feature since it speeds CRISP up in
that it doesn't need to load macros which aren't referenced.
.Fo RETURN VALUE
Nothing.
.HU backspace
backspace()
.Fo DESCRIPTION
This deletes the character to the left of the cursor in the
current buffer. If the cursor is at the beginning of the
line then the current line is appended to the end of the
previous line.
.Fo RETURN VALUE
Nothing.
.HU beep
beep()
.Fo DESCRIPTION
This macro sends a bell or beep to the screen causing an
audible sound. This macro can be used by error macros.
.Fo RETURN VALUE
Nothing.
.HU beginning_of_line
beginning_of_line()
.Fo DESCRIPTION
Moves cursor to column 1 of the current buffer.
.Fo RETURN VALUE
Nothing.
.HU below
below(expr1, expr2)
.Fo DESCRIPTION
This primitive is a functional version of the '<' operator.
expr1  &  expr2  must  either be both integer expressions or
string expressions.
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
less than expr2; returns 1 if expr1 & expr2 are string
expressions and expr1 lexicographically preceeds expr2.
Returns 0 otherwise.
.HU below_eq
below_eq(expr1, expr2)
.Fo DESCRIPTION
This primitive is a functional version of the '<=' operator.
expr1 & expr2 must either be both integer expressions or
string expressions. 
.Fo RETURN VALUE
Returns 1 if expr1 and expr2 are integer values and expr1 is
less than or equal expr2; returns 1 if expr1 & expr2 are
string expressions and expr1 lexicographically follows expr2
or is equal to expr2. Returns 0 otherwise.
.HU bookmark_list
bookmark_list()
.Fo DESCRIPTION
This macro can be used to return a list containing all
currently defined bookmarks, or NULL if no bookmarks are
defined. The list is a list of 4-tuples in the following
format:
.DS
.ft CW
	{id, buf_id, line_no, col}
.ft R
.DE
.Fo RETURN VALUE
List containing all currently defined bookmarks.
.Fo SEE ALSO
delete_bookmark(), drop_bookmark(), goto_bookmark()
.HU borders
borders([expr])
.Fo DESCRIPTION
This macro can be used to turn off borders for windows. By
default they are on.

If expr is omitted, then the current value is toggled.
Otherwise the internal toggle is set to the value of expr.
Non-zero means borders are on.

On some terminals, having borderless windows is less
expensive on screen updating than on others, because of the
overhead involved in drawing the borders around the windows.
.Fo RETURN VALUE
Returns zero if borders are turned off; non-zero if borders
are enabled for windows.
.HU break
break;
.Fo DESCRIPTION
The break statement is used to terminate switch, while, do and for loops.
.Fo RETURN VALUE
Nothing.
.HU breaksw
(breaksw)
.Fo DESCRIPTION
The breaksw primitive is internal to the lisp-like macro language only.
It is generated by the crunch compiler when a 'break' keyword is encountered
inside a switch statement.
.Fo RETURN VALUE
Nothing.
.HU call_registered_macro
call_registered_macro(n)
.Fo DESCRIPTION
This macro is used to trigger a registered macro. n is an
integer expression specifying the registered macro to trigger.

See \fIregister_macro()\fR for further details on the different
registered macro types.
.Fo RETURN VALUE
Nothing.
.HU car
car(list_expr)
.Fo DESCRIPTION
This macro is used to make a copy of the first atom in the
expression list_expr.

Since lists may contain any data type, it is probably wise
to assign the result of a car operation to a polymorphic
variable, so that its type can be ascertained.
.Fo EXAMPLES
The following example prints a message saying what type the
variable at the head of a list is:
.DS
.ft CW
	list	llist;
	message("Type is %s.", typeof(car(llist)));
.ft R
.DE
.Fo RETURN VALUE
Returns the value of the first element in the list_expr.
.Fo SEE ALSO
cdr(), nth(), put_nth()
.HU cd
cd([path])
.Fo DESCRIPTION
This macro changes the current working directory. If path is
omitted, then the current path is displayed on the status
line.
.Fo EXAMPLES
Display current path on screen:
.DS
.ft CW
	cd();
.ft R
.DE

Change to users home directory:
.DS
.ft CW
	cd(inq_environment("HOME"));
.ft R
.DE
.Fo RETURN VALUE
0 if unsuccessful; non-zero if path changed.
.HU cdr
cdr(list_expr)
.Fo DESCRIPTION
The \fIcdr()\fR macro is used to create a new list out of an
existing list by removing the first atom in the list.

Using \fIcar()\fR and \fIcdr()\fR, macros can be written which
manipulate all elements on a list. However, it is more
efficient to use \fInth()\fR to extract individual elements, since
internally it avoids having to copy sub-lists.
.Fo RETURN VALUE
Returns the list formed by deleting the first element of the
list, list_expr.
.HU ceil
ceil(x)
.Fo RETURN VALUE
Returns smallest integer not larger than x. Return value is
a floating point number.
.HU change_window
change_window([direction], [msg])
.Fo DESCRIPTION
This macro is used to move to another window. direction
specifies in which direction to select the window. If it is
omitted, then the user is prompted to select the window, by
using the cursor keys.

If direction is specified, it should have one of the
following values:
.DS
	0	Up
	1	Right
	2	Down
	3	Left.
	4	'Other' window.
.DE

The \fImsg\fR parameter allows the calling macro to customise the message
appearing on the status line. If not omitted, the string \fB"Point to destination"\fR
is used.
.Fo RETURN VALUE
Returns 0 if unsuccessful; 1 if successful.
.HU chmod
chmod(mode, file)
.Fo DESCRIPTION
This primitive is used to change the protection and access information 
associated with a file. \fImode\fR is the set of protection bits as
defined by your operating system, and \fIfile\fR is the name of the file
or directory which should be changed.
.Fo RETURN VALUE
Returns 0 on success, -1 on failure. On a failure the global value
\fIerrno\fR is set to the reason for the failure.
.HU color
color([background], [normal], [region], [messages], [errors], [hilite], [hi_foreground])
.Fo DESCRIPTION
This macro is used to control the colors that CRISP uses on
a color display. (The values are ignored for monochrome
displays).

If any of the first 6 parameters
are omitted, then the values are prompted for.

\fIbackground\fR is the color for the background of normal text.
\fInormal\fR is the color associated with text in the editing
windows. \fIregion\fR is the color of text when it is marked in a
region. \fImessages\fR is the color for normal messages on the
status line. \fIerrors\fR is the colors for error messages on the
status line. \fIhilite\fR is used to indicate the relationship
between highlited text and its background.

Colors may be specified as integers or strings. Strings may
be specified in upper or lower case. The \fIhilite\fR parameter is to
specify the foreground and background color of hilighted text. It may be a
number of a string. If it is a number then the top nibble specifies
the background color, and the low nibble the foreground color.
If it is a string then it only specifies the background color.
If \fIhi_foreground\fR is specified it specifies the foreground color of the
hilighted region.
.P
.ne 1i
.TS H
center box;
cB cB
lw(1i) lw(2i).
Color no	Color name
=
0	Black
1	Blue
2	Green
3	Cyan
4	Red
5	Magenta
6	Brown
7	White
8	Dark-Grey
9	Light-Blue
10	Light-Green
11	Light-Cyan
12	Light-Red
13	Light-Magenta
14	Light-Yellow
15	Light-White
.TE

.Fo RETURN VALUE
Nothing.
.HU command_list
command_list()
.Fo DESCRIPTION
This macro is used to get a list of all the keywords in
CRISP. Its primary purpose is to support the help macro
package, and avoids hardcoding the macro primitives into a
macro or text file.

.Fo SEE ALSO
\fImacro_list()\fR
.Fo RETURN VALUE
Returns a list consisting of a sequence of strings which are
the names of all the CRISP macro primitives and all
currently defined macro names.
.HU compress
compress(string, [trim])
.Fo DESCRIPTION
This macro takes a string and removes all multiple white
space characters (spaces, tabs and newlines). If \fItrim\fR is specified
then \fIcompress()\fR acts the same as: trim(ltrim(compress(str))).

.Fo RETURN VALUE
Returns a copy of string with all spaces, tabs and newlines
mapped to single spaces.
.HU connect
connect([mode], [shell])
.Fo DESCRIPTION
This macro is used to create a sub-process and associate it
with the current buffer.

mode specifies some flags which are defined below. By
default, the process created is a shell process, and the
shell is got from the SHELL environment variable. If shell
is specified, then it is taken as the pathname of a shell to
execute.

Output from a sub-process is automatically inserted into the
buffer, at a position known as the process position (see
\fIinq_process_position()\fR, \fIset_process_position()\fR). This
position is analagous to the usual input cursor.

Any text which would normally be inserted into the buffer
via \fIself_insert()\fR, \fIinsert()\fR or \fIpaste()\fR is also forwarded to
the sub-process.

CRISP implements sub-processes out of pipes or pty's
depending on the availability of the underlying Unix
implementation. When using pipes, CRISP samples the output
from the pipe on a 1 second interval. Ptys have better
interaction since the select() system call is used.

mode is a set of flags which have the following meaning:

.ne 1i
.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Value	Description
=
.TH
0x01	T{
If this bit is set, then the buffer operates in echo mode,
i.e. the characters which are typed are inserted into the
buffer. If this bit is not set, then the buffer operates in
no-echo mode, and the characters the user types are not
directly inserted into the buffer, but instead only the
output from the sub-process.
T}
0x4000	T{
This bit indicates whether output from a process overwrites
text in the buffer or inserts and shifts text over as it
does so. This is needed to effectively allow typeahead to
not be destroyed but allow escape sequences to cause data in
the buffer to be overwritten when running termcap oriented
programs.
T}
0x8000	T{
This is the wait mode of operation. Normally when a buffer
is created, the output from the subprocess is inserted
directly into the buffer. Setting this bit causes the output
from the process to be held onto, until the calling macro
issues a wait() or waitfor() macro call.
T}
.TE
connect() may be called after a buffer has been connected to
change the mode flag.
.Fo RETURN VALUE
Returns 0 if buffer already connected; returns 1 if buffer
has been successfully connected.
.HU continue
continue;
.Fo DESCRIPTION
This macro is used to finish the current iteration of a
\fIwhile()\fR loop, and go back to the top of the loop, causing
the while condition to be re-evaluated.

This works similar to the C continue statement.
.Fo RETURN VALUE
Nothing.
.HU copy
copy([append])
.Fo DESCRIPTION
copy() copies the currently marked region to the scrap
buffer, and un-highlites the currently marked region.

If append is specified and is non-zero, then the text is
appended to the current scrap without deleting it first.
.Fo RETURN VALUE
Nothing.
.HU copy_keyboard
copy_keyboard(src_id, [cmd1 ...])
.Fo DESCRIPTION
This macro is used to copy key assignments from an alternate
keyboard id. cmd1, ..., are strings containing macro names.
These macro names are looked up in the source keyboard and
if found are assigned to the same keystrokes used in the
source keyboard. If no commands are specified, then the
entire keyboard is copied.

This macro is very useful for popup displays because it
allows the macro writer to ensure that if a user has
tailored the keyboard layout that the popup will use the
same keys at the main editing level, without having to
hard-code constants all over the place.
.Fo RETURN VALUE
Returns current keyboard id on success. If source keyboard
not found then returns zero.
.HU cos
cos(x)
.Fo RETURN VALUE
Cosine of x (in radians) as a floating point value.
.HU cosh
cosh(x)
.Fo RETURN VALUE
Hyperbolic-cosine of x as a floating point value.
.HU create_buffer
create_buffer(buffer-name, [file-name], [system], [edit_flags])
.Fo DESCRIPTION
This macro is used to create a new buffer. The buffer is
given the name "buffer-name" which may be any sequence of
ASCII characters. This buffer name is used to label the top
of any windows the buffer is attached to (see
attach_buffer). Care should be chosen in selecting buffer
names, since the top title on any displayed window may be
truncated if the window is not wide enough to handle the
title.

"file-name" is the full or relative path name of a file
which should be read into the buffer. If this parameter is
omitted, then an initially empty buffer will be created. The
"file-name" read into the buffer is saved for later use, if
the buffer is saved (via write_buffer).

[system] is an optional integer which indicates whether the
buffer is to be a system buffer or user buffer. If it is 0
or omitted, then the buffer is a user buffer; a non-zero
value indicates a system buffer. System buffers are like
normal buffers, except for two side-effects - no \fIundo()\fR
information is saved for operations on system buffers, and
most high-level macros tend to ignore system buffers, e.g. the
\fIbuffer_list()\fR macro does not usually display system buffers.

\fIedit_flags\fR is used to control how the specified file will
be read in to the buffer. These flags are
used to force CRISP to read the file in ascii, binary or \fInormal\fR
modes. Refer to the \fIedit_file()\fR primitive
for information describing this field.

System buffers are for use by user macros or CRISP supplied
macros and provide a way of storing information without
getting in the way of the user. \fIundo()\fR information is not
saved for these buffers, and thus means that operations on
system buffers are slightly faster than normal buffers. It
is not important that \fIundo()\fR information is not stored with
these buffers, because these buffers tend to only be
manipulated by the various macros - not directly by the user.
.Fo EXAMPLES
The following example shows how to create a buffer and
display it in the current window. \fIedit_file()\fR may be more
appropriate for this particular task, but the example is
illustrative.
.DS
.ft CW
	int	newbuf;
	
	newbuf = create_buffer("My Buffer", "myfile.txt");
	attach_buffer(newbuf);
	
	refresh();
.ft R
.DE
.Fo RETURN VALUE
Returns the buffer identifier associated with the newly
created buffer.
.HU create_char_map
create_char_map([cmap_id], [start_ch], ch_list, [flags_list])
.Fo DESCRIPTION
This primitive creates a character map. A character map is a
mapping between the characters stored in the buffer and the
way they are printed on the screen. Character maps have two
main uses - to configure how control characters and
characters with the top bit are printed, or to view
characters in a different format, e.g. hex.

If cmap_id is not specified, then a new character map is
created. If cmap_id is specified it should be an integer
value corresponding to a previously created character map
(or zero to change the default one).

Character maps are a mapping for all 256 possible byte
values. The ch_list parameter is a list giving upto 256
value for these sequences. If you only want to remap part of
the displayable character set, then specify start_ch to
indicate where you are starting.

ch_list may have upto 257 values. The 257th entry is used to
indicate how the end of a line should be marked. By default,
the end of line is marked with a space (i.e. not
distinguishable). The literal macro uses this character to
specify a '$' to mark end of lines.

CRISP understands that certain displayable characters need
special processing. These characters are specified by the
optional flags_list parameter. The flags list is specified
as a pairing of values. The first element in the pair is an
integer defining the character value, and the second entry
in the pair indicates the action to be performed. The
following actions are defined:

.TS
center allbox;
cB cB
lw(.8i) lw(3i).
Value	Meaning
=
0	No special processing.
1	Character is a tab.
2	Character is a backspace.
3	Character is an ESCAPE.
.TE

Backspace and ESCAPE flags are needed if you want the ANSI
processing mode to work.

For examples of this primitive, consult the view.cr macro.
.Fo RETURN VALUE
Returns the character map ID, or -1 if the specified map
does not exist.
.Fo SEE ALSO
inq_char_map(), set_buffer_cmap(), set_buffer_flags(),
set_window_cmap()
.HU create_edge
create_edge([direction])
.Fo DESCRIPTION
This macro is used to split the current window. The window
is split in the direction specified. If direction is not
specified then the user is prompted, and can use the arrow
keys to indicate the direction of the split.

If direction is specified, it should have one of the
following values:
.DS
    	0	Up
    	1	Right
    	2	Down
    	3	Left.
.ft R
.DE
.Fo RETURN VALUE
Returns 0 if unsuccessful; 1 if successful.
.HU create_tiled_window
create_tiled_window(lx, by, rx, ty, [buf])
.Fo DESCRIPTION
This macro is used to create a tiled window (as opposed to a
popup window). Normally tiled windows (background windows)
are created by the user splitting the current window. This
macro is provided to allow the implementation of the state
restore macro so that the window layout can be saved and
restored on restarting CRISP.

The (lx,by,rx,ty) arguments are the co-ordinates of the
window, irrespective of whether borders are enabled or not,
with (0,0) being the top left hand corner of the screen.

buf is an optional integer containing a buffer ID to attach
to the created window.

It is probably best to disable the screen updating whilst
using this macro, otherwise the screen may become
inconsistent. (Refer to the display_windows() macro).
.Fo RETURN VALUE
Returns the window id of the created window.
.HU create_window
create_window(left_x, bottom_y, right_x, top_y, [message])

.Fo DESCRIPTION
This macro is used to create a new window. left_x, bottom_y,
right_x and top_y specifies the co-ordinates of the window.

message is an optional string expression, which if specified
is a message to appear centered on the bottom line of the
window.

Be careful not to create windows which do not fit within the
physical screen, otherwise CRISP may crash.

The new window created becomes the current window - its id
can be inquired via \fIinq_window()\fR.
.Fo RETURN VALUE
Returns the window ID of the new window.
.HU cut
cut([append])

.Fo DESCRIPTION

The currently highlited region is copied to the scrap buffer
and the region deleted from the current buffer.

If append is specified and is non-zero, then the highlited
region is appended to the end of the scrap buffer, without
first clearing it.
.Fo RETURN VALUE

Nothing.

.HU cvt_to_object
cvt_to_object(val, [len])

.Fo DESCRIPTION

cvt_to_object may be used to parse a string and decode the
object contained in it, e.g. a number, or a float. It is the
converse to sprintf(), and may be used to parse a string
which may be input by the user or created by a program for
decoding. The 'val' parameter should be a string which
contains the object to be decoded.

\fIlen\fR is an optional integer variable which will receive the
number of characters used in the parsing. This may be useful
if the string contains multiple items which will need parsing.

.Fo RETURN VALUE

Value of 'val'. The value is an integer, or float or string
depending on the syntax of the item in the expression.

If the item cannot be parsed, then the NULL value will be
returned.

.HU date
date([year], [mon], [day], [month-name], [day-name])

.Fo DESCRIPTION

This macro retrieves the current date. year, mon and day are
optional integer variable names which receive the current
year, month number, and day of month number. Year is of the
form 1988; mon is in the range 1-12; day is in the range 1-31.

month-name is an optional string variable, and contains the
name of the month, in the format: January; day-name is an
optional string variable containing the day of the week, in
the form: Saturday.

.Fo RETURN VALUE
Nothing.
.Fo EXAMPLES

The following example can be used to print an american date
string:

.DS
.ft CW
	int	day, mon, year;
	date(year, mon, day);
	message("%02d/%02d/%02d", mon, day, year - 1900);
.ft R
.DE
.HU debug
debug([n])
.Fo DESCRIPTION
debug turns on or off the macro trace mode. When debug is
on, CRISP traces the execution of every macro statement, and
in addition traces assignments to the accumulators (integer,
string and list).

This is the primary means of debugging macros.

If n is omitted, then debugging is toggled and a message is
printed on the status line saying whether debug is on or off.

By default, debug toggles between 0 and 1. By specifying a
value for the debug macro, other events in CRISP can be
traced. The other bits are mostly for debugging CRISP
itself, and include the ability to trace the following:
.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Flag	Meaning
=
.TH
0x01	T{
Trace macro execution. 
T}
0x02	T{
Trace regular expression
parsing. This is used to check that regular expressions are being compiled
and executed correctly.
T}
0x04	T{
Trace buffer \fIundo()\fR information. Use this to check that a primitive
is recording the correct information to undo it.
T}
0x08	T{
Cause log file to be flushed each time it is written to. This
is useful when CRISP core dumps and you want to see the last primitive
executed. This significantly slows down operation.
T}
0x4000	T{
Turns on
tracing for the prompt history code. This traces execution of the command 
line macros.
T}
.TE

When debug is turned on, all debug output is put in the file
\fB/tmp/crisp.log\fR. The name of this file can be overridden by
specifying the environment variable \fBCRISP_LOG\fR.

If the user is trying to debug a macro which causes CRISP to
core dump, then CRISP should be run with the -f flag. This
causes all debug info to be flushed to the log file as it is
produced, rather than using the stdio buffering. By default
this is off, since it significantly slows CRISP down due to
the high volume of output.

.Fo EXAMPLES

The following is a small trace of debug output caused by
reformatting this paragraph with the ^F key.
.DS
.ft CW
*** DEBUG ON (0x0001) ***
02:.......  iACC=5
01:......  iACC=5

KEY_EXEC 0x404c => mark 3
	 (mark 3 )
	   iACC=3

KEY_EXEC 0x0006 => objects format_block
Execute macro: objects
02:.......(string function )
	  (int arg1 )
	  (get_parm 0 function )
	    function := format_block
	    iACC=1
	  (get_parm 1 arg1 )
	    iACC=0
	  (string macro_name ext )
	  (inq_names NULL ext NULL )
	    ext := h
	    iACC=0
	  (= macro_name (..) )
	  (+ (..) function )
	  (+ ext "_" )
	    lookup ext = 'h'
	    sACC='h_'
	    lookup function = 'format_block'
	    sACC='h_format_block'
	    macro_name := h_format_block
	    rsACC='h_format_block'
	  (if (..) (..) )
	  (! (..) )
	  (inq_macro macro_name )
	    lookup macro_name = 'h_format_block'
	    iACC=1
	    iACC=0
	    iACC=0
	  (execute_macro macro_name arg1 )
	    lookup macro_name = 'h_format_block'
03:........(macro wp_options (..) )
	   (macro autowrap (..) )
	   (macro get_autowrap (..) )
.ft R
.DE
.HU declare
declare var1, var2, ..;

.Fo DESCRIPTION

This is used to define one or more polymorphic
variables. Polymorphic variables are variables that may take
on any of the available CRISP data types (integer, string or
list), depending on context.

Polymorphic variables are most useful when dealing with
lists which contain unknown data types.

The variables declared are made into local variables, unless
a \fIglobal()\fR declaration follows.

By default, polymorphic variables are typed as integers, and
are given the value zero.
.HU del
del(filename)

.Fo DESCRIPTION

THIS FUNCTION IS PROVIDED FOR COMPATABILITY ONLY via the brief.cr MACRO FILE.

This macro is used to delete a file, as specified by the
string expression 'filename'.

Wild-cards, etc, are not valid in 'filename'.
.Fo RETURN VALUE

Zero or less if unsuccessful; greater than zero means the
file was successfully deleted.
.Fo SEE ALSO
remove()
.HU delete_block
delete_block()

.Fo DESCRIPTION

The currently highlited block is deleted.
.Fo RETURN VALUE

Nothing.
.HU delete_bookmark
delete_bookmark(book_no)
.Fo DESCRIPTION
This macro is used to delete a bookmark. book_no is an integer
containing the bookmark to delete.
.Fo RETURN VALUE
Nothing.
.Fo SEE ALSO
bookmark_list(), drop_bookmark(), goto_bookmark()
.HU delete_buffer
delete_buffer(bufnum)

.Fo DESCRIPTION

This command deletes the buffer specified by bufnum. The
entire buffer contents are freed, and any other resources
attached to that buffer are destroyed as well. In the case
of a process buffer, the subprocess is killed.

Any attempt to \fIset_buffer()\fR to a buffer which has been
deleted will fail.

Care should be taken with \fIdelete_buffer()\fR since no tests are
made to see if the buffer being deleted is currently
displayed. If a currently displayed buffer is deleted, then
CRISP may core-dump. Macros using \fIdelete_buffer()\fR should be
carefully tested to ensure this does not happen, e.g. by
calling \fIinq_views()\fR.

.Fo RETURN VALUE

No value is returned.

.Fo EXAMPLES

The following example creates a temporary buffer and then
deletes it after restoring the current buffer at the time of
the macro is invoked.
.DS
.ft CW
	int	newbuf;
	int	curbuf;
	
	curbuf = inq_buffer();
	newbuf = create_buffer("Example", NULL, 1);
	
	set_buffer(newbuf);
	  .
	  .
	set_buffer(curbuf);
	delete_buffer(newbuf);
.ft R
.DE
.HU delete_char
delete_char([num])

.Fo DESCRIPTION

This macro deletes one or more characters from the current
buffer. If num is not specified, then 1 character is
deleted; if num is specified then that number of characters
are deleted. The deleted characters are on and to the right
of the current buffer position.

This macro is the default assignment for the <Delete> key on
the keyboard.
.HU delete_edge
delete_edge([direction])

.Fo DESCRIPTION

This macro can be used to delete a window on-screen. It is
used by specifying an edge, and if there is another window
which adjoins the edge, then the edge is deleted and the two
windows combined into one.

direction specifies the edge to delete and if not specified,
is prompted for, and the user can use the arrow keys to
specify the edge.

When using this macro, the edge to be deleted must not be
obscured by other edges, i.e. only tiled window support is
allowed for this macro.

If direction is specified, it should have one of the
following values:
.DS
	0  Up
	1  Right
	2  Down
	3  Left
.DE
.Fo RETURN VALUE
Returns <= 0 if unsuccessful; >0 otherwise.
.HU delete_line
delete_line()

.Fo DESCRIPTION

This macro deletes the line the cursor is currently on. The
cursor is placed at the same column position in the line
below the one deleted.

.Fo EXAMPLES

The following example assigns the \fIdelete_line()\fR macro to the
<ALT-D> key (the usual case).
.DS
.ft CW
	assign_to_key("<Alt-D>", "delete_line");
.ft R
.DE
.HU delete_macro
delete_macro([file])

.Fo DESCRIPTION

This macro is used to delete all macros which were loaded
from a particular macro file. file is a string expression
and if omitted is prompted for, containing the name of the
file.

This is currently a no-op in CRISP - macros are not
deleteable entities. The storage allocated for a macro is
lost when a macro by the same name is loaded from another
file.
.Fo RETURN VALUE

Nothing.

.HU delete_to_eol
delete_to_eol()

.Fo DESCRIPTION

This macro deletes all characters up to the end of the line
in the current buffer.
.Fo RETURN VALUE
Nothing.

.HU delete_window
delete_window([win_id])

.Fo DESCRIPTION

This macro can be used to delete a window. If win_id is not
specified then the current window is deleted.

.Fo RETURN VALUE

Nothing.

.HU disconnect
disconnect()

.Fo DESCRIPTION

This macro is used to kill a sub-process attached to a
buffer. The subprocess is sent a SIGTERM followed by a
SIGKILL signal.
.Fo RETURN VALUE

Nothing.

.HU display_mode
display_mode([flags])

.Fo DESCRIPTION

This macro is used to read and optional set the display
control flags. The display control flags are a set of
attributes used to control the way certain things happen on
the screen. The flags are defined as follows:

0x0001 Window mode. This indicates we are running natively under a windowing
system, e.g. X-Windows. This bit is read only.

0x0002 When set, causes pop up windows to have a shadow
(Default is set). This may be turned off for slow terminals.

0x0004 This indicates that the window shadow should show through the
underlying text on the screen.
.Fo RETURN VALUE

Returns previous value of display control flags.

.HU display_windows
display_windows([enable])

.Fo DESCRIPTION

This macro is used to enable the display. By default when
CRISP starts up, the code for updating the screen is
disabled. The startup macros initialise CRISPs internal
character translation tables and then call this macro to
allow CRISP to proceed.

If enable is not specified, then the current value is
toggled. If it is non-zero, then the display is enabled.

If the display is not enabled, then CRISP can be used as a
normal programming language, in the style of awk and sed,
using the command line arguments to load and execute a file.
.Fo RETURN VALUE

Previous value of the display flag.

.HU distance_to_tab
distance_to_tab()

.Fo DESCRIPTION

This macro returns the number of characters between the
current cursor location and the next tab stop, even if there
are no more characters after the cursor. This number will
always be > than zero.

If the cursor is on a tab stop, then the number of
characters to the next tab stop are returned.\
.Fo RETURN VALUE

Number of characters between current cursor location and
next tab stop.

.HU do
do stmt while (cond);

.Fo DESCRIPTION

The do keyword is used to implement a C-like do loop. This loop structure
is similar to the (while) macro, except the condition for
loop termination is tested at the end of the loop. stmt is
evaluated at least once.

\fIbreak\fR and \fIcontinue\fR may be used within a do-loop.
.Fo RETURN VALUE

Returns zero.

.HU dos
dos([command] [use_shell] [completion])

.Fo DESCRIPTION

THIS FILE IS PROVIDED FOR COMPATABILITY ONLY via the brief.cr MACRO FILE.

Please see
the \fIshell()\fR command for further information.
.Fo RETURN VALUE

Returns the shell exit status (under Unix, 0 means command
exited successfully, non-zero means command failed for some
reason).

.HU down
down([lines])

.Fo DESCRIPTION

Moves the cursor to the same column on the line below. If
lines is specified then cursor is moved to the lines'th line
after the current. lines may be negative in which case the
cursor moves backwards.
.Fo RETURN VALUE

Nothing.

.HU drop_anchor
drop_anchor([type])
.Fo DESCRIPTION

This macro is used to define a region within the current
buffer. type specifies the type of region, and the values
are given below. If omitted a normal marked region is
selected.

Regions are areas of a buffer upon which some macros have
special effects, e.g. \fIcut()\fR and \fIcopy()\fR are used to extract
fragments of buffers and save them for later re-insertion.
The \fIsearch_fwd()\fR and \fIsearch_back()\fR macros can be told to
limit their searches to the highlited regions, etc.

Regions are displayed on screen either in a different color,
or in reverse video so that they stand out.

The following are the different region types:
.DS
	1 Normal 
	2 Column 
	3 Line 
	4 Non-inclusive.
.DE

A normal mark is a region which encompasses from the place
where the anchor was dropped upto and including the current
cursor position. A non-inclusive mark is the same but does
not include the current cursor position.

A line mark selects entire lines, and allows for easy
movement of text from one part of a buffer to another.

A column mark is similar to a normal mark, except it
displays differently on screen, and allows rectangular
sections of the current buffer to be marked.

The currently selected marked area can be found, via
\fIinq_marked()\fR. Column operations are not directly supported
by CRISP internally, but instead are supported by the macros
supplied with CRISP.

Regions are nestable, i.e. multiple \fIdrop_anchor()\fR's can be
issued without any intervening \fIraise_anchor()\fR.

The marked region can be cleared by calling \fIraise_anchor()\fR
or performing a \fIcopy()\fR or \fIcut()\fR operation on the buffer.
.Fo RETURN VALUE

Nothing.

.HU drop_bookmark
drop_bookmark([book_num], [yes], [buf], [line], [col])

.Fo DESCRIPTION

This macro is used to set a bookmark. A bookmark is like a
normal bookmark - it is a place holder in a buffer. book_num
is an identifier associated with the bookmark. Any valid
integer can be used as the identifier. yes is a string which
if set to 'y' or 'Y' will cause any previous bookmark with
the same identifier to be overwritten.

If buf, line & col are non-NULL, then bookmark book_num is
set to the specified buffer at the designated line and
column position. If buf, line or col are NULL then the
bookmark is set from the current buffer, line and column
position.

.Fo RETURN VALUE

Greater than zero if bookmark dropped, or zero if operation
failed.
.Fo SEE ALSO
bookmark_list(), delete_bookmark(), goto_bookmark()

.HU echo_line
echo_line([flags])

.Fo DESCRIPTION

The \fIecho_line()\fR macro is used to control which fields are
visible in the status line. If flags is omitted then the
current setting is returned.

flags is an integer expression, whose bit pattern is
interpreted as follows:
.DS
	0x01	Line: field enabled. 
	0x02	Col: field enabled. 
	0x04	Percentage through file enabled. 
	0x08	Current time enabled.
	0x10	REmember/PAuse reminders enabled. 
	0x20	Cursor type displayed.
.DE
.P
The cursor type is only used if the screen cannot change the
cursor type to indicate insert/overtype and normal/virtual
space.

.Fo RETURN VALUE

Previous value of flags.

.HU edit_file
edit_file([mode,] [file1], [file2], ..)

.Fo DESCRIPTION

This macro is the usual way of editing a file; if a buffer
is already allocated for the file, then that is set as the
current buffer. Otherwise a new buffer is created, the
contents of the named file are read into that, and the
filename is associated with that buffer (so that later on a
\fIwrite_buffer()\fR can be used to save any changes made to the
buffer).

The argument list is a set of strings and optional mode specifications.
Mode specifications are integers which are used to control how subsequent
files are read in. The default is '\fInormal\fR'. In normal mode,
CRISP looks at the file as it is read in and tries to decide (sometimes
wrongly) whether a file is binary, ascii, or a MSDOS-like file with
carriage returns as well as linefeeds at the end of each line. When a file
is read, if there are more than a certain number of non-printable characters
in at the beginning of the file (controlled by the \fIset_binary_size()\fR
primitive), then the file is broken into fixed length chunks per line,
rather than using the line-feed character as the line terminator.

For ASCII files, newlines preceded by a carriage return are treated as
DOS files and the carriage return is removed and a flag is set for
the buffer so that when the file is subsequently written back to disk,
the carriage returns will be automatically added on. Only the first
line is checked for the CR character before a LF. If there isn't a CR
before a LF at the end of the first line, then the file is a normal Unix
ascii file. Any subsequent CR's detected in the file are kept.

If the mode specification flag is specified then it applies to all
subsequent files in the argument list, or until another mode specification
is met. The mode specification flag can be used to 'override' the 
default heuristic described in the previous paragraphs and is a set of
bits defined as follows:

.TS H
center allbox;
cB cB cB
lw(.5i) lw(1i) lw(3i).
Value	Name	Description
=
.TH
0x00	EDIT_NORMAL	This is the default.
0x01	EDIT_BINARY	Force file to be treated as a binary file.
0x02	EDIT_ASCII	Force file to be treated as an ASCII file.
0x04	EDIT_CR	T{
Force CR return characters at end of line to be removed on input, and
written on output.
T}
.TE
.P
This macro supports wild-cards and the ability to edit
multiple files at once. If more than one argument is
specified, then a separate \fIedit_file()\fR is performed on each
file, and the current buffer is set to the last file read in.

The normal c-shell wildcards are supported:
.DS
*	wild-card -- matches any number of characters. 
?	wild-character -- matches any single character. 
[l-m]	any character in range at this character. 
~/	as first part of filename matches home directory 
~user/	matches 'user's home directory.
.DE

If no filenames are specified, the user is prompted for a
filename.

.Fo RETURN VALUE

Returns 1 if new file edited; zero if edit_file aborted at
the Edit file prompt; returns < 0 if its a new file or
permission denied. On an error, the global variable \fIerrno\fR will be set
to the reason for the failure.

.Fo EXAMPLES

The following example can be used to read in all .c files in
the current directory:

edit_file("*.c");
.HU ega
ega([mode])

.Fo DESCRIPTION

This macro can be used to toggle between EGA 25 line mode
and EGA 43 line mode -- only if CRISP is running under Unix
V.3.2 or above on an EGA or VGA console.

If mode is not specified, then only the current EGA state is
returned.

NOTE:: This primitive is subject for removal.
.Fo RETURN VALUE

Previous value of EGA mode.

.HU end_of_buffer
end_of_buffer()

.Fo DESCRIPTION

Moves the cursor to the end of the last line in the current
buffer.
.Fo RETURN VALUE

Nothing.

.HU end_of_line
end_of_line()

.Fo DESCRIPTION

Moves the cursor to the end of the current line.
.Fo RETURN VALUE

Nothing.

.HU end_of_window
end_of_window()

.Fo DESCRIPTION

Moves the cursor to the last line of the window. The cursor
stays in the same column position.
.Fo RETURN VALUE

Returns 1 if cursor moved; 0 if cursor stayed in the same
position.

.HU error
error(fmt, [arg1], [arg2], ..)

.Fo DESCRIPTION

This macro is used to print a message on the status \fIprompt\fR
line. \fIfmt\fR is a string with possible embedded printf-like %
options. arg1, arg2, .. are optional arguments (upto 4
parameters) which either evaluate to strings or integer
values.

The % options are the same as for the underlying printf()
which the system supports. (Internally the string coding is
handled by sprintf). Please see the description of the
\fImessage()\fR macro for a list of the minimum supported set of %
options.

This macro is similar to \fImessage()\fR except that the message
string is classified as an error. Error messages are printed
in the error color (see \fIcolor()\fR).

In addition, if the pause_on_error flag has been set (see
\fIpause_on_error()\fR) then the error message is displayed
suffixed with a '..' and CRISP waits for the user to type
any key to continue. This is useful in debugging.

Error messages are truncated if they are too long.

.Fo RETURN VALUE
Nothing.
.Fo EXAMPLES
.DS
.ft CW
	string	mac = "fred";
	
	error("Macro %s not loaded", fred);
.ft R
.DE
.Fo SEE ALSO
message(), printf()
.HU eval
eval(str)

.Fo DESCRIPTION

This function evaluates the string 'str' as if it were a
program written in the CRUNCH language. The program may be
any sequence of valid program statements/function definitions.

Please note that the C-preprocessor functions are not
available in this mode.
.Fo RETURN VALUE

Result of executing the program 'str'.

.HU execute_macro
execute_macro([macro], [args])

.Fo DESCRIPTION

This macro is used to execute another macro. It is needed
because it is the only way to execute a macro which is
defined by a string expression, rather than by virtue of the
CRISP language syntax.

macro should be a string expression and if omitted is
prompted for; args are optional and are the arguments passed
to the macro.
.Fo RETURN VALUE

Returns the value of (macro args).

.HU exist
exist(filename)

.Fo DESCRIPTION

Checks for existence of file. The existence of the file is
performed by doing a stat() call on the named file.
Therefore this can be used for all file types (including
character/block devices, etc).
.Fo RETURN VALUE

Non-zero if filename exists; zero if file does not exist.
If file does not exist, then the global variable \fIerrno\fR is set to
the reason for the error.

.HU exit
exit()

.Fo DESCRIPTION

This macro is used to exit from CRISP, or from a recursive
\fIprocess()\fR macro invocation.

If called at the bottom level of CRISP, CRISP goes through
its exit procedure and prompts the user if he/she is sure,
if there are any buffers which have been modified.

If called from within a nested invocation of \fIprocess()\fR, on
the next attempt to read keyboard input the calling
\fIprocess()\fR macro will return.

Note that CRISP currently does not support the
[are_you_sure] option which BRIEF supports.
.Fo RETURN VALUE

Nothing.

.HU exp
exp(x)

.Fo RETURN VALUE

Returns the irrational number 'e' to the power of x as a
floating point value.
.HU _extension
_extension()
.Fo DESCRIPTION
This macro is a callback macro called whenever CRISP edits a file
via the edit_file() primitive. It is provided to allow users to write their
own hooks, e.g. to set tab stops on a file extension basis.

This macro is called with no arguments.
.HU extern
extern TYPE var1, var2, ..;

.Fo DESCRIPTION

The extern keyword is used to declare variables which are not defined
within the current file or function, but are available elsewhere.
Essentially the extern keyword creates a place holder in the symbol table
to avoid undefined symbol reference errors.
.HU fabs
fabs(x)

.Fo RETURN VALUE

Absolute value of x, |x| as a floating point value.
.HU _fatal_error
_fatal_error()
.Fo DESCRIPTION
This is a callback macro. It is called when CRISP detects a segmentation
violation internally, and exists to allow the called macro to take
emergency actions and save any modified buffers to disk. Segmentation
violations should not normally occur, and may occur due to bugs in either
a users macro, or some rarely used primitive. The macro that is called
should use very few facilities of CRISP to avoid hitting the same bug
again.

Refer to the \f(HBcore.cr\fR macro for an example of how this macro is
uesd.
.HU file_glob
file_glob(string)

.Fo DESCRIPTION

This macro implements a shell-style globbing facility, and
facilitates writing macros which want to perform wild-card
name expansion.

.Fo RETURN VALUE

A list of strings corresponding to the filenames which match
the wild card expression in string.

.HU file_pattern
file_pattern(filespec)

.Fo DESCRIPTION

This macro is used in conjunction with the \fIfind_file()\fR macro
to implement a directory lookup mechanism.

filespec is a string expression which should evaluate to a
file name or a wild-card filename. \fIfind_file()\fR can then be
used to read the filenames of files which match the file-spec.

.Fo EXAMPLES

See example in \fIfind_file()\fR for an example of how to iterate
through all files in the current directory.
.Fo RETURN VALUE

Nothing.
.Fo SEE ALSO
find_file(), file_list()
.HU find_file
find_file([name], [size], [mtime], [ctime], [mode])

.Fo DESCRIPTION

\fIfind_file()\fR is used in conjunction to evaluate filenames in
a particular directory. The base directory and wild-card
filename pattern are set via \fIfile_pattern()\fR. Thereafter
\fIfind_file()\fR can be called repeatedly, until it fails,
receiving the next file name which matches the pattern set
in \fIfile_pattern()\fR.

name is an optional name of a string variable, which
receives the filename which matched the pattern if the
\fIfind_file()\fR was successful. size is the size of the file (in
bytes), and is an integer variable. mtime and ctime are the
names of integer variables and receive the last modification
and creation times, as returned by the Unix stat() system
call. mode is the file mode as returned by stat(), and
should be the name of an integer variable.

There are two hash-defines in crisp.h which define two of
the bit definitions for the mode field. These definitions
are taken from the /usr/include/sys/stat.h file. If you use
these #define's be careful to ensure they are compatible
with your Unix system.

For a more thorough example of the use of these primitives,
see the abbrev.m macro file.

.Fo EXAMPLES

The following example evaluates the names of all files in
the current directory and inserts the names and mode
information into the current buffer.
.DS
.ft CW
	string	name;
	int	mode, size;
	
	file_pattern("*");
	while (find_file(name, size, NULL, NULL, mode) > 0) {
		sprintf(buf, "file=%s, size=%d, mode=%x", 
			name, size, mode);
		insert(buf + "\n");
		}
.ft R
.DE
.Fo RETURN VALUE

Returns zero if there are no more files; returns 1 if next
directory entry successfully received.
.Fo SEE ALSO
file_pattern(), file_list()

.HU find_macro
find_macro(filename)

.Fo DESCRIPTION

This primitive is similar to the load_macro() primitive but
it doesn't actually load the specified macro. The current
macro path (BPATH) is searched looking for the specified
file. If the specified file has an extension, then an exact
match is located. If no extension is specified, then files
with the extensions: .cm, .cr, and .m are searched in that
order.

This macro is designed to allow user macros to locate macro
files using the same algorithm as the laod_macro() primitive
uses.
.Fo RETURN VALUE

String containing full path and filename of macro file, or
the NULL string if not file could be found.

.Fo SEE ALSO
autoload, load_macro
.HU first_time
first_time()

.Fo DESCRIPTION

CRISP maintains an internal 'first_time' flag for every
macro; after the first call to the macro, the flag is set to
FALSE. This makes it easier for macros to perform a
once-only initialisation.
.Fo RETURN VALUE

1 if this is the first time a macro has been called; 0
otherwise.

.HU float
float var1, var2, ...;

.Fo RETURN VALUE

Declares a floating point variable. (64-bit size).

.Fo DESCRIPTION

This primitive is used for declaring a floating point
variable. Floating point variables are stored using double
precision (64-bits).

Future versions of CRISP may use single precision floating point
format for floats. If you want to ensure that your code will
use double precision format, use the \fIdouble\fR declaration
keyword.
.Fo SEE ALSO
double
.HU floor
floor(x)

.Fo RETURN VALUE

Largest integer not greater than x, as a floating point
number.
.Fo SEE ALSO
ceil
.HU fmod
fmod(x, y)

.Fo RETURN VALUE

Floating point remainder of x/y (x and y both floating
point), with the same sign as x.
.HU for
for (init; cond; post) stmt

.Fo DESCRIPTION

This macro is used to implement a C-like loop structure.
init, cond, post and stmts maybe expressions or a list of
statements to execute. The init expression is evaluated
first. Next the cond condition is evaluated. If it is
non-zero, then the stmt expression is evaluated, followed by
evaluation of the post expression. The loop continues until
the cond expression evaluates to non-zero.
.Fo RETURN VALUE

Returns the value of the last statement executed in the
loop. Normally zero.

.HU frexp
frexp(x, exp)

.Fo RETURN VALUE

This function converts the floating point number x into a
normalized fraction in the interval [1/2, 1]. This value is
returned ans the power of 2 representing the exponent is
stored in exp. exp should be an integer variable.

.HU get_color
get_color([background], [normal], [region], [messages], [errors], [hilite_bg], [hilite_fg])

.Fo DESCRIPTION

This macro can be used to find out the values of the color
attributes of the screen. Each argument is an optional
integer variable to receive the specified color.

The colors are integers which are defined below.
.TS H
center box;
cB | cB
lw(.8i) | lw(3i).
Code	Color
_
.TH
0	Black 
1	Blue 
2	Green 
3	Cyan 
4	Red 
5	Magenta 
6	Brown (or dark yellow) 
7	White 
8	Dark Grey 
9	Light Blue 
10	Light Green
11	Light Cyan 
12	Light Red 
13	Light Magenta 
14	Light Yellow
15	Light White.
.TE
.Fo RETURN VALUE

Nothing.
.HU get_mouse_position
get_mouse_position(x, y)
.Fo DESCRIPTION
This primitive is used to receive the x and y co-ordinates of the
last mouse press or release. The values returned are only valid immediately
after the macro assigned to a button press event. Any subsequent calls
to read_char() or process() will overwrite the internal values.

x and y should be integer variables.
.Fo RETURN VALUE
Nothing
.Fo SEE ALSO
process_mouse(), translate_pos()
.HU getenv
getenv(name)

.Fo DESCRIPTION

This function looks up '\fIname\fR' in the environment and returns
the value of name. It is similar to the C function getenv().
.Fo RETURN VALUE

Returns a string which is the contents of the named
environment variable, or the null string if the variable
does not exist.
.HU get_parm
get_parm([arg], var, [prompt], [length], [default])

.Fo DESCRIPTION

\fIget_parm()\fR is the mechanism for accessing parameters passed
to macros. \fIget_parm()\fR can also be used to prompt the user
for input, and possibly specify a default value.

Arguments passed to macros are numbered, zero upwards. If
arg is specified, then it is evaluated to the value of the
argument number to be retrieved. If it is NULL, then the
user is prompted for the value, in which case prompt is the
message to prompt the user, and default (if specified) is
the default value which the user can then edit, using the
command line editing. If length is specified, it is the
maximum number of characters in the user's input (usually
used only for string variables). The users input is
terminated by hitting <Enter> or reaching the length.

var is the name of an integer, string or list variable. If
the user is being prompted, then only integer and string
expressions may be input. List expressions are not supported.

Arguments passed to macros are passed as call by name, ie
every time a \fIget_parm()\fR is issued on a particular parameter,
that parameter is re-evaluated. This can be very useful
sometimes, and at other times it can cause anomalous
side-effects.

.Fo RETURN VALUE

Zero if user aborted prompt, or argument number does not
exist. Greater than zero if successful.

.HU get_term_characters
get_term_characters([top_left], [top_right], [bot_left], [bot_right], 
[vertical], [horizontal], [top_join], [bot_join], [cross], [left_join], 
[right_join])

.Fo DESCRIPTION

This macro can be used to find out the current settings for
the various characters which make up the special characters
needed to display the window borders on the screen.

Each parameter is the name of a string variable to receive
the string expression. Any of the parameters may be omitted.

This macro is designed to allow macros to be written which
make it easier for the user to tailor the display.

Refer to \fIset_term_characters()\fR for further detail on the
meaning of each of these characters.
.Fo RETURN VALUE

Nothing.

.HU get_term_features
get_term_features([space], [char], [icursor], [ocursor],
[vicursor], [vocursor], [escape], [repeat], [zerom], [color])

.Fo DESCRIPTION

This macro is used to retrieve the terminal options which
the current display supports. All the parameters are the
names of string variables, except for zerom and color which
are the names of integer variables.

Refer to \fIset_term_features()\fR for a description of the
meaning of each feature.

This macro is designed to be used to allow macros to be
written which allow the user to easily tailor his/her
display environment.
.Fo RETURN VALUE

Nothing.

.HU get_term_keyboard
(get_term_keyboard ..)

.Fo DESCRIPTION

This macro is designed to allow the calling macro retrieve
the assignments for each key, so that a user interface can
be written to examine and display the key bindings.

See \fIset_term_keyboard()\fR for more details of how this macro
is supposed to work.

This macro has not been currently implemented.
.Fo RETURN VALUE

Nothing.

.HU getpid
getpid()

.Fo DESCRIPTION

This function exists to allow macros to be written which
need to generate unique filenames. The process ID can be
embedded in temporary filenames to avoid clashes with any
other users running CRISP.

.Fo EXAMPLES

The following example generates a filename for a temp file
in the /tmp directory.

.DS
.ft CW
	string	filename;
	sprintf(filename, "/tmp/cr.xx%05d", getpid());
.ft R
.DE
.Fo RETURN VALUE
Returns the current process ID (as returned via getpid()).

.HU global
global var1, var2, ..;

.Fo RETURN VALUE

Nothing.

.Fo DESCRIPTION

The global macro is used to make local variables into global
variables. Local variables are destroyed when the macro
executing them terminates. Global variables maintain their
value across macro invocation and occupy permanent static
storage.

A variable must have been specified in a previous \fIint\fR,
\fIstring\fR, \fIlist\fR, \fIfloat\fR or \fIdeclare\fR 
statement before it can be
made into a global.

THIS PRIMITIVE IS AN INTERNAL PRIMITIVE AND SHOULD NOT BE USED BY
USERS WHO WRITE MACROS USING THE CRUNCH LANGUAGE. THIS IS HANDLED
AUTOMATICALLY FOR YOU BY THE COMPILER.
.HU goto_bookmark
goto_bookmark([book_no], [bufnum], [line], [col])

.Fo DESCRIPTION

book_no is an integer; bufnum, line & col are optional
names of integer variables.

This macro is used to move the cursor to a previously saved
bookmark. If bufnum, line & col are all NULL or omitted,
then the buffer and cursor information associated with
book_no are selected.

If any of bufnum, line or col are specified, then these
variables are modified to have that information associated
with the designated bookmark.

If book_no is omitted, then the user will be prompted for
the bookmark number to go to.

.Fo EXAMPLES

The following example gets the buffer, line & col associated
with bookmark 5.
.DS
.ft CW
	int	buf, line, col;
	
	goto_bookmark(5, buf, line, col);
.ft R
.DE

The following example jumps to bookmark 5:

.DS
.ft CW
	goto_bookmark(5);
.ft R
.DE

.Fo SEE ALSO
bookmark_list(), delete_bookmark(), drop_bookmark()
.Fo RETURN VALUE

1 if macro was successful; 0 if bookmark invalid or prompt
was aborted.

.HU getwd
getwd(ignored, dir)

.Fo DESCRIPTION

This function returns the current directory in the string
variable dir. The ignored parameter exists for compatability
with BRIEF which allows the calling macro to specify the
drive for the directory. Unix does not support the concept
of multiple current directories, and so is ignored.
.Fo RETURN VALUE

Returns 1.

.HU goto_line
goto_line([line])

.Fo DESCRIPTION

Moves the cursor to the beginning of the specified line. If
line is omitted it is prompted for.
.Fo RETURN VALUE

Nothing.

.HU goto_old_line
goto_old_line([line])

.Fo DESCRIPTION

When a file is read into a buffer, each line is internally
numbered. These internal line numbers are maintained even if
lines are inserted and deleted from the buffer.
\fIgoto_old_line()\fR moves the cursor to the line whose original
line number was line, or as near as possible if the original
lines have been deleted.

This macro gets over the problem of editing a source file to
correct compilation errors, and the lines with errors moving
as text is inserted or deleted.

If line is omitted, it is prompted for.

.Fo RETURN VALUE

Nothing.

.HU if
if (expr) true-clause [else false-clause]

.Fo DESCRIPTION

The expression 'expr' is evaluated, and if it is non-zero
(true) or is a non-null string, then the true-clause statements are
evaluated. Otherwise, if the false-clause is specified, then
it is evaluated.
.HU index
index(search-string, pattern)

.Fo DESCRIPTION

This function is used to see whether search-string contains
the substring pattern. A literal substring match is
performed. This function returns the place in search-string
where pattern has been located or 0 if it does not occur in
the search-string.

If the user needs to search for regular expressions, then
the function search_string should be used instead.

.Fo EXAMPLES

The following example checks to see if a string is a lower
case alphabetic character:
.DS
.ft CW
	string	letter;
	
	if (index("abcdefghijklmnopqrstuvwxyz", letter) == 0) 
		message("%c is upper case.", letter);
	else
		message("%c is lower case.", letter);
.ft R
.DE
.Fo RETURN VALUE

Returns 0 if pattern cannot be found in search-string;
otherwise returns the position pattern starts at in
search-string.

.HU input_mode
input_mode(char, flag)

.Fo DESCRIPTION

This macro is used to control the effect of certain 'system'
characters when they are typed in, specifically Ctrl-S (0x13),
Ctrl-Q (0x11) and Ctrl-Z (0x1a). Normally CRISP does not see these
characters and they perform the actions of XON/XOFF and the
Job control stop.

On serial terminals it is important to enable flow control
because the terminal may not be able to keep up with CRISP
when it is redrawing the screen.

Some people want to use these characters as keys for macro
assignments. Therefore this macro exists to allow users to
turn on and off these characters, and thus let CRISP see them.

char should be set to the ASCII value of the character to be
changed. Flag should be set to TRUE to allow CRISP to see
the character or to zero to let the operating system take
its normal action.

Note, setting either of Ctrl-S and Ctrl-Q causes both to be
set together.

Setting Ctrl-Z is only meaningful on systems that support
Job control.

Note that this primitive is only operational on Unix systems
that support the TERMIO feature.
.Fo RETURN VALUE

Returns 1 if character previously enabled; zero otherwise.

.HU inq_assignment
inq_assignment(key, [convert])

.Fo DESCRIPTION

This macro can be used to find out what macro a particular
keyboard character is assigned to, or to which key or keys a
particular macro is assigned to.

key maybe a string denoting the key sequence to be decoded
or an integer representing the internal key code. If key is
a string then it should be of the form described under
\fIassign_to_key()\fR.

convert is an integer expression; if omitted or zero, then
key is treated as a keyboard character (as defined for
\fIassign_to_key()\fR), and the name of the macro assigned to that
keystroke is returned. If the character is not assigned to a
macro, and the character is inserted into the buffer when
the user hits it, then the string "self_insert" is returned.
If there is no key assignment for that key, then "nothing"
is returned.

If convert is specified and is non-zero, then 'key' is taken
as the name of a macro and the keys assigned to invoke this
macro are returned. The key assignment returned is returned
using the portable key definitions defined for
"assign_to_key".

If more than one key stroke is assigned the same macro
invocation, then the returned string will contain the string
"<-also>" separating the key sequences.

.Fo EXAMPLES
The following example displays the message '<Alt-H>':
.DS
.ft CW
	message("%s", inq_assignment("help"));
.ft R
.DE
.Fo RETURN VALUE

Returns the name of a macro assigned to a keystroke or the
name of a keystroke assigned to a macro.

.HU inq_borders
inq_borders()

.Fo DESCRIPTION

Not currently implemented.
.Fo RETURN VALUE

Returns zero if borders are off; non-zero if borders are on.

.HU inq_brief_level
inq_brief_level()

.Fo DESCRIPTION

This function exists for compatability with BRIEF. This
macro is supposed to return the level of nesting of
sub-shells running BRIEF/CRISP. 
.Fo RETURN VALUE

Returns zero if this is a top level CRISP; otherwise returns 2, 3, 4, ...
to indicate level of nesting.

.HU inq_buffer
inq_buffer([filename])

.Fo DESCRIPTION

Every buffer has an identifier (an integer value) associated
with it. These identifiers are allocated when the buffer is
created. \fIinq_buffer()\fR can be used to get the identifier for
the current buffer, e.g. when saving the current buffer in a
macro, so that after the macro has finished the buffer
selected on entry to the macro can be re-instated.

If filename is specified then the buffer id of the buffer
which has the file loaded is returned instead.

.Fo EXAMPLES

The following example is typical of the code sequence used
in the CRISP macros on entry and exit to each macro.
.DS
.ft CW
	int	curbuf;
	
	curbuf = inq_buffer();
	 .
	 .
	set_buffer(curbuf);
.ft R
.DE
.Fo RETURN VALUE

Returns the buffer ID of the current buffer or the buffer
which has filename loaded into it. Returns zero if no buffer
has the filename loaded.

.HU inq_buffer_flags
inq_buffer_flags([bufnum])

.Fo DESCRIPTION

This macro returns the flags associated with the status of
the current buffer (if bufnum is omitted) or the buffer
whose identifier is bufnum.

The flags returned are a set of bits with the following bits
being defined:

0x01 Buffer has been modified. 0x02 Buffer will be backed up
when written. 0x04 Buffer is read-only. 0x08 Reserved. 0x10
File permissions in underlying file has the 'x' (execute
bit) set. 0x20 Buffer has a process associated with it. 0x40
Buffer contains a binary file. 0x80 Buffer in ANSI mode.
0x100 Buffer inserts real tabs. 0x200 Buffer is a system
buffer. 0x400 Make all characters in window visible. 0x800
Dont save undo info for buffer.

.Fo RETURN VALUE

Flags associated with designated buffer, or -1 if the
designated buffer does not exist.

.HU inq_called
inq_called()

.Fo DESCRIPTION

This macro exists so that macros can be written which need
to differentiate between being called directly from the
keyboard, or being called from another macro.

This is especially useful when writing a \fIreplacement\fR macro.
.Fo RETURN VALUE

A string containing the name of the macro which called the
current macro, or "" if the macro was called from the
keyboard.

.HU inq_char_map
inq_char_map([win_id])

.Fo DESCRIPTION

If win_id is specified, then that character map ID of the
underlying buffer is returned (if it has one), otherwise the
ID associated with the specified window. If win_id is not
specified the current window is used.

This function is used to get the character map as the user
perceives a buffer through a window.
.Fo SEE ALSO
create_char_map(), set_buffer_cmap(), set_window_cmap().
.Fo RETURN VALUE

Returns the character map ID used to display the current.

.HU inq_clock
inq_clock()

.Fo RETURN VALUE

Returns the amount of CPU time used by CRISP since the first
call to inq_clock(), measured in microseconds.

.HU inq_cmd_line
inq_cmd_line()

.Fo DESCRIPTION

This macro returns the partially typed in text which the
user is typing on the prompt line. It is used by various
macros to perform command completion.
.Fo RETURN VALUE

Returns the field currently being typed in by user on the
prompt line.

.HU inq_command
inq_command()

.Fo DESCRIPTION

This macro can be used to find the name of the last macro
which was invoked by virtue of it being bound to a keyboard
key.
.Fo RETURN VALUE

A string containing the name of the last macro called by the
user.

.HU inq_environment
inq_environment(name)

.Fo DESCRIPTION

THIS FUNCTION IS PROVIDED FOR COMPATABILITY VIA THE brief.cr MACRO
FILE.

This function looks up '\fIname\fR' in the environment and returns
the value of name. It is similar to the C function getenv().
.Fo RETURN VALUE

Returns a string which is the contents of the named
environment variable, or the null string if the variable
does not exist.
.Fo SEE ALSO
getenv()
.HU inq_idle_default
inq_idle_default()

.Fo DESCRIPTION

This function returns the interval for the idle keyboard
interval timer. The idle keyboard interval timer is a timer
which is started after the last keystroke. If no keys are
hit for \fIinq_idle_default()\fR seconds then the type 4
registered macros are called.

The default idle timer is set by the '-i' command line
switch. If it is not set on the command line explicitly,
then CRISP uses a default value of 60 seconds.
.Fo RETURN VALUE

Returns the value of the idle keyboard interval timer (in
seconds).

.HU inq_idle_time
inq_idle_time()

.Fo DESCRIPTION

This function returns the number of seconds since the last
key was pressed. This macro is used by the autosave macros
to see if it is time to save the editing buffers.
.Fo RETURN VALUE

Returns the number of seconds since the last key was pressed.

.HU inq_kbd_char
inq_kbd_char()

.Fo DESCRIPTION

This macro provides a simple way of determining whether a
character is available to be read from the keyboard without
actually reading it. (See \fIread_char()\fR).
.Fo RETURN VALUE

Returns non-zero if there is a character to be read from the
keyboard; 0 if no character is available.

.HU inq_keyboard
inq_keyboard()

.Fo DESCRIPTION

This macro may be used to find out what the current keyboard
identifier is so that it may be restored later.

See keyboard_push, keyboard_pop for further details on
keyboard identifiers.
.Fo RETURN VALUE

Returns the identifier associated with the current keyboard.

.HU inq_keystroke_macro
inq_keystroke_macro([km_id], [buf_id])

.Fo DESCRIPTION

This macro can be used to get the keycodes typed as a result
of a keyboard macro so that they can be saved and restored.

km_id is the keyboard macro id (as returned from a previous
remember() macro). If not specified the last keyboard macro
defined will be used.

buf_id is an optional integer variable which receives the
buffer ID of a system buffer associated with the keyboard
macro. This buffer contains the macros which were executed
during the remember process (as opposed to the raw
keystrokes). This buffer may be useful as the starting point
when writing your own customised macros. Consult the
remember.cr macro file to see how this buffer can be saved.

.Fo SEE ALSO
playback(), remember(), load_keystroke_macro()
.Fo RETURN VALUE

String containing characters (in int_to_key() format) of
characters making up a keyboard macro.

.HU inq_line_length
inq_line_length([bufnum])

.Fo DESCRIPTION

This command is used returns the length of the longest line
in the specified buffer (or the current buffer if bufnum is
omitted). The length corresponds to the column position the
cursor would be in if the cursor were to be placed at the
end of the longest line, i.e. it takes into account any
embedded tabs and control characters, etc.

If the designated buffer has a marked region, then only
those lines within the marked region are looked at to find
the longest line.


.Fo EXAMPLES

The following example returns the length of the longest line
in the current buffer in between the current line and the
end of the buffer.
.DS
.ft CW
	# include "crisp.h"
	
	 .
	 .
	int	length;
	
	drop_anchor(MK_LINE);
	save_position();
	length = inq_line_length();
	restore_position();
	raise_anchor();
	message("Longest line = %d cols", length);
.ft R
.DE
.Fo RETURN VALUE

\fIinq_line_length()\fR returns the length of the longest line, or
-1 if the specified buffer does not exist.

.HU inq_lines
inq_lines([bufnum])

.Fo DESCRIPTION

This macro returns the number of lines in specified buffer.
It is faster than going to the end of the buffer and doing
an \fIinq_position()\fR.

.Fo EXAMPLES

Following example prints number of lines in buffer:

.DS
.ft CW
	message("Lines = %d", inq_lines());
.ft R
.DE
.Fo RETURN VALUE

Number of lines in the specified buffer - or the current
buffer if bufnum is not specified. Returns -1 if buffer does
not exist.

.HU inq_local_keyboard
inq_local_keyboard()

.Fo DESCRIPTION

This function returns the identifier of the current local
keyboard; this may be needed for example if the keyboard is
to be changed or deleted.

Refer to \fIuse_local_keyboard()\fR and the help section "Local
Keyboards" for more information on what a local keyboard is.
.Fo RETURN VALUE

The keyboard identifier associated with the current local
keyboard, or 0 if there is no local keyboard.

.HU inq_macro
inq_macro(macro)

.Fo DESCRIPTION

This macro allows the calling macro to see if the named
macro is defined. macro is a string expression.

Passing the name of a CRISP builtin will return 0 unless the
built-in has been redefined by a replacement macro.
.Fo RETURN VALUE

Non-zero if macro is a macro; zero otherwise.

.HU inq_mark_size
inq_mark_size()

.Fo DESCRIPTION

This macro can be used to find out how many characters are
in the currently marked region. This number is the string
length of a string which would be necessary to hold the
characters.
.Fo RETURN VALUE

The number of characters in the currently marked region.

.HU inq_marked
inq_marked([start_line], [start_col], [end_line], [end_col])

.Fo DESCRIPTION

start_line, start_col, end_line, and end_col are optional
integer variables which receive the start and end positions
of the current region.
.Fo RETURN VALUE

Returns 0 if buffer does not have a region set; otherwise
returns current region type.

.HU inq_message
inq_message()

.Fo DESCRIPTION

This macro returns any message or prompt which is currently
displayed on the status line. It is used by the various
command completion and abbreviation macros to see what
command is currently executing.

See also \fIinq_cmd_line()\fR.
.Fo RETURN VALUE

Returns the message currently on the status line plus any
type in from the user.

.HU inq_mode
inq_mode()

.Fo DESCRIPTION

This macro returns the current state of the insert/overtype
modes.
.Fo RETURN VALUE

Returns 1 if in insert mode; 0 if in overtype mode.

.HU inq_modified
inq_modified([bufnum])

.Fo DESCRIPTION

This macro returns a value indicating whether the current
buffer (bufnum omitted) or the buffer specified by bufnum
has been modified.

This macro exists as a shorthand form of the
\fIinq_buffer_flags()\fR macro. It exists for compatability with
BRIEF.

.Fo EXAMPLES

The following example prints a message saying whether the
buffer has been modified or not.
.DS
.ft CW
	message("Buffer has %sbeen modified.",
		inq_modified() ? "" : "not ");
.ft R
.DE
.Fo RETURN VALUE

Returns non-zero if current buffer has been modified; 0 if
buffer has not been modified (or has been written away).

.HU inq_msg_level
inq_msg_level()

.Fo DESCRIPTION

The message level flag is used to specify what level of
error and informational messages are to be printed. This
allows things like replacement macros to operate in a silent
manner.

To see the meanings of the different levels, refer to
set_msg_level.
.Fo RETURN VALUE

The current value of the message level flag (0-3).

.HU inq_names
inq_names([full_name], [ext], [buf_name], [buf_id])

.Fo DESCRIPTION

This macro is used for determining the names of the file and
buffer associated with the current buffer. If buf_id is
specified, then that buffer is used to fetch the information
rather than using the current buffer. Any of the parameters
may be omitted. All the parameters are the names of string
variables.

full_name is the full path name of the file associated with
the buffer, and is the file which is written to when
\fIwrite_buffer()\fR is called; ext receives the extension (if
any) of full_name; buf_name is the title of the buffer - as
displayed at the top of the window when the buffer is
attached (see attach_buffer) to a window.

.Fo EXAMPLES

The following macro executes a file-dependent macro for
setting up initialisations, etc.
.DS
.ft CW
	string	ext;
	
	inq_names(NULL, ext);
	execute_macro(ext + "_init");
.ft R
.DE
.Fo RETURN VALUE

Nothing.

.HU inq_position
inq_position([line], [col])

.Fo DESCRIPTION

This macro is used to find where the cursor is within the
current buffer. line and col are the names of string
variables which receive the current line and column number
(both start at 1).

This function returns an indication of whether the cursor is
past the end of the buffer. In BRIEF, the cursor is allowed
to wander beyond the last line of physical text in the
buffer, upto one full screens worth (usually 24 or 42
lines). CRISP doesnt support this capability at present,
although the cursor can be moved to one line beyond the last
line of input. Be wary of this when porting macros from
BRIEF to CRISP.
.Fo RETURN VALUE

Returns 0 if cursor is not past end of buffer; otherwise it
returns the number of lines past the end of the buffer.

.HU inq_process_position
inq_process_position([line], [col])

.Fo DESCRIPTION

This function is similar to \fIinq_position()\fR but it returns
the current cursor position for the underlying process. line
& col are optional integer variables to receive the line &
column, respectively.

The process position is used for output from the process;
rather than inserting the output from the process where the
users cursor is, a separate cursor is maintained instead.
This is done because it allows the user to move around the
buffer whilst the process is generating output without the
process output being sprinkled through the buffer.

For more details of operation, look at the shell.m macro file.
.Fo RETURN VALUE

Returns -1 if current buffer is not attached to a process;
returns 0 otherwise.

.HU inq_scrap
inq_scrap([last_newline], [type])

.Fo DESCRIPTION

This macro returns various internal info about the scrap
buffer.

last_newline is an optional integer variable which is used
to indicate whether the scrap has a newline at the end of
the last line of the buffer (used when inserting text via
\fIpaste()\fR). This is currently not implemented.

type is an integer variable which receives the type of the
marked area which was most recently copied to the scrap.
.Fo RETURN VALUE

Returns the buffer identifier associated with the scrap.
.HU inq_screen_size
inq_screen_size([lines], [cols])

.Fo DESCRIPTION

lines and cols are optional integer variables. If specified
they receive the current dimensions of the physical screen.
.Fo RETURN VALUE

Returns zero if terminal is configured as a monochrome
screen, or non-zero if in color mode.

.HU inq_system
inq_system()

.Fo DESCRIPTION

This macro can be used by other macros which need to look at
arbritrary buffers, e.g. \fIbuffer_list()\fR.
.Fo RETURN VALUE

Returns non-zero if the current buffer is a system buffer;
returns 0 if the current buffer is a normal buffer.

.HU inq_top_left
inq_top_left([topline], [topcol], [win_id], [csrline], [csrcol], [buf_id])

.Fo DESCRIPTION

This macro returns information about the window win_id, or
the current window if win_id is not specified.

topline is the name of an integer variable receiving the
line number of the top line in the window. topcol receives
the column position of the left hand side of the screen.

csrline receives the current cursor line within the window
and csrcol receives the column position of the cursor.

buf_id receives the buffer ID of the buffer attached to the
window.

.Fo RETURN VALUE

Nothing.

.HU inq_views
inq_views([buf])

.Fo DESCRIPTION

This macro can be used to determine if it is safe to delete
a buffer (via \fIdelete_buffer()\fR).
.Fo RETURN VALUE

Returns the number of windows which have the specified
buffer on display. Returns 0 if buffer is not on display.

.HU inq_window
inq_window()

.Fo DESCRIPTION

This macro returns the id of the current window. This is
useful for macros which wish to move the cursor to another
window but when they have completed wish to restore the
cursor to the original window.
.Fo RETURN VALUE

An integer representing the identifier of the current window
or -1 if there is no current window.

.HU inq_window_buf
inq_window_buf([win])

.Fo DESCRIPTION

This macro can be used to find the buffer ID associated with
a window. Given the buffer ID, the actual file name of the
buffer can then be found.
.Fo RETURN VALUE

Returns the buffer ID associated with the current window or
the window indicated by the win argument.

.HU inq_window_color
inq_window_color([win_id])

.Fo DESCRIPTION

This macro returns the background color of a window. If win_id
is not specified then the background color of the current window is
returned.

If the window color is set to < 0, then the default background color will
be used. If the color is set to >= 0 then the specified color will
be used.
.Fo RETURN VALUE

The color associated with the background of the specified
window.
.Fo SEE ALSO
window_color()
.HU inq_window_info
inq_window_info([win_id], [buf_id], [lx], [by], [rx], [ty])

.Fo DESCRIPTION

This macro returns the information about the current window.
All the parameters are optional names of integer variables
to receive the information.

win_id receives the window id of the window.
.Fo RETURN VALUE

Returns zero if window is tiled, or non-zero if window is a
popup.

.HU inq_window_size
inq_window_size([lines], [cols], [right])

.Fo DESCRIPTION

This macro is used to determine the dimensions of the
current window. lines, cols & right are optional integer
variables. lines and cols receive the number of lines and
columns in the current window.

right receives the amount the current buffer is shifted
within the window for sideways scrolling. If the current
buffer hasn't been sideways scrolled, then right will
receive 0.
.Fo RETURN VALUE

Nothing.

.HU insert
insert(expr, [num])

.Fo DESCRIPTION

\fIinsert()\fR is another means for inserting text into a buffer.
(The others are \fIself_insert()\fR and \fIpaste()\fR). expr is a string
expression which is to be inserted into the current buffer,
as if typed by the user. Backslash-n characters are treated
as new-lines.

If num is specified, then the string, expr, is inserted num
times. If omitted, it defaults to 1.

If expr evaluates to an integer then the character whose
ascii value is 'expr' is inserted into the buffer. This is a
special feature in that inserting 0x0a inserts a <Line-feed>
character (^J) into the buffer without ending the current
line. This feature is used by the quote() macro.
.Fo RETURN VALUE

Nothing.

.HU insert_mode
insert_mode([mode])

.Fo DESCRIPTION

This macro allows the user to set and/or get the current
value of the insert mode. The insert mode is applied when
the user types in text. By default CRISP comes in insert
mode, i.e. characters typed in cause characters to the right
of the cursor to be shifted over. Overtype mode causes the
character under the cursor to be deleted and replaced by the
inserted characters.

ins_mode is zero if overtype mode should be turned on, and
non-zero if insert mode should be turned on.

If ins_mode is omitted, then the current value is toggled.

Note that the insert/overtype mode only affects
\fIself_insert()\fR not \fIinsert()\fR or \fIpaste()\fR, etc.

If the display terminal is not able to change cursor shape,
then the echo status line will display the current status of
the insert/overtype mode. (Note that it has to compete with
other values on the display line so it may disappear, for
example, if percentage through file is turned on. (See
\fIecho_line()\fR).

.Fo EXAMPLES

The following example prints the state of the
insert/overtype mode without changing the mode.
.DS
.ft CW
	int	mode;
	
	mode = insert_mode();
	
	/* Toggle mode back to original value. */
	insert_mode();
	
	message(mode ? "Insert mode" : "Overtype mode");
.ft R
.DE
.Fo RETURN VALUE

Returns non-zero if the previous value was insert mode;
returns zero if the previous value was overtype mode.

.HU insert_process
insert_process(expr, [num])

.Fo DESCRIPTION

\fIinsert_process()\fR is similar to \fIinsert()\fR except the inserted
text is sent to an attached process instead of being
inserted into the text buffer. No auto echo is performed -
it is the calling macros responsibility to echo any input
sent to the process.

If num is specified, then the string, expr, is inserted num
times. If omitted, it defaults to 1.
.Fo RETURN VALUE

Nothing.

.HU int
int var1, var2, ..;

.Fo DESCRIPTION

This macro is used to define local variables which are to
contain only integer values. The variables defined are local
variables, and are destroyed when the macro executing this
declaration terminates.

Integers are two's complement integers, 32-bits in length on
all machines.
.HU int_to_key
int_to_key(key)

.Fo DESCRIPTION

This function takes an integer argument, which is a
key-code, e.g. as returned by \fIread_char()\fR. The integer
key-code is converted to a string in the canonical form
understood by assign_to_key. This allows macros to be
written portably, rather than returning the raw key-code.

\fIint_to_key()\fR and \fIkey_to_int()\fR are inverses of each other.
.Fo RETURN VALUE

Returns a string in the format of \fIassign_to_key()\fR.

.HU is_integer
is_integer(var)

.Fo DESCRIPTION

This macro can be used to test the data type of a
polymorphic variable, for example when walking down a list.
.Fo RETURN VALUE

Returns 1 if var is an integer variable; zero otherwise.

.HU is_list
is_list(expr)

.Fo DESCRIPTION

This macro can be used to test the data type of a
polymorphic variable.
.Fo RETURN VALUE

Returns 1 if var is an list variable; zero otherwise.

.HU is_null
is_null(expr)

.Fo DESCRIPTION

This macro can be used to test if a particular element of a
list actually exists (i.e. to avoid walking off of the end of
a list).
.Fo RETURN VALUE

Returns 1 if var is contains a null value; zero otherwise.

.HU is_string
is_string(expr)

.Fo DESCRIPTION

This macro can be used to test the data type of a
polymorphic variable.

.Fo RETURN VALUE

Returns 1 if var is a string variable; zero otherwise.

.HU key_list
key_list([kbd_id], [self_insert], [buf_id])

.Fo DESCRIPTION

This macro is used to get a list of all key-bindings in a
keyboard map. The macro returns a list of strings where the
even elements in the string are the key names, and the odd
elements are the macro names associated with those keys.

Upto two keyboard maps can be specified. If buf_id is
specified, then the local keyboard assigned to that buffer
is used. If not specified then the local keyboard map of the
current buffer is used.

If kbd_id is specified then that keyboard is used as well;
otherwise the current global keyboard is used.

If self_insert is specified and is non-zero, then the keys
for the self-inserting keys are returned as well. The
default is to omit them.

When scanning a local and a global keyboard, and an entry is
defined for a keycode in the local and global map, then only
the local keyboard enrty is returned.

This macro is defined so that the help macro can display a
list of all valid keys currently mapped in both the current
local and global keyboard maps.
.Fo RETURN VALUE

Returns a list containing pairs of strings where the first
string in each pair is the key name, and the second string
is the macro assigned to that key.

.HU key_to_int
key_to_int(key, [raw])

.Fo DESCRIPTION

This function is the inverse of int_to_key. \fIkey\fR is a string
to be converted to an internal keycode number. If \fIraw\fR is not
specified or is zero, then the internal keycode associated with the
key sequence is returned. In this case, key should be a valid key-sequence
which can be passed to \fIassign_to_key()\fR.

If \fIraw\fR is specified and is non-zero, then \fIkey\fR is a raw
key stroke, as entered by a function key on the keyboard. In this case, the
keycode assigned to that key is returned.
.Fo EXAMPLES
The following example returns the keycode for the F1 function key.
.DS
.ft CW
	key_to_int("<F1>");
.ft R
.DE

The following example returns the keycode for the key whose raw
key sequence is that specified. If this keycode corresponds to the <F1>
key, then the internal keycode for the <F1> key will be returned:
.DS
.ft CW
	key_to_int("\\x1B[224z");
.ft R
.DE
.Fo RETURN VALUE
Returns an integer representing the internal key code
assigned to the specified key sequence, or -1 if the sequence does not
correspond to an valid key definition.
.Fo SEE ALSO
assign_to_key(), int_to_key()
.HU keyboard_flush
keyboard_flush()

.Fo DESCRIPTION

keyboard_flush can be used to flush any pending input.
.Fo RETURN VALUE

Nothing.

.HU keyboard_pop
keyboard_pop([save])

.Fo DESCRIPTION

This macro is used to pop the current keyboard off the
keyboard stack; save is an integer expression. If it is
non-zero, then the current keyboard is saved for later use
(by keyboard_push). If it is zero, then the keyboard map is
discarded.

.Fo EXAMPLES

See \fIkeyboard_push()\fR for an example of creating a temporary
keyboard map.
.Fo RETURN VALUE

Nothing.

.HU keyboard_push
keyboard_push([kbd_id])

.Fo DESCRIPTION

keyboard_push is used to create a new keyboard table. The
current keyboard map is saved on a stack, and can be
retrieved by using keyboard_pop.

kbd_id is an integer expression. If it is omitted, then a
new keyboard map is pushed on the stack, and by default all
the keys in the map are assigned to \fInothing()\fR, i.e. pressing
them has no effect. If kbd_id is specified, it should be a
value which was obtained from a previous \fIinq_keyboard()\fR
call. This will push the keyboard whose identifier is kbd_id
on top of the stack.

A keyboard map is a table of all possible keys, together
with the macros that are bound to them. By default CRISP
comes up with the usual editing keys, but some macros need
to temporarily bind macros to keys for their operation. For
example, the buffer_list macro creates a new keyboard and
binds various keys to it, so that it can intercept the users
requests to delete and write away buffers.

Having keyboard maps saves the macro writer from having to
write complicated, and CPU expensive keyboard parsers.

.Fo EXAMPLES

The following example shows how to create a temporary
keyboard mapping for use within a macro.
.DS
.ft CW
	int	curkbd;
	
	curkbd = inq_keyboard();
	
	keyboard_push();
	assign_to_key("<Alt-H>", "help");
	 ..
	 ..
	process();
	keyboard_pop();
	
	keyboard_push(curkbd);
.ft R
.DE
.Fo RETURN VALUE
Nothing.

.HU keyboard_typeables
keyboard_typeables()

.Fo DESCRIPTION

keyboard_typeables is a quick method of setting up a
keyboard map so that the usual insertable characters (ASCII
0-127) do their default actions of being insertable.

It is a shorthand way of doing the following:
.DS
.ft CW
	assign_to_key("A", "self_insert");
	assign_to_key("B", "self_insert");
	 .
	 .
.ft R
.DE
It is useful after creating a new blank keyboard.
.Fo RETURN VALUE
Nothing.
.HU ldexp
ldexp(x)

.Fo RETURN VALUE

Returns x*2^n as a floating point value.
.HU left
left(num)

.Fo DESCRIPTION

Moves the cursor one character to the left or num characters
to the left, if specified. num may be negative.

Unlike BRIEF, if the cursor is moved past the beginning of
the current line, then the cursor wraps around to the end of
the previous line.
.Fo RETURN VALUE

Nothing.

.HU length_of_list
length_of_list(list_expr)

.Fo RETURN VALUE

The number of atoms in the list.

.Fo DESCRIPTION

\fIlength_of_list()\fR returns the number of atoms in a list; it
only counts the top level atoms. For example, if (car
list_expr) is a list expression itself, then this only
counts as one atom, not (length_of_list (car list_expr)).
.HU list
list var1, var2, ..;

.Fo DESCRIPTION

This macro is used to define list variables. List variables
may be defined as global (see \fIglobal()\fR). List variables are
given an initial value of the NULL list (i.e. \fIlength_of_list()\fR
returns 0).

Lists are data types similar to arrays, except each element
of a list (referred to as an atom) may have any of the CRISP
primitive data types (including list), and lists can be
expanded at the end simply by concatenating entries on the
end (see \fIappend_list()\fR and \fIput_nth()\fR).
.HU load_keystroke_macro
load_keystroke_macro(str)

.Fo DESCRIPTION

This macro provides a way of creating a keyboard macro
without using the keyboard. This macro is designed to allow
user macros to load macros from external files.

str is a string in a similar format returned by
inq_keystroke_macro() which is parsed and stored as a
keystroke macro.
.Fo SEE ALSO
playback(), remember(), inq_keystroke_macro()
.Fo RETURN VALUE

Keystroke macro ID associated with the keystroke macro.

.HU load_macro
load_macro([file])

.Fo DESCRIPTION

This macro is used to load a .m or .cm macro file into
CRISP. file is a string expression which specifies the name
of the macro file. If omitted, it is prompted for.

Note that unlike BRIEF, macros in source form (.m files) can
be loaded with this macro.

The extension can be omitted, in which case CRISP looks for
either file.m or file.cm If the extension is supplied, then
only a file matching the extension will be searched for.
Otherwise CRISP looks for a .cm file before looking for a .m
file.

If file does not contain a path specification, then CRISP
searches all the directories in the BPATH environment
variable (or uses an internal default if BPATH is not
specified).

When searching for a .m or .cm it searches the directories
in order, i.e. if a .cm file exists in a later path than the .m
then the .m file will be loaded first.

When loading .cm files, CRISP checks the version number of
the file to see if it is compatible with the current version
of CRISP, and issues an error message if the version number
does not agree.

If a .m file has a syntax error then the loading of the file
is aborted with an error message displayed.

If a macro called '_init' exists in the macro file being
loaded, then that macro is executed immediately. This
facility exists to allow macros to perform initialisation
functions.
.Fo RETURN VALUE

Returns 1 if macro file was successfully loaded; 0 otherwise.

.HU log
log(x)

.Fo RETURN VALUE

Returns the natural logarithm of x, ln(x). x is a floating
point value which must be > 0.
.Fo SEE ALSO
log, exp
.HU log10
log10(x)

.Fo RETURN VALUE

Returns the base-10 logarithm of x, x is a floating point
value which must be > 0.
.Fo SEE ALSO
log10, exp
.HU lower
lower(string)

.Fo SEE ALSO
upper
.Fo RETURN VALUE

Returns a copy of string with all upper case letters mapped
to their lower case equivalents.
.HU ltrim
ltrim(string)

.Fo DESCRIPTION

This function is used to remove leading characters from the
specified string. The default is to remove all tabs, spaces
and newline characters. If delim is specified, then all
characters in the delim string are removed from the
beginning of string.

.Fo SEE ALSO
trim, compress
.Fo RETURN VALUE

Returns a copy of string with all leading white space
characters removed. (spaces, tabs and newlines).

.HU macro
(macro name list)

.Fo RETURN VALUE

Result of last statement executed in the macro.

.Fo DESCRIPTION

(macro) defines a new macro. It is normally only processed
when loading a .m or .cm file. The macro is given the name 'name' 
and consists of the executable statements in the
list, list.

If a macro is given the special name _init, then it is
automatically executed when the macro file is loaded.

THIS IS A LOW LEVEL PRIMITIVE NOT AVAILABLE IN THE CRUNCH LANGUAGE.
THE CRUNCH COMPILER AUTOMATICALLY PRODUCES MACRO DEFINITIONS FOR EACH
DEFINED CRUNCH FUNCTION.
.HU macro_list
macro_list()

.Fo DESCRIPTION

This macro is similar to \fIcommand_list()\fR but simply returns a
list of all the currently defined macros.
.Fo RETURN VALUE

A list of strings containing the names of all currently
defined macros (not CRISP keywords), in alphabetic order.

.HU make_list
make_list(expr1, expr2, ..)

.Fo DESCRIPTION

This macro is used to create a new list constructed from the
argument list. Each argument is evaluated and appended to
the next list. Contrast this with quote_list() which does
not evaluate the arguments.

.Fo EXAMPLE
.DS
.ft CW
	int i = 4, j = 5; 
	list l = make_list(i, j);

	/* l = {4 5} */
.ft R
.DE
.Fo SEE ALSO
quote_list()
.Fo RETURN VALUE

List constructed from arguments.

.HU make_local_variable
make_local_variable(var1, var2, ..)

.Fo DESCRIPTION

This macro is used to make existing local variables into
\fIbuffer\fR local variables. CRISP supports the concepts of
three storage classes for variables - local, which go out of
scope when the current macro terminates; global, which never
go out of scope; and buffer-local, which go out of scope
when the current buffer is changed.

Buffer-local variables are useful for saving state
information on a per buffer basis.

When searching for a variable, CRISP searches the symbol
tables in the following order:

1. Local variables. 2. Global variables. 3. Buffer variables.

Therefore be careful when overloading symbol names. CRISP
allows local variables, global variables and buffer
variables to all be in scope at once, in which case the
variable at the highest level in the above list is only
accessible.
.Fo RETURN VALUE

Nothing.

.HU mark
mark([type])

.Fo DESCRIPTION

\fImark()\fR is similar to \fIraise_anchor()\fR/\fIdrop_anchor()\fR. If a
marked region is currently displayed, then \fImark()\fR raises the
anchor; if no anchor is displayed, then \fImark()\fR drops an
anchor.

type is an optional integer variable which is used to define
the mark type if one is to be dropped. If it is omitted, it
defaults to a normal marked region.

See \fIdrop_anchor()\fR for a description of the marked region
types.
.Fo RETURN VALUE

Nothing.

.HU message
message(fmt, [arg1], [arg2], ..)

.Fo DESCRIPTION

This macro is used to display a message on the status
\fIprompt()\fR line at the bottom of the screen. fmt is a string
and may contain printf-like % formatting characters. arg1,
arg2, .. are integer or string expressions used to satisfy
the % formatting options. Upto 6 arguments are allowed.

This macro can be used to display informational messages on
the bottom of the screen; if error messages are to be
displayed then the \fIerror()\fR macro should be used instead.

The following format identifiers are supported:
.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Format	Description
=
.TH
%d	T{
Print an integer expression. Options such as %03d can be
used to perform zero insertion and supply a field width.
T}
%x	T{
Print integer expression in hex.
T}
%o	T{
Print integer expression in octal.
T}
%s	T{
Print a string. Field width and alignments are allowed.
T}
%c	T{
Print a character.
T}
%p	T{
If its less than a second since the last call to message
(or printf or error), then don't display the message. This
is used by macros which want to print progress messages.
T}
.TE
The following prefixes are supported:
.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Prefix	Description
=
.TH
%l...	T{
User long format for printing, e.g. floats are printed
with full double-precision.
T}
%-..	T{
Value is printed left justified.
T}
.TE
.Fo EXAMPLES
.DS
.ft CW
	message("The %s %s %s %s %s.",
	        "cat", "sat", "on", "the", "mat");
	message("%pMacro completed: %d%%", (val * 100) / total);
.ft R
.DE
.Fo RETURN VALUE

Nothing.
.HU mkdir
mkdir(path, [mode])
.Fo Description
This function creates a new diretory. The path specified should be a string
variable and is passed directly to the \fImkdir(2)\fR operating system
call.

mode is the protection codes used to create the directory. If omitted,
the value 0755 (rwxr-xr-x) will be used.
.Fo RETURN VALUE
On success, zero is returned. Otherwise -1 is returned and the global
variable \fIerrno\fR is set to the reason why the call failed.
(Refer to the system manual page for the error codes).
.HU modf
modf(x, ip)

.Fo RETURN VALUE

Returns integer part of x as a floating point number, and
stores the fractional part of x in the floating point
variable ip. Both the return value and the value stored in
ip have the same sign as x.
.HU move_abs
move_abs([line], [col])

.Fo DESCRIPTION

This macro moves the cursor to the specified line and column
position. If either line or col are unspecified or zero,
then the line or column position is left unchanged.
.Fo RETURN VALUE

Returns non-zero if cursor moved; 0 if cursor didn't move.

.HU move_edge
move_edge([direction], [amount])

.Fo DESCRIPTION

This macro is used to expand or contract a window. direction
specifies the edge which is to be moved. The expansion is
performed interactively. This macro is designed to support
tiled windows.

If direction is specified, it should have one of the
following values:
.DS
	0 Up 
	1 Right 
	2 Down 
	3 Left
.DE
.P
Amount is an optional integer expression. If not specified,
the user will be prompted to move the edge with the arrow
keys. If it is specified it specifies the number or
characters or lines to move the window. The number is
relative to the top left of the screen, so positive numbers
move further away and negative numbers move nearer.
.Fo RETURN VALUE

Returns <= 0 if unsuccessful; > 0 otherwise.

.HU move_rel
move_rel([line], [col])

.Fo DESCRIPTION

This macro moves the current line or column plus or minus
the number of lines specified, i.e. the move is relative to
the current cursor position.

.Fo RETURN VALUE

Returns non-zero if cursor moved; 0 if cursor didn't move.

.HU next_buffer
next_buffer([system], [prev])

.Fo DESCRIPTION

\fInext_buffer()\fR is the mechanism for enumerating all buffers.
It returns the buffer id of the next buffer in the list.

system is an optional integer which if present and non-zero
allows the calling macro to walk through each system buffer
as well (see create_buffer). If it is omitted, then system
buffers are stepped over. This facility is used by the
\fIbuffer_list()\fR macro if the systems option is turned on.

If prev is specified and non-zero, then the previous buffer
can be found.

.Fo EXAMPLES

The following example shows how to walk down each buffer,
including system buffers:
.DS
.ft CW
	int	curbuf, buf;
	
	curbuf = inq_buffer();
	buf = curbuf + 1;
	while (curbuf != buf) {
		...
		buf = next_buffer(1);
		}
.ft R
.DE
.Fo RETURN VALUE

Returns the buffer id of the next buffer in the buffer list.

.HU next_char
next_char([num])

.Fo DESCRIPTION

This function is similar to \fIright()\fR except it moves the
cursor over physical characters, e.g. tabs are treated as
single characters, rather than virtual spaces.

If num is specified then that number of character positions
are skipped over.

If the cursor is moved past the end of the line, then the
cursor wraps around to the start of the next line.

When skipping characters for text files, the implicit
newline at the end of each line is included in the count.
When skipping over characters in binary files, the end of
line is not treated as a character. Thus to go to an
absolute offset in a binary file, it is merely necessary to
go to the top of the buffer and perform a next_char()
function the appropriate number of times.
.Fo RETURN VALUE

Returns non-zero if the cursor changed position; zero if it
didn't.

.HU next_window
next_window([win_id])

.Fo DESCRIPTION

This macro is used to move to the 'next' window. The
definition of next is related to the order the windows
appear in the screen. Windows internally are sorted in
top-left to bottom-right order. This primitive changes
window and sets the current buffer up appropriately.

If win_id is specified then the next window from the
specified window is returned.
.Fo RETURN VALUE

New window ID or -1 if window cannot be found.

.HU nothing
nothing()

.Fo DESCRIPTION

This macro is a no-op. It exists simply as a place holder
for the language and is valid anywhere any other macro is
valid.
.Fo RETURN VALUE

Nothing.

.HU nth
nth(expr, list_expr)

.Fo DESCRIPTION

This macro allows the caller to extract individual atoms
from a list. The first element of a list is element 0; the
\fInth()\fR macro allows lists to be treated like arrays. The last
element of a list is \fIlength_of_list()\fR-1.

nth is a more efficient way of accessing random elements in
a list, than for example, using \fIcar()\fR and \fIcdr()\fR, since the
list expression doesn't need to be copied so much.

This primitive is not normally accessed from the CRUNCH language. When the
user uses array subscripts to access a list, CRUNCH converts the
subscripts into calls to this macro.
.Fo RETURN VALUE

Returns the n'th atom in list_expr, where n is the value of
the integer expression expr.

.HU output_file
output_file([filename])

.Fo DESCRIPTION

This macro is used to change the filename associated with
the current buffer. By default the filename associated with
the current buffer is the filename specified on an
\fIedit_file()\fR or \fIcreate_buffer()\fR call. \fIoutput_file()\fR allows
this to be changed to the value of the string expression,
filename.

If filename is omitted, then the user is prompted for the
new file name.

.Fo RETURN VALUE

Returns <= 0 on an error, or > 0 on success.

.HU page_down
page_down()

.Fo DESCRIPTION

Moves the cursor one window-full towards the end of the
buffer.
.Fo RETURN VALUE

Nothing.

.HU page_up
page_up()

.Fo DESCRIPTION

Moves the cursor one window-full towards the beginning of
the buffer.
.Fo RETURN VALUE

Nothing.

.HU paste
paste()

.Fo DESCRIPTION

This macro copies the contents of the scrap buffer and
inserts it into the current buffer where the cursor is
located. The cursor is moved to the end of the pasted region.

When using CRISP on a windowing system (e.g. X11), this key should be
bound to the <Ins> key. When a mouse paste operation is performed, CRISP
checks to see if this macro is bound to the <Ins> key and if not
will not paste the selection. This is done to avoid allowing the
user to paste data with the mouse into a popup window.
.Fo RETURN VALUE

Returns 1 on success; 0 on failure.
.Fo SEE ALSO
cut(), copy(), inq_scrap(), set_scrap_info().
.HU pause
pause()

.Fo DESCRIPTION

\fIpause()\fR is used to pause a keyboard macro definition.
Usually all keyboard input typed during a \fIremember()\fR
sequence is saved in the keyboard macro buffer. Pressing a
key assigned to \fIpause()\fR causes the \fIremember()\fR sequence to
suspend saving the characters.
.Fo RETURN VALUE

Nothing.

.HU pause_on_error
pause_on_error([pause])

.Fo DESCRIPTION

This macro is used to set or toggle the pause on error flag.
This flag is tested after every \fIerror()\fR message is
displayed. If this flag is on then the error message is
displayed with a '..' suffix added to the end of the error
message and CRISP waits for the user to type any key on the
keyboard to continue. This allows the user to see error
messages before they get overwritten by other messages.

By default this is off. If \fIpause_on_error()\fR is called with
no argument, then the current state is toggled and CRISP
prints the message 'Pausing errors on.' or 'Pausing errors
off.' If pause is specified then the current setting is set
to the value of the integer expression pause.

.Fo EXAMPLES

The following example shows how \fIpause_on_error()\fR can be used
around a call to a macro so that the user can see the errors
being displayed by the macro without resorting to
sight-reading.
.DS
.ft CW
	pause_on_error();
	fred();
	pause_on_error();
.ft R
.DE
.Fo RETURN VALUE

Non-zero if previous setting was paused messages on; 0 is
previous setting was no pausing of error messages.

.HU playback
playback([macro])

.Fo DESCRIPTION

\fIplayback()\fR causes the saved keyboard macro to be replayed.
If macro is not specified, then the last macro defined is
played back.

\fIplayback()\fR is not usually called from within a macro, but
instead is usually bound to the <F8> key.
.Fo RETURN VALUE

Returns greater than or equal to zero if playback was
successful. Less than zero otherwise.

.HU post++
(post++ var)

.Fo DESCRIPTION

This macro is used to access a variable and perform an auto
increment on the variable AFTER its value has been used
(c.f. (++)).

THIS PRIMITIVE IS NOT DIRECTLY ACCESSIBLE FROM THE CRUNCH LANGUAGE
AND IS USED WHEN COMPILING THE POSTFIX INCREMENT OPERATOR (x++).
.Fo RETURN VALUE

Returns the value of the variable var.

.HU post--
(post-- var)

.Fo DESCRIPTION

This macro is used to access a variable and perform an auto
decrement on the variable AFTER its value has been used
(c.f. (--)).

THIS PRIMITIVE IS NOT DIRECTLY ACCESSIBLE FROM THE CRUNCH LANGUAGE
AND IS USED WHEN COMPILING THE POSTFIX DECREMENT OPERATOR (x--).
.Fo RETURN VALUE
Returns the value of the variable var.

.HU pow
pow(x, y)

.Fo RETURN VALUE

Returns x to the power of y (x^y). x, y and the return value
are floating point values.
.HU prev_char
prev_char([num])

.Fo DESCRIPTION

Moves the cursor backwards by num characters. The movement
is by physical characters, and treats tabs, etc as single
characters.

If the cursor is moved beyond the beginning of the current
line then the cursor wraps around to the end of the previous
line.

When skipping characters for text files, the implicit
newline at the end of each line is included in the count.
When skipping over characters in binary files, the end of
line is not treated as a character. Thus to go to an
absolute offset in a binary file, it is merely necessary to
go to the top of the buffer and perform a next_char()
function the appropriate number of times.
.Fo RETURN VALUE

Nothing

.HU print
print()

.Fo DESCRIPTION

This macro is used to send the currently marked region to
the printer. The internal primitive is defined to do nothing. At the user
interface level, the print macro is assigned to a macro which will send
the currently hilighted region to the printer or the entire buffer if
no region is hilighted.

Because there is no standard printer mechanism under Unix, the user is prompted
for the command to use to print the region. Please consult the user
guide for more information (the section on .crinit configuration).

.Fo RETURN VALUE

Nothing.

.HU printf
printf(fmt, [arg1], [arg2] ..)

.Fo DESCRIPTION

This macro can be used for debugging macros, although its
use is questionable. It exists for compatability reasons
with BRIEF. It causes the formatted string to be sent
directly to stdout, bypassing all of CRISPs internal screen
manipulations.

Its use is questionable since it is presumably provided for
use with BRIEF and MS-DOS for debugging BRIEF itself and
BRIEF macros. Under MS-DOS, BRIEF writes directly to the
video memory and it may be useful to have a separate error
logging channel which can be redirected to a file.

Under Unix, stdout is used for all display purposes, so the
printf output stream would be intermingled with the display
stream.

If you need to track the progress of a macro, use \fIdebug()\fR
since it gives you a much finer granularity of output.
.Fo RETURN VALUE

Nothing.

.HU process
process()

.Fo DESCRIPTION

The \fIprocess()\fR macro is the mechanism for causing CRISP to
nest keyboard invocations. CRISP maintains a process level
counter which is normally set to 1. When in the process
mode, CRISP accepts keystrokes and executes the macros bound
to those keystrokes.

A call to \fIprocess()\fR is usually made after creating buffers
and windows for display on screen, and having set up a
temporary keyboard map. Return from a call to \fIprocess()\fR only
occurs as a result of a macro calling the \fIexit()\fR macro.

The current process level is terminated via a call to
\fIexit()\fR. When the process level goes to zero, CRISP exits
(possibly after prompting the user to save buffers).

Process nesting may occur to any depth, within the bounds of
CRISPs maximum nesting level.

The term 'process' is a misnomer and in this context should
not be confused with process buffers, which are a completely
different concept.
.Fo RETURN VALUE

Nothing.

.HU process_mouse
process_mouse(but1, but2, but3, x, y)

.Fo DESCRIPTION

This macro exists to allow user macros to interface to CRISP
so that internal mouse processing can be performed in a
generic manner for different types of mice. Some mice
require internal support whereas others can be totally
handled by user level macros, but at an execution time cost.

This macro gets called with the current state of the mouse
buttons, zero means the button is up, and non-zero means the
button is down.

The x and y parameters specify the co-ordinates of the mouse
on the screen, with (0,0) being the top left of the screen.

When the macro is called, the states of the buttons are
compared with the last recorded state and the REG_MOUSE
registered macro is called with information about what type
of object the mouse was clicked on.

Refer to the mouse.cr macro for details.
.Fo RETURN VALUE

Nothing.
.Fo SEE ALSO
translate_pos
.HU profile
profile([expr])

.Fo DESCRIPTION

\fIprofile()\fR exists solely to help profile CRISPs own execution
so that it may be optimised. By default a mon.out file is
created whenever a program exits which was compiled with the
\fIcc -p\fR flag. When CRISP exits, it usually avoids calling
exit() so that the mon.out file does not get written. This
allows CRISP to be compiled with the -p flag and installed
without causing every user to inadvertently create mon.out
files all over the file system.

In order to get a mon.out file on exit from CRISP, either
run CRISP with the -p flag, or call this macro.

If expr is omitted, the profile option is toggled. If expr
is non-zero then a mon.out file will be created; if it is
zero, then mon.out will not be created.

Note that this option only works if CRISP was compiled with
the profiling code included.
.Fo RETURN VALUE

Nothing.
.HU _prompt_begin
_prompt_begin(string)
.Fo DESCRIPTION
This macro is a callback macro called whenever the user is about to be
prompted on the command line. This function is called with the string
which forms the prompt, and exists to allow the command line history and
abbreviations mechanisms to be implemented.
.Fo SEE ALSO
_prompt_end()
.HU _prompt_end
_prompt_end()
.Fo DESCRIPTION
This macro is a callback macro called after the user has finished entering
text on the command line. It exists to allow the history facility of the
command line to be implemented. The called macro normally saves the string
the user typed in so it can be recalled.
.Fo SEE ALSO
_prompt_begin()
.HU push_back
push_back(key)

.Fo DESCRIPTION

This macro is used to push a character back into the
typeahead buffer. The character pushed back sits at the
front of the input buffer and is read before any user
typeahead.

key is an integer internal key code, usually derived from a
\fIread_char()\fR or \fIkey_to_int()\fR macro call.
.Fo RETURN VALUE

Nothing.

.HU put_nth
put_nth(expr list_var value)

.Fo DESCRIPTION

\fIput_nth()\fR is used to modify or insert a new atom into a
list. list_var is the list; expr is the atom number to be
inserted (0 is the first atom). value is an integer, string
or list expression which is to be inserted.

If the atom to be inserted already exists, then that atom is
deleted, and replaced by the new value.

If the expr'th atom does not exist, then value is inserted
onto the end of the list. It is not possible to create
sparse lists, only new entries may be tacked on to the end
of a list.

.Fo EXAMPLES

The following example creates a list of the ten integers,
1..10:
.DS
.ft CW
	int	i;
	list	l;
	
	for (i = 1; i <= 10; i++)
		l += i;
.ft R
.DE
.Fo RETURN VALUE

Nothing.

.HU put_parm
put_parm(num, value)

.Fo DESCRIPTION

This macro is used to modify a calling parameter. num
specifies the argument number, and value is the value to
place in that argument. value may be a string or an integer
expression. (Lists are not currently supported).

This macro allows the calling macro to pass multiple values
to its calling macro. The calling macro should call this
macro with the name of an integer or string macro in the
num'th position.

.Fo RETURN VALUE

Returns 0 if successful; greater than zero if argument num
does not exist.

.HU quote_list
quote_list(list_expr)

.Fo DESCRIPTION

The \fIquote_list()\fR macro is the mechanism for creating list
literal constants. It is normally used for assigning initial
values to lists, or for passing an anonymous macro to
another macro.

For example, the following sets the list, l, to the two
element list ("one" "two"):
.DS
.ft CW
	list	l;
	l = quote_list("one", "two");
.ft R
.DE

If quote_list() wasn't used, and the expression appeared as:
.DS
.ft CW
	l = "one", "two";
.ft R
.DE

CRISP would assign the value "two" to the list, since in this context
the comma is a binary operator.

Any CRISP expression can appear after the quote_list,
including a sequence of commands.

.Fo RETURN VALUE

The quoted list, list_expr.
.Fo SEE ALSO
make_list()
.HU quote_regexp
quote_regexp(string)

.Fo DESCRIPTION

This macro is used to quote a string so that it can be used
in searches.

For example, suppose the macro writer wishes to search for
the pattern "<>" at the start of a line in the buffer. The
correct way to do this is to write something like:

search_fwd("<\\<\\>")

It is possible for the macro writer to parse the string and
insert the appropriate backslashes, but this would be a very
expensive operation. It is not adequate to turn off regular
expression parsing with \fIsearch_fwd()\fR since then the macro
couldnt be sure to match the string at the start of the line.

In this case, \fIquote_regexp()\fR does the tedious work of
translating the string so that it will match exactly.

.Fo RETURN VALUE

Returns a string with all regular expression characters
quoted.

.HU raise_anchor
raise_anchor()

.Fo DESCRIPTION

\fIraise_anchor()\fR is used to raise the current marked region,
i.e. remove it. The currently highlited region is unhighlited.
.Fo RETURN VALUE

Nothing.

.HU rand
rand([num])

.Fo DESCRIPTION

This macro is used to evaluate random numbers. The number
returned is an integer in the range 0..2^31 or 0..num. The
numbers may or may not be random enough, depending on the
underlying implementation of rand(3). CRISP tries to use the
randomness of rand() to add a bit of variety to the low
order bits of tyhe returned number. However this may not be
effective.
.Fo RETURN VALUE

Random number in range 0..2^31 or 0..num

.HU re_search
re_search([flags], [pattern], [object], [start], [lensym])

.Fo DESCRIPTION

This primitive is designed to replace the search_fwd,
search_back, search_string and search_list primitives. It
provides the same functionality, but is compact and somewhat
easier to read and remember. The motivation for this
primitive is to allow the syntax mode of a search to be set
temporarily for a search rather than for the entire session.
This allows macros to be written which do not have to worry
about the environment the user may have established.

The actual type of search depends on the type of the
expression returned by object. If object is a string, then a
string search is performed. If object is a list then a list
search is done; otherwise a search on the current buffer is
performed.

pattern is the regular expression to look for. start is used
for list searches and indicates the starting point in the
list to start the search from. lensym is used for string
searches to contain the length of the matched string found.

flags is a set of bits defined in crisp.h which control the
options of the search. The flags are as follows:
.TS H
center allbox;
cB cB
l lw(3i).
Flag	Description
=
.TH
0x01 SF_BACKWARDS	T{
Perform a backwards search on the current
buffer. If not specified a forward search is performed. Only
meaningful for buffer searches or translates. 
T}
0x02 SF_IGNORE_CASE	T{
Ignore case when comparing strings.
T}
0x04 SF_BLOCK	T{
Limit searches to hilighted block. (Buffer
searches only). 
T}
0x08 SF_UNIX	T{
Select Unix syntax mode. If not
specified, CRISP/BRIEF mode is used. 
T}
0x10 SF_LENGTH 	T{
If
specified then successful match will return length of
matched string + 1. If not, returned length will take into
account any \c escape sequences in the pattern. Buffer
search only. 
T}
0x20 SF_NOT_REGEXP	T{
Dont treat pattern as a
regular expression.
T}
0x40 SF_GLOBAL	T{
(re_translate only) Perform a global
translate. 
T}
0x80 SF_PROMPT	T{
(re_translate only) Prompt user
for each translation. 
T}
0x100 SF_MAXIMAL	T{
When using CRISP
style syntax match the longest string possible.
T}
.TE
.Fo SEE ALSO
re_translate, search_fwd, search_back, search_string,
search_list, re_syntax
.Fo RETURN VALUE
.TS
center box;
lw(2i) lw(2i).
buffer search:	T{
0 if pattern not found. 
.br
-1 on an error 
.br
length of matched text + 1
T}
list search:	T{
-1 if pattern not found
.br
index of atom if found
T}
string search:	T{
0 if pattern not found
.br
index of first character of match
T}
.TE
.HU re_syntax
re_syntax([mode])

.Fo DESCRIPTION

This macro allows the user to select the regular expression
syntax mode. By default, the mode is set for BRIEF/CRISP
regular expression syntax. If mode is set to 1, then Unix
like syntax is selected. The differences are as follows:

In Unix mode, the '*' and '.' characters have their normal
meanings. The BRIEF/CRISP characters '@' and '?' act as non
regular expression characters. Also the { and } characters
are replaced by their backslash-( and backslash-) equivalents.
.Fo RETURN VALUE

Returns the current regular expression syntax mode - 0 for
BRIEF/CRISP syntax, 1 for Unix-like syntax.

.HU re_translate
re_translate([flags], [pattern], [replacement], [string])

.Fo DESCRIPTION

This function is a new interface to the translate()
primitive which allows the regular expression syntax mode to
be specified temporarily for the translation. This function
allows translations to be made in the current buffer or to a
string. (Translating a string provides similar functionality
to awk's sub() and gsub() functions).

flags are a set of flags which control the translation. See
description of re_search() for further details.

pattern is the string to search for.

replacement is the string to replace the pattern with.

If string is specified then the substitutions are made to
the string, and the resulting translated string is returned.

If either pattern or replacement are not specified then they
will be prompted for.
.Fo RETURN VALUE

For buffer translations, the number of translations made is
returned. For string translations, the translated string is
returned.

.HU read
read([num])

.Fo DESCRIPTION

If num is not specified, then all characters to the right of
the cursor are returned, together with the newline character
which terminates all lines.

If num is specified, then that number of characters are read
from the buffer. If num is longer than the remaining
characters on the current line, then only the rest of the
current line is returned.
.Fo RETURN VALUE

Returns a string containing the next num characters from the
input buffer, or the rest of the line after the cursor if
num is not specified.

.HU read_char
read_char([millisec], [raw])

.Fo DESCRIPTION

This macro can be used to see if a character is available
from the typeahead buffer. If a character is available, it
is returned (in internal key code form), and the character
removed from the typeahead buffer.

If millisec is specified then the read_char() macro will
wait the specified number of milliseconds for a key-press
before returning. If millisec is set to zero, then
read_char() will wait until a key is pressed (same as not
specifying millsec for CRISP). If millisec is set to -1,
then the keyboard will be polled (similar to BRIEF).

If a non-destructive peek into the typeahead buffer is
required, use \fIinq_kbd_char()\fR.

If the second parameter raw is specified and is non-zero,
then a raw character will be read from the keyboard. This
means that hitting a function key will usually return the
first ESCAPE character forming that key code, rather than
being translated into the internal keycode. This facility is
used by the quote() macro.

Internal key codes should not be manipulated as is (unless
the keys are being inserted into the current buffer), but
rather should be converted to the canonical key-code format,
via int_to_key.
.Fo RETURN VALUE

Internal key code of character typed or -1 if no character
available.

.HU read_file
read_file([filename])

.Fo DESCRIPTION

This macro is used to read a file into the current buffer at
the current cursor position. If filename is omitted, then
the user is prompted for the file-name.
.Fo RETURN VALUE

Zero if unsuccessful; non-zero otherwise.
On an error, the global variable \fIerrno\fR will be set
to the reason for the failure.
.HU redraw
redraw()

.Fo DESCRIPTION

This macro is used to physically redraw every character on
the screen, after first clearing the screen. It is sometimes
required on serial lines, etc, where the screen has garbage
on it, and CRISP has lost control.
.Fo RETURN VALUE

Nothing.

.HU refresh
refresh()

.Fo DESCRIPTION

This macro is used to update the screen after making various
changes to buffers and/or windows. It optimises the amount
of output to the screen.
.Fo RETURN VALUE

Nothing.

.HU register_macro
register_macro(num macro [local])

.Fo DESCRIPTION

Registered macros are hooks into the execution of CRISP.
CRISP defines triggers which allow the user's macro's to be
activated when certain conditions arise in CRISP.

The conditions are described by the 'num' parameter, which
is an integer expression. The conditions are listed below.

macro is the name of a macro to call when the trigger is
pulled. If local is specified and is non-zero, then the
macro is only registered for this buffer, otherwise the
event may be triggered even when the current buffer is not
selected.

Multiple macros may be associated with a particular
registered macro. When the registered macro is called, the
macros are called in FIFO order.

Registered macros may be removed by using the
\fIunregister_macro()\fR macro call; a particular registered macro
can be triggered via \fIcall_registered_macro()\fR.
.TS H
center allbox;
cB cB
lw(1i)	lw(4i).
Trigger	Description
=
.TH
0	T{
A character has been inserted into the current buffer via
\fIself_insert()\fR.
T}
1	T{
This is called every time the current buffer is changed
via \fIedit_file()\fR.
T}
2	T{
This is triggered every time the <Alt-H> key is pressed,
and is used for the context sensitive help feature.
T}
3	T{
This is triggered whenever an unassigned key is pressed.
T}
4	T{
This is triggered when the keyboard idle timer expires. It
allows the autosave feature to be implemented.
T}
5	T{
This is called just before CRISP exits. It allows macros
to tidy up after themselves, e.g. delete temporary files, save
editing state.
T}
6	T{
This is called every time a new file is read in to a
buffer (via edit_file).
T}
7	T{
This is called whenever the user types the interrupt
character (by default ^Y). This allows macros to set a flag
which can cause them to abort.
T}
8	T{
This is called whenever the user types in an invalid key
during input on the status/prompt line. This allows the
abbreviation and help facilities to be implemented.
T}
9	T{
An internal error occured. This used to trap segmentation
violations inside CRISP and allows users to write their own 'emergency' 
macro to save buffers. (One is already provided
-- refer to the core.cr macro). 
T}
10	T{
Called when mouse
activity detected. This is not fully supported at present.
T}
11	T{
Called when process input available from a process
buffer. 
T}
12	T{
Called when keyboard buffer empty. This macro MUST return an integer value.
If the value is zero, then keyboard input can be read. If it is non-zero,
then the keyboard should not be read, but the internal code will check
the push-back buffer for input. 
T}
.TE
.Fo RETURN VALUE

Nothing.

.HU remember
remember([overwrite], [macro])

.Fo DESCRIPTION

remember is used to record a keyboard macro (a sequence of
keystrokes) that can later be played back via \fIplayback()\fR.

The argument overwrite is an optional string whose first
character is examined to see whether an existing keyboard
macro should be overwritten. If a keyboard macro already
exists, and overwrite is not specified, then the user is
prompted to overwrite the macro. If overwrite is specified
and the first character of overwrite is a 'y' or 'Y' then
the keyboard macro will be overwritten.

macro specifies which keyboard macro to store the keystrokes
in. If macro is unspecified then the next free keyboard

If remember is called whilst recording a keyboard macro,
then the recording is terminated.

remember is not usually called as part of a macro but is
usually bound to a keyboard key (<F7>).

remember will also create a buffer called KBD-MACRO-xx where
xx is the keyboard macro number. This buffer contains the
top level macros executed by the user typing in the keys.
This facility allows the user to save and edit a keyboard
macro. Note that not all the macros executed by the user are
saved in the buffer - only the top level ones. What this
means is that keyboard input to things like dialog boxes
(e.g. the buffer list) will not be listed. The buffer so
created is a normal buffer but will not be automatically
saved when you exit. It is the user's responsibility to save
the buffer is you want to keep the macro.
.Fo RETURN VALUE

On completion of the recording, a keystroke macro ID is
returned containing.
.HU remove
remove(string file)

.Fo DESCRIPTION
This function is equivalent to the ANSI C function \fIremove()\fR for
removing files. 
.Fo RETURN VALUE
On success a return value >= 0 is returned; -1 is returned on an error,
and the global variable \fIerrno\fR is set to the reason for the error.
.Fo SEE ALSO
del()
.HU rename
rename(old_file, new_file)

.Fo DESCRIPTION
This primitive is used to rename a file. old_file and new_file should be strings
containing the names of the file.
.Fo RETURN VALUE
Returns zero on success and -1 on failure. On failure the global variable
\fIerrno\fR is set to the reason for the failure.
.HU restore_position
restore_position([move])

.Fo DESCRIPTION

This macro restores a saved position from the position
stack. move is an optional integer expression. If move is
specified and is zero, then the saved position is not
restored, but simply discarded.

The saved position stack is independent of the current buffer.
.Fo RETURN VALUE

Returns 0 if there is no saved position on the stack; 1 if
position was successfully restored.

.HU return
return [expr];

.Fo DESCRIPTION

This macro is used to return from a macro, and optionally
return a value. If expr is specified, it may be an integer,
string or list expression.

The current macro is terminated and control passes to the
calling macro.
.Fo RETURN VALUE

Value of expr.

.HU returns
returns([expr])

.Fo DESCRIPTION

This macro is similar to \fIreturn\fR, except it doesn't cause
the current macro to terminate. It simply sets CRISPs
internal accumulator with the value of expr. If any other
statements follow the execution of \fIreturns()\fR, then the
accumulator will be overwritten.

Use of this macro is not recommended.

This macro is not strictly compatible with the \fIreturns()\fR
macro of BRIEF.
.Fo RETURN VALUE

Value of expr.

.HU right
right([n])

.Fo DESCRIPTION

Moves the cursor 'n' positions to the right. This is
equivalent to adding 'n' to the current column position.
Note that when the cursor moves it doesnt move over
characters atomically but one column at a time. This allows
the cursor to move beyond the end of the line and into the
middle of a tab stop, for example.

If you want to move over physical characters, use the
\fInext_char()\fR and \fIprev_char()\fR macros instead.

n may be positive or negative. negative amounts move leftward.

.Fo RETURN VALUE

Nothing.

.HU rindex
rindex(search-string, pattern)

.Fo DESCRIPTION

This function returns the index in search-string of the last
occurence of pattern. This function is useful for splitting
a filename into its filename and directory components.

If the user needs to search for regular expressions, then
the function search_string should be used instead.

(See also \fIindex()\fR).

.Fo EXAMPLES

The following example splits a string into a directory and
filename part.
.DS
.ft CW
	string	dir, file, filename;
	int	i;
	
	i = rindex(filename, "/");
	if (i != 0) {
		dir = substr(filename, i - 1);
		file = substr(filename, i + 1);
		}
	else {
		dir = ".";
		file = filename;
		}
.ft R
.DE
.Fo RETURN VALUE

Returns 0 if pattern cannot be found in search-string;
otherwise returns the last occurence of pattern in
search-string.

.HU save_position
save_position()

.Fo DESCRIPTION

This macro is used to save the current buffer and cursor
position. It makes use of an internal position stack;
\fIrestore_position()\fR can be used later to restore the cursor
position.

Note that the position stack is an independent stack of any
buffer. This means that \fIrestore_position()\fR may be called to
pop off the top entry of the stack even when the current
buffer is not the same as buffer referenced by the top of
the saved position stack.
.Fo RETURN VALUE

Nothing.

.HU screen_dump
screen_dump([file])

.Fo DESCRIPTION

This macro is used to get a snapshot of the current screen
image. It will write the current screen to the named file or
to the file /tmp/crisp.screen if file isn't specified.

It does not make use of the screen's character attributes
and makes an approximation for the screen drawing characters.
.Fo RETURN VALUE

-1 if cannot write file; 0 if successful.

.HU search_back
search_back([pattern], [re], [case], [block], [length])

.Fo DESCRIPTION

This function searches from the current cursor position
backwards towards the top of the buffer looking for pattern.

If pattern is omitted, it is prompted for.

If re is specified and it is zero, then pattern is treated
as a pure string; if it is omitted or is non-zero, then
pattern is treated as a regular expression. (See section on
Regular Expressions for details of the syntax of regular
expressions).

If case is specified and is zero, then the pattern is
treated non-case sensitively, i.e. A matches a. Otherwise
the search is performed with case being sensitive.

If block is specified and is non zero, then the search is
confined to the currently marked region.

If length is specified and is non-zero, then it indicates
that on a successful return the length of the matched string
should be returned + 1. If it is not specified, then the
return length will take into account any \c parameters in
the regular expression.
.Fo RETURN VALUE

Returns 0 if pattern not found. -1 if an error is detected.
Otherwise it returns the length of the matched text + 1.

.HU search_case
search_case([case])

.Fo DESCRIPTION

This macro is used to set the value of the search case flag.
By default all searches are case sensitive, i.e. "A" does
not match "a". By setting case to non-zero, case sensitivity
will be ignored when performing matches.

If case is omitted, the current value is toggled.
.Fo RETURN VALUE

Returns the previous value of the case flag.

.HU search_fwd
search_fwd([pattern], [re], [case], [block], [length])

.Fo DESCRIPTION

This function searches from the current cursor position
towards the end of the buffer looking for pattern.

If pattern is omitted, it is prompted for.

If re is specified and it is zero, then pattern is treated
as a pure string; if it is omitted or is non-zero, then
pattern is treated as a regular expression. (See section on
Regular Expressions for details of the syntax of regular
expressions).

If case is specified and is zero, then the pattern is
treated non-case sensitively, i.e. A matches a. Otherwise the
search is performed with case being sensitive.

If block is specified and is non zero, then the search is
confined to the currently marked region.

If length is specified and is non-zero, then it indicates
that on a successful return the length of the matched string
should be returned + 1. If it is not specified, then the
return length will take into account any \c parameters in
the regular expression.
.Fo RETURN VALUE

Returns 0 if pattern not found. -1 if an error is detected.
Otherwise it returns the length of the matched text + 1.

.HU search_list
search_list([start], pattern, list_expr, [regexp], [case])

.Fo DESCRIPTION

This macro is used to search a linked list for a string
pattern.

If start is not specified, the search is started from the
beginning of the list; otherwise the search starts from the
atom numbered start.

pattern is the string to search for, and may or may not be a
regular expression, depending on the value of regexp.
list_expr is the list to search.

If regexp is not specified or is zero, then pattern is not
treated as a regular expression. If it is specified and
non-zero then pattern is considered to be a regular
expression.

If case is specified and is non-zero, then the case
sensitivity is taken into account.
.Fo RETURN VALUE

The index of the atom in list_expr where the pattern was
found; -1 otherwise.

.HU search_string
search_string(pattern, string, [length], [re], [case])

.Fo DESCRIPTION

This macro is used to search string for the pattern,
pattern. If re is specified and is zero, then pattern is
treated as a literal string - not a regular expression (in
which case this function is similar to \fIindex()\fR). If case is
specified and is zero, then the search is done with case
insensitive.

If length is specified (name of an integer variable), then
it will receive the length of the matched pattern, if the
search is successful.
.Fo RETURN VALUE

Returns the starting character in string where the match was
found, or zero if the match failed.

.HU self_insert
self_insert([n])

.Fo DESCRIPTION

This macro is the means for the user to type data into the
current buffer. It causes the last character to be typed to
be inserted into the buffer (or overtyped if overtype mode
is on).

If n is specified, then the character whose ASCII value is n
is inserted into the file instead of the last character typed.
.Fo RETURN VALUE

Nothing.

.HU send_signal
send_signal(signal)

.Fo DESCRIPTION

This macro is used to send a signal to a process. The signal
is sent to the process attached to the current buffer. If no
process is attached to the current buffer then it is a no-op.
.Fo RETURN VALUE

Nothing.

.HU set_backups
set_backups([mode])

.Fo DESCRIPTION

This macro can be used to inquire or turn on/off the setting
of the backups flag. The backups flag is tested every time a
buffer is written away (via write_buffer). If the flag is
on, then a backup file is made.

If mode is not specified, then the backup flag is toggled. A
non-zero value for mode turns backup creation on. Zero turns
it off.

If called from the keyboard, then one of the following
messages are printed:

Backups will be created. Backups will not be created.
.Fo RETURN VALUE

Returns the previous value of the backup flag.

.HU set_binary_size
set_binary_size(size)

.Fo DESCRIPTION

This macro sets a value called the binary chunk size. This
is used when reading in binary files to break up lines into
chunks so that the lines fit on the screen reasonably. The
default chunk size is 16 bytes. Each line in a buffer needs
about 16 bytes of memory overhead plus the data for the line
itself. This means that in the default condition, CRISP may
need memory equal to twice the size of the file being read
in. Increasing the binary chunk size will lower this
overhead considerably.

If the value specified is <= 0, then files will not be interpreted as
binary files when they are read in.
.Fo RETURN VALUE

Previous value of the binary chunk size.

.HU set_buffer
set_buffer(bufnum)

.Fo DESCRIPTION

This macro is used for changing the current buffer; bufnum
is a buffer identifier, as returned via a \fIcreate_buffer()\fR or
\fIinq_buffer()\fR call.

\fIset_buffer()\fR does not cause any registered macros to be
called (unlike edit_file).
.Fo RETURN VALUE

Returns the ID of the previous buffer or less than zero if
bufnum is an invalid buffer.

.HU set_buffer_cmap
set_buffer_cmap([cmap_id], [buf_id])

.Fo DESCRIPTION

This macro is used to apply a character mapping to a buffer.
A character map associated with a buffer has higher
precedence than a map associated with a window.

The character map is used in converting column positions in
a line into the actual character pointer in the internal code.

.Fo SEE ALSO
create_char_map(), inq_char_map(), set_window_cmap()
.Fo RETURN VALUE

Returns value of cmap_id or -1 if the specified character
map does not exist.

.HU set_buffer_flags
set_buffer_flags([and_mask], [or_mask])

.Fo DESCRIPTION

This primitive is used to modify the internal flags
associated with a buffer. If and_mask is set, then the
internal mask is AND'ed with the mask; if or_mask is set
then the internal mask is OR'ed with the mask. The and_mask
is performed before the or_mask. If the and_mask turns off
the buffer changed flag, then the internal 'number of
modifications' flag associated with the buffer is also
cleared.

This allows a calling macro to make a set of changes to a
buffer, but not have the buffer marked as being modified for
the buffer_list macro or the exit code.

.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Flag	Meaning
=
.TH
0x01	If set, buffer has been modified.
0x02	If set, buffer will be backed up when written away.
0x04	Buffer is marked as read-only.
0x08	Reserved.
0x10	Underlying file has execute permission.
0x20	Process attached.
0x40	Buffer is in binary mode.
0x80	T{
ANSI mode -- color escape sequences will be processed.
ANSI mode will only work if the current character map has
the ESCAPE and BACKSPACE characters defined appropriately.
T}
0x100	Buffer does not map tabs to spaces.
0x200	Buffer is a system buffer.
0x400	Make all characters in window visible.
0x800	Dont save undo info for buffer.
.TE
.Fo SEE ALSO
create_char_map(), set_buffer_cmap()
.Fo RETURN VALUE

Nothing.

.HU set_calling_name
set_calling_name(name)

.Fo DESCRIPTION

This macro is used to set the calling name of the current
macro. The calling name can be retrieved via the
\fIinq_called()\fR macro.
.Fo RETURN VALUE

Nothing.
.HU set_font
set_font(font_name)
.Fo DESCRIPTION
This primitive is used to change the character font when running CRISP in
a windowing environment, for example X11. It is a no-op in other environments.
Its purpose is to use the selected font name (which is a string).
.Fo RETURN VALUE
Returns 0 on success and -1 on a failure.
.HU set_idle_default
set_idle_default(value)

.Fo DESCRIPTION

This macro can be used to change the value of the idle timer.
.Fo RETURN VALUE

Previous value of idle timer.

.HU set_msg_level
set_msg_level(msg_level)

.Fo DESCRIPTION

This macro is used to set the message level. The message
level is used to control what sort of messages are to be
displayed on the status line. It is needed by some macros
which dont want CRISP internal messages to be displayed.

msg_level is a number in the range 0-3 with the following
effects:

.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Value	Meaning
=
.TH
0	This is the default - all messages on. 
1	T{
Normal messages
(those printed via (message) are not displayed). Error
messages still display. 
T}
2	Error messages are disabled. 
3	T{
normal messages and error messages are disabled.
T}
.TE

Message level 3 can be used to ensure a macro is 'quiet'.
.Fo RETURN VALUE

Nothing.

.HU set_process_position
set_process_position([line], [col])

.Fo DESCRIPTION

This macro sets the line and/or column associated with the
input from a sub-process. line & col are optional, and if
specified are integer values specifying the line and column
where input should carry on from.

Processes maintain their own independent input in the buffer
so that it is easier to write macros which manipulate
sub-processes.
.Fo RETURN VALUE

Returns -1 if current buffer is not attached to a process;
returns 0 otherwise.

.HU set_scrap_info
set_scrap_info([insert_newline], [mark_type], [buf_id])

.Fo DESCRIPTION

This macro is used to set the newline flag at the end of the
scrap bufferk. This flag controls whether a newline should
be inserted into the buffer after a paste operation. This
field is not currently supported.

The mark_type parameter is used to set the type of scrap
information. The mark_type should be a number indicating the
type of region which was inserted into the scrap buffer.
These numbers are the same as those for drop_anchor().

If buf_id is specified then that buffer is used as the new scrap buffer.
.Fo RETURN VALUE

Nothing.

.HU set_term_characters
set_term_characters([top_left], [top_right], [bot_left], [bot_right],
[vertical], [horizontal], [top_join], [bot_join], [cross],
[left_join], [right_join])
.Fo DESCRIPTION

This macro is used to set the escape sequences needed to
support the CRISP window drawing characters. These escape
sequences are non-standard in the sense that termcap does
not support them (although some of these are supported by
terminfo, but CRISP does not currently support terminfo).

This macro should be called before the display is enabled
(see \fIenable_display()\fR).

Each parameter is either NULL indicating that no value is
being provided, or an integer or string expression. If an
integer expression is specified, then CRISP treats this as
meaning that the escape sequence as such consists of a
single ASCII character, whose value is given by the integer
expression. If a string expression is given, then this
string is printed when the specific character is needed on
the display.

The following parameters have the following meanings:

top_left Printed at top left of window. top_right Printed at
top right of window. bot_left Printed at bottom right of
window. bot_left Printed at bottom left of window. vertical
Printed at vertical line at side of window. horizontal
Printed on horizontal line at top and bottom of window.
top_join Character used at the top right and top left of
windows where they abut each other. (Not currently
implemented). bot_join Character used at the bottom right
and bottom left of windows where they abut cross Character
used to print where four windows intersect at a common
corner. left_join Character used at intersection of three
windows on the left side of main window. right_join
Character used at intersection of three windows on the right
hand side of main window.

.Fo EXAMPLES

For examples of how this macro is used, refer to the tty/*.cr
macros, which have examples for a number of common
environments.
.Fo RETURN VALUE

Nothing.

.HU set_term_features
set_term_features([space], [char], [icursor], [ocursor], [vicursor],
[vocursor], [escape], [repeat], [zerom], [color], [escC], 
[clr_color_is_black], [noscroll])

.Fo DESCRIPTION

This macro is used to specify certain attributes about the
current display - features which are not adequately handled
by termcap of terminfo.

Each parameter is either NULL indicating that the feature is
not available, or an integer or string expression. zerom and
color are boolean expressions and only integer expressions
(zero or non-zero) should be specified for these two. The
others are escape sequences, along the lines of
\fIset_term_characters()\fR.

If these escape sequences are not specified, CRISP will
still function but will not perform very well.

If any of the escape sequences can be described as single
ASCII characters then that particular parameter can be
specified as an integer expression whose value is that ASCII
character.

The parameters describe the following features of the display:
.TS H
center allbox;
cB cB
lw(1i) lw(4i).
Arg	Description
=
.TH
space	T{
This is an escape sequence used to blank out the next
N character positions. This is usually defined as "\x1B[%dX"
for those displays that understand the ANSI ESC [ X escape
sequence. The escape sequence must have an embedded '%d' to
specify where the numeric qualifier goes.

If this escape sequence is not defined, then CRISP makes do
with printing the correct amount of spaces and then moving
the cursor back to the start of the cleared region. This is
not as efficient as the ESC[X escape sequence when N is
larger than about 8 or 9 characters.
T}
char	T{
This is an escape sequence used to allow access to
characters with the top bit set. Some displays, especially
those based on the IBM/PC require a special escape sequence
to access the characters with the top bit set.

It is valid for a '%c' or '%d' to be embedded in the
character definition.

If this escape sequence is not defined, CRISP will avoid
printing characters with the top bit set and will use the
\fIdisplay_mode()\fR option instead.

If this option is defined, CRISP turns off the display mask
(see dislpay_mode). This ensures characters with the top bit
set get printed properly. If you want 8-bit characters to be
displayed in Hex/Octal then you'll need to reset the mask.
T}
T{
icursor,
.br
vicursor,
.br
ocursor,
.br
vocursor
T}	T{
These escape
sequences are used to change what the cursor looks like.
These sequences represent the insert cursor, virtual-insert
cursor, overtype cursor, and virtual-overtype cursor
respectively.

If these escape sequences are not defined CRISP will display
a two character mnemonic on the status line indicating what
mode the cursor is in.
T}
repeat	T{
This defines an escape sequence for repeating the
previous character printed. It is not currently used.
T}
escape	T{
This defines an escape sequence used for printing out
the ESC character itself. This is available because some
systems have a feature whereby there is a short cut to
printing the ESC character.
T}
zerom	T{
If this is non-zero, then whenever an ESC[0m is
printed, it is assumed that the background and foreground
colours get reset. This is true of Interactive V.3 (although
not Microport).
T}
color	T{
If non-zero, then terminal supports color. The escape
sequences for color are built into CRISP. CRISP assumes that
if this is set, that the ANSI X 3.64 escape sequences are
valid. 
T}
escC	T{
Indicates escape sequence to move 'n' columns
over is available. (Needed because termcap cannot describe
this entry). 
T}
clr_color_is_black	T{
Sending an escape sequence
to erase an area (e.g. to end of line) sets the area to
black if this is specified. If not specified, or FALSE, then
area gets set to the current background color.
T}
noscroll	T{
Set to TRUE to avoid scrolling the window when
attempting to optimise output. On some bitmapped displays
its faster to rewrite the window. 
T}
graphics	T{
Escape sequence
to send when sending graphics (line drawing) characters.
T}
text	T{
Escape sequence to send when exiting graphics mode and
going back to normal character set.
T}
.TE
.Fo EXAMPLES

Refer to the tty/*.cr files for examples of this macro.
.Fo RETURN VALUE

Nothing.

.HU set_term_keyboard
set_term_keyboard(range1, key-list1, range2, key-list2, ..)

.Fo DESCRIPTION

This macro is used to define the keyboard bindings. The
keyboard bindings is an internal table to CRISP describing
which physical keys on the keyboard generate which internal
key code.

When a key is pressed CRISP scans the internal key code
table to see if the character it has just read is part of a
function key sequence. If so it waits until it receives an
unambiguous string of characters either identifying the
function key or a sequence typed by the user.

This primitive allows the user to define mappings between
the escape sequences generated by the function keys and the
internal key codes. It also allows multiple physical keys to
be mapped to the same internal key code. For example, on a
Sun keyboard the L1 and F1 keys can be mapped so that they
are indistinguishable by the various macro primitives.

The internal function keys are given numbers out of the
range of 8-bit ASCII characters.

On non-PC keyboards, e.g. SUN-3 keyboard, the function keys
and LEFT/RIGHT keys can be used as a 'META' key prefix (much
the way ALT is used on a PC keyboard).

The arguments to \fIset_term_keyboard()\fR consists of a sequence
of ranges and key-lists. The ranges exist to make it easy to
allocate the keys and read the macro afterwards. This avoids
having to call this macro with upwards of 100 key
definitions, and the resultant inability to decipher
mistakes made on the 51st argument, for example.

The include file tty.h defines the ranges. A range is simply
a number. The first function keys (<F1>..<F12> start at
128). By specifying a range of 128, this means that
consecutive key definitions will start at this range, and be
allocated consecutive slots from thereon. (See the tty-*.m
files for an example of how this works).

The key-list is simply a list of strings describing each
consecutive key. If the keys are to be hard-wired, then the
\fIquote_list()\fR function will be very useful. Otherwise the
list can be constructed with the other list primitives.

Ambiguous key prefixes are allowed. This allows keys to be
defined with the usual ESC-type prefixes. If the start of an
ambiguous key sequence is typed, then CRISP will wait upto .5
second for more keystrokes to resolve the ambiguity.
After this time, CRISP treats the original ambiguous
characters as standalone. On some keyboards, viz. Suns,
RTPCs, Microport and Interactive, this means that hitting
the ESCape character will delay progress for 0.5 second,
until CRISP realises that no more keys are coming.

Because of this ambiguity problem, problems can arise when
using CRISP across a network, for example. When using
applications like telnet, keeping your finger on the <Up> or
<Down> keys, etc, can cause CRISP to misread the keyboard,
with the effect that instead of treating something like
ESC[A as <Up>, it treats it as the single characters, ESC,
[, A causing them to be inserted into the buffer. I do not
know of any cure for this, except to increase the default .5
second timer. Increasing the .5 second timer inside CRISP
causes the side effect that hitting the ESC key at the
buffer_list prompt, for example, causes an annoying delay.
.Fo RETURN VALUE

Nothing.


.Fo EXAMPLES

The following example is the first section of the
\fIset_term_keyboard()\fR macro from the tty/at386.cr macro file.
.DS
.ft CW
	set_term_keyboard(F1_F12, 
		quote_list("\\\\x1BOP", "\\\\x1BOQ",
			"\\\\x1BOR", "\\\\x1BOS", "\\\\x1BOT", "\\\\x1BOU",
			"\\\\x1BOV", "\\\\x1BOW", "\\\\x1BOX", "\\\\x1BOY", 
			"\\\\x1BOZ", "\\\\x1BO["));
.ft R
.DE
.HU set_top_left
set_top_left([line], [col], [win_id], [csrline], [csrcol], [buf])

.Fo DESCRIPTION

This macro is used to set the position of the buffer
attached to a window. It sets the display position. All
variables are optional integer expressions.

line and col are optional integer expressions which specify
the line in the buffer which is to appear as the top line in
the screen, and col specifies the column number which should
appear in the top left hand position in the screen.

csrline and csrcol specify the buffer position to set in the
associated buffer.

win_id specifies the window to use. buf indicates to use the
window which has the specified buffer attached. win_id is
used first, and if not specified, then the buf parameter is
used. If neither are specified then the current window is
assumed.

.Fo EXAMPLES

The following example puts the current line in the center of
the window (this is the macro normally mapped to <Ctrl-C>).

.DS
.ft CW
	set_center_of_window()
	{
		int	cur_line;

		inq_position(cur_line);
		
		set_top_left(cur_line - inq_window_size() / 2);
	}
.ft R
.DE
.Fo RETURN VALUE

Nothing.

.HU set_window
set_window(win_id)

.Fo DESCRIPTION

Changes the current window to the window specified by
win_id. win_id is a window identifier, as previously
returned via \fIinq_window()\fR.
.Fo RETURN VALUE

Nothing.

.HU set_window_cmap
set_window_cmap([cmap_id], [win_id])

.Fo DESCRIPTION

This primitive is used to associate a character map with a
window. A character map is a way of viewing the underlying
data in a buffer. The character map is simple a map of each
of the 256 possible byte values and the string to be
printed. Character maps allow the user to write customised
macros, for example to view a buffer in hexadecimal mode.

cmap_id is a character map ID previously created by the
create_char_map() primitive, or NULL to use the internal
default map.

win_id is the window to set the map for. If not specified,
then the current window is used.
.Fo SEE ALSO
create_char_map(), inq_char_map(), set_buffer_cmap().
.Fo RETURN VALUE

Nothing
.HU set_wm_name
set_wm_name(window_name, icon_name)

.Fo Description
This function is used to allow a macro to set the window name and/or
icon name, when CRISP is running under a windowing system. It is a no-op
on other systems.

window_name and icon_name are string values. Either one may be omitted in which
case the appropriate name will not be modified.

This function is designed to allow macros to be written which can set
the window name to the current directory, for example.
.Fo RETURN VALUE
Nothing
.HU shell
shell([command], [use_shell], [completion])

.Fo DESCRIPTION

This command is used to execute a command in a shell.
command is a string expression which evaluates to a command
(with or without its arguments) which is exec()ed by CRISP.

The use_shell parameter is an integer expression which
controls whether the display should be left intact or not.
If it is omitted or zero, then CRISP puts the terminal back
into normal \fIcooked\fR mode and executes the command string.
When the sub-process exits, CRISP repaints the screen. If
use_shell is non-zero, then CRISP does not repaint the
screen. Setting use_shell to non-zero is useful for things
like the make and directory manipulation macros which know
the sub-process cannot destroy the screen.

The command string is passed to the shell so it can execute
and interpret the command string (e.g. wildcard expansion,
semicolons etc). The shell used is gotten from the SHELL
environment variable. 
If this fails, it defaults
to /bin/csh.

The return from this macro is the shell exit status.

If completion is specified, then it should be the name of a
macro (in quotes - with optional arguments) which will be
called when the sub-process terminates. When using this
facility, you should set the use_shell parameter to 1 to
avoid CRISP from waiting for the sub-shell to complete.

The completion routine is called with the first parameter
set to the return status from the underlying process. Any
other positional parameters are shifted up one.

.Fo EXAMPLES

The following macro can be used to get a subshell to type
commands into. The user terminates the sub-shell by typing
the usual ^D or exit. (This is the same as what <Alt-Z> is
usually mapped to).

.DS
.ft CW
shell()
.ft R
.DE

The following example performs a \fIwho(1)\fR command and saves the
output in a temporary file so the calling macro can maybe
display it prettily afterwards:

.DS
.ft CW
	shell("who >& /tmp/who.tmp", 1);
.ft R
.DE

The '1' tells CRISP not to bother repainting the screen.

The following example causes a macro to be called when the
sub-process terminates. The sub-process then prints a
message saying that the process has terminated.
.DS
.ft CW
	shell("make", 1, "completion");
	 ...
	completion(int status)
	{
		message("Job done, status = %d", status);
	}
.ft R
.DE
.Fo RETURN VALUE

Returns the shell exit status (under Unix, 0 means command
exited successfully, non-zero means command failed for some
reason).

.HU sin
sin(x)

.Fo RETURN VALUE

Returns the sine of x (in radians) as a floating point number.
.Fo SEE ALSO
cos, tan, asin, acos, atan
.HU sinh
sinh(x)

.Fo RETURN VALUE

Returns the hyperbolic-sine of x as a floating point number.
.Fo SEE ALSO
cosh, tanh
.HU sleep
sleep([sec])

.Fo DESCRIPTION

This macro causes the calling macro to sleep for sec seconds
(or 1 if omitted).
.Fo RETURN VALUE

Nothing.

.HU sort_buffer
sort_buffer([bufnum])

.Fo DESCRIPTION

This macro can be used to sort the lines in the current
buffer or the buffer specified by bufnum. If the buffer
specified has a region marked, then only those lines within
the region are sorted.

The lines are sorted alphabetically - there is no mechanism
to perform sorting based on keys within each line, or based
on other criteria, e.g. sorting numerically, etc.

Be wary of this macro -- if it is used on a non-system
buffer, it is not possible to 'undo' the sort.

This macro is an experimental macro, and its functionality
may change in the future or be deleted.

.Fo EXAMPLES

The following example sorts all the lines in the current
buffer into order:

sort_buffer()
.Fo RETURN VALUE

Nothing.

.HU split
split(string, chars, [numeric])

.Fo DESCRIPTION

This macro can be used to parse a string and split it up
into tokens, in a similar manner to the C function strtok,
but it does the breaking up of the input string in one go
and returns a list of strings. The chars parameter is a
string containing delimiter character used to split the
tokens.

If numeric is specified and is non-zero, then all tokens
which start with a digit are converted to a number, rather
than a string.

.Fo EXAMPLES

The following example causes 'lst' to be assigned a four
element list containing strings where each string is one of
the words of the parameter.
.DS
.ft CW
	list lst;

	lst = split("The quick brown fox", " ");
.ft R
.DE
.Fo SEE ALSO
sscanf, index, substr.

.Fo RETURN VALUE

List of strings where each string is a 'token' from the
string parameter.

.HU sprintf
sprintf(buf, fmt, [arg1], [arg2], ..)

.Fo DESCRIPTION

This macro acts like the C sprintf() function. It copies the
string 'fmt' to the string variable 'buf' and applies the
printf style formatting commands as specified in fmt, and
using the argument list.

Refer to the (message) macro for details on the formatting
options available.
.Fo RETURN VALUE

Nothing.

.HU sqrt
sqrt(x)

.Fo RETURN VALUE

Returns the square root of x, as a floating point value.
.HU srand
srand([seed])

.Fo DESCRIPTION

This macro is used to set a seed for the random number
generator returned by rand(). If seed is not specified then
the current time in seconds is used. Specifying seed allows
the calling macro to have a repeatable set of random numbers.

.Fo SEE ALSO
.Fo RETURN VALUE

Nothing.

.HU sscanf
sscanf(string, format, sym1, sym2, ..)

.Fo RETURN VALUE

Number of variables actually assigned to.

.Fo DESCRIPTION

This function is similar to the C language sscanf() function
and is somewhat more generic than the split() function. It
is used to parse a string and break it up into constituent
elements assigning them to the specified variables.

THIS PRIMITIVE IS NOT YET IMPLEMENTED.
.HU _startup_complete
_startup_complete(n)
.Fo DESCRIPTION
This macro is a callback macro. It is called after all command line
switches have been process, after all command line files have been read in,
and after the startup() macro has been called. The macro is passed an
integer parameter, with the value 0 to indicate that no command line
files were specified, or 1 to indicate that command line files were
read in.

This macro is used by the restore macro to avoid restoring the state
of buffers and files when files have been specified on the command line.

Refer to the \f(BHrestore.cr\fR macro file for an example of this
macro.
.HU string
string var1, var2, ..;

.Fo DESCRIPTION

This macro is used to define local variables which are to
contain only string values. The variables defined are local
variables, and are destroyed when the macro executing this
declaration terminates.

String variables can contain variable length strings (upto
2^32 bytes long on machines with 32-bit int's, and 2^16
bytes on machines with 16-bit int's).
.HU string_count
string_count(string, char-list)

.Fo DESCRIPTION

This macro is used to count the occurences of characters in
the string argument. char-list can be a string with one or
more characters in it. The string argument is parsed looking
at each character to see if any of the characters from
char-list match it.

.Fo EXAMPLES

The following example counts how many spaces occur in the
input string:
.DS
.ft CW
	string	s;
	int	num;
	
	num = string_count(s, " ");
.ft R
.DE

The following example counts how many upper case letters
appear in the input string:
.DS
.ft CW
	num = string_count(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
.ft R
.DE
.Fo RETURN VALUE

Returns the number of times the characters in char-list
occur in the string parameter.

.HU strlen
strlen(expr, [step])

.Fo DESCRIPTION

This macro can be used to find out how long a string is or
the length of the longest string in a list. If expr is a
list expression, then step indicates whether certain entries
should be skipped over, e.g. if the list contains paired
tuples where the odd elements of the list are sub-lists,
etc. If omitted, step defaults to 1.

When finding the lengths of lists, it always starts with the
first element of the list. strlen silently ignores none
string elements in the list.
.Fo RETURN VALUE

Returns the number of characters in the string expression,
expr or the length of the longest string in the specified
list.

.HU substr
substr(string, start, [length])

.Fo RETURN VALUE

Returns the sub-string of string which starts at start, and
goes on for length characters, or the end of the string if
length is omitted.
.HU suspend
suspend()

.Fo DESCRIPTION

This macro is equivalent to typing Ctrl-Z if you have job
control enabled. It may be called from a macro to suspend
crisp and allow the user to user an alternative key to
Ctrl-Z if that is being used for something else.

This macro will only work on systems which support job
control.
.Fo RETURN VALUE

Nothing.

.HU swap_anchor
swap_anchor()

.Fo DESCRIPTION

This macro swaps the current cursor position with the start
of the currently marked region, i.e. if the cursor is at the
end of the marked region, the cursor is moved to the start
of the marked block, keeping the marked block intact.
.Fo RETURN VALUE

Nothing.

.HU switch
switch (expr) { case-1: list-1 case-2: list-2 ..}

.Fo DESCRIPTION

This macro implements the CRISP switch statement. expr is an
integer or string expression which is evaluated and then
compared with each of case-1, case-2, etc. case-1, etc
should be expressions of the same type as expr. If a match
is found, then the statements in list-n are executed.

If CRISP encounters a case-n value of NULL, then this is
taken to be the default and the list is unconditionally
executed.

If statement list associated with an expression is NULL,
then the next non-NULL statement list associated with a case
expression is executed. This allows multiple values to be
associated with the same set of statements. (See example
below).
.Fo EXAMPLES

The following example illustrates an example of integer
switches. If the value of i, is 1, 2, or 3 then word is
assigned the strings "one", "two" or "three" respectively.
If i is not one of these three values, then word is assigned
the ascii representation of i.
.DS
.ft CW
	string	word, buf;
	int	i;
	
	switch (i) {
	  case 1:	word = "one";
	  		break;
	  case 2:	word = "two";
	  		break;
	  case 3:	word = "three";
	  		break;
	  default:
	  		sprintf(buf, "%d", i);
			break;
	  }
.ft R
.DE

The following shows the reverse:
.DS
.ft CW
	string	word;
	int	i;

	switch (word) {
	  case "one":	i = 1;
	  		break;
	  case "two":	i = 2;
	  		break;
	  case "three":	i = 3;
	  		break;
	  default:
	  		i = atoi(word);
			break;
	  }
.ft R
.DE

The following shows an example of using multiple case values:
.DS
.ft CW
	string word;
	
	switch (word) {
	  case "y":
	  case "Y":
		word = "YES";
		break;
	  case "n":
	  case "N":
		word = "NO";
		break;
	  }
.ft R
.DE
.HU tabs
tabs([tab1], [tab2], .., [tabn])

.Fo DESCRIPTION

This macro is used to set the tab stops for the current
buffer. tab1, tab2, set the first tab stops. Tab stops are
set every (tabn - tabn-1) stops after the last tab stop. The
first column in the line is column 1.

Upto 5 unique tab stops can be specified, thereafter all tab
stops default to the difference of the last two tab stops.

In soft tab mode (see (use_tab_char)), whenever a tab is
inserted into the text, enough spaces are inserted
automatically to take the cursor to the next tab stop. When
in hard tab mode, physical tab characters are inserted.

When in hard tab mode, the tab stops only affect the way the
text buffer is displayed; if tab stops other than the
default 8 are used, then the user may have problems printing
files or using other utilities to examine the file due to
column misalignment.

.Fo EXAMPLES

The following sets tab stops to every 4 columns:
.DS
.ft CW
	tabs(1, 5);
.ft R
.DE

The following sets tab stops to every 8 columns:
.DS
.ft CW
	tabs(1, 9);
.ft R
.DE
.Fo RETURN VALUE

Nothing.

.HU tan
tan(x)

.Fo RETURN VALUE

Returns the tangent of x (in radians) as a floating point
number.
.HU tanh
tanh(x)

.Fo RETURN VALUE

Returns the hyperbolic tangent of x as a floating point
number.
.HU time
time([hours], [mins], [sec])

.Fo DESCRIPTION

hours, mins and secs are optional integer variables which
receive the current time.

hours is a number in the range 0-23; mins is a number 0-59;
secs is a number 0-59.

.Fo EXAMPLES

The current time can be printed as such:

.DS
.ft CW
	int	hours, mins, secs;
	
	time(hours, mins, secs);
	message("Time now: %02d:%02d:%02d", hours, mins, secs);
.ft R
.DE
.Fo RETURN VALUE

Returns time in seconds measured from the \fIbase\fR date:
00:00:00 GMT Jan 1 1970 for Unix based systems.

.HU top_of_buffer
top_of_buffer()

.Fo DESCRIPTION

Moves the cursor to the start of line 1 in the current buffer.
.Fo RETURN VALUE

Returns non-zero if the cursor changed position; zero
otherwise.

.HU top_of_window
top_of_window()

.Fo DESCRIPTION

Moves the cursor to the start of the line displayed at the
top of the window.
.Fo RETURN VALUE

Returns non-zero if the cursor changed position; zero
otherwise.

.HU transfer
transfer(buf_id, start_line, start_col, end_line, end_col)

.Fo DESCRIPTION

This function is used to copy a block of text from one
buffer to another. buf_id is the buffer identifier of the
source buffer. start_line, start_col, end_line, and end_col
specify the bounds of the text to be copied.

The copied text is copied to the current buffer at the
current cursor position.

It is provided for compatability with BRIEF. It is usually
far easier to use the region macros.
.Fo RETURN VALUE

Returns zero or less if unsuccessful; zero if successful.

.HU translate
translate([pattern], [replacement], [global], [re], [case],
[block], [forward])

.Fo DESCRIPTION

This macro is used to perform string translations within the
current buffer. pattern is the string to translate. If re is
not specified or is non-zero, then pattern is treated as a
regular expression, otherwise it is treated as a normal
string. If case is not specified or is non-zero, then the
search is performed case insensitively. If block is
specified and is non-zero, then the search is limited to the
currently hilited region.

replacement is a string containing the string to replace
pattern with.

If global is specified and is non-zero, then every occurence
in the current buffer from the cursor to the end of the
buffer is translated. If global is zero, then only the first
occurence is translated. If global is not specified, then
the user is prompted for each change.

If pattern or replacement is not specified, then the user is
prompted for the change.

If is non-zero or omitted, then the translation is done in
the forwards direction, otherwise it will occur in the
backwards direction.
.Fo RETURN VALUE

Returns the number of translations.
.HU translate_pos
translate_pos(x, y, [win_id], [line], [col])

.Fo DESCRIPTION
This macro is designed to map an (x,y) co-ordinate pair into an actual
line/column position within a window. x and y are the co-ordinates as
returned from the get_mouse_position() primitive representing the
place where the mouse was hit. 

win_id is filled with the ID of the window upon which the (x,y) position
falls. If line and col are specified then these receive the line and
column positions within the buffer specified.

This function returns a code indicating what type of object the mouse
was hit on.
.Fo RETURN VALUE
The following returns are possible:
.P
.TS H
center allbox;
cB cB
l lw(4i).
Value	Meaning
=
.TH
0	Mouse not pressed inside or on any window (i.e. the status line).
1	Mouse pressed on left border of window.
2	Mouse pressed on right border of window.
3	Mouse pressed on top border of window.
4	Mouse pressed on bottom border of window.
5	Mouse pressed inside window.
6	Mouse pressed on window title.
.TE
.Fo SEE ALSO
get_mouse_position(), process_mouse()
.HU trim
trim(string, [delim])

.Fo DESCRIPTION

This function is used to remove trailing characters from the
specified string. The default is to remove all tabs, spaces
and newline characters. If delim is specified, then all
characters in the delim string are removed from the end of
string.
.Fo RETURN VALUE

Returns a copy of string with all trailing white space
characters removed. (spaces, tabs and newlines).

.HU typeof
typeof(expr)

.Fo DESCRIPTION

This macro is an alternative way to determine the current
type of a polymorphic variable.

.Fo RETURN VALUE

Returns one of the string constants, "NULL", "integer",
"float", "string", or "list" depending on the type of expr.
.HU umask
umask([mask])
.Fo DESCRIPTION
The umask() function is used to set and/or get the file creation mask.
The file creation mask is used when creating files. When a file is created
(via write_buffer() or write_block()) the umask is used to mask off certain
protection bits. The mask bits are operating system dependent but are
by and large the same from one system to another. For example, setting
the umask to 022 (octal) causes newly created files to be read and writable
by the owner but only readable by others and anyone in the same group.
.Fo RETURN VALUE
Returns the previous value of the mask.
.Fo SEE ALSO
write_buffer(), write_block()
.HU undo
undo([move], [write_mark], [redo])

.Fo DESCRIPTION

This is the macro used to undo buffer modifications. When
called with no arguments it undoes the last operation
performed on the buffer, e.g. move the cursor, insert deleted
text, unmark area, etc. If the previous operation on the
buffer was a macro, or a complex operation, e.g. global
translate, then all the buffer modifications performed are
undone in one step.

If move is specified and is non-zero, then the undo command
undoes all buffer operations back upto the last buffer
modification. If the last command was a buffer modification,
then setting move to non-zero is equivalent to not
specifying it. If the last few operations were simply cursor
movements, then move goes back to the last point in the
buffer where the buffer was actually modified.

There is a separate undo stack for each buffer. Normally
when a buffer is written away the undo stack is discarded so
that it is not possible to undo any operations performed on
the buffer before the last (write_buffer) operation. If
write_mark is specified and is non-zero, then this allows
the undo to go back past the last (write_buffer) mark.

Unlike BRIEF, it is possible to call (undo) from within a
macro, but its use their is highly dubious. It is normally
called by the user directly from one of the key assignments.

The redo parameter indicates whether a redo operation should
be performed. If it is specified then a redo is performed,
otherwise an undo is performed. A redo operation allows an
undo to be undone.
.Fo RETURN VALUE

Nothing.

.HU unregister_macro
unregister_macro(n, macro, [local])

.Fo DESCRIPTION

This macro is used to remove a macro which has been
registered for a particular trigger. (See (register_macro)
for a description of the triggers).

If a particular macro has been registered more than once
then (unregister_macro) should be called for each register
of the macro. (The return from (unregister_macro) can be
used in a loop).

If local is set to 1, then the macro will be unregistered
only if it was registered as a local macro. If it is omitted
or not equal to 1 then both the local and global registered
macro will be unregistered.

.Fo EXAMPLES

The following unregisters all occurences of a macro:

.DS
.ft CW
	while (unregister_macro(trigger, "macro_name") > 0)
		;
.ft R
.DE
.Fo RETURN VALUE

Zero if macro was not registered; 1 if macro was registered
and has now been unregistered.

.HU up
up([n])

.Fo DESCRIPTION

This macro moves the cursor to the previous line in the
buffer, maintaining the same column position. If n is
specified then the cursor is moved to the n'th previous or
n'th following (if n < 0) line.
.Fo RETURN VALUE

Nothing.

.HU upper
upper(string)

.Fo RETURN VALUE

Returns a copy of string with all lower case letters mapped
to their upper case equivalents.
.HU use_local_keyboard
use_local_keyboard(kbd_id)

.Fo DESCRIPTION

This macro is used to associate a keyboard map with the
current buffer. The local keyboard map takes precedence over
the global keyboard map. Whenever this buffer is selected,
the local keyboard map is searched for key bindings first;
if there is no key binding for the key typed by the user,
then the global keyboard map is searched as usual.

kbd_id is the identifier of the keyboard as returned via
\fIinq_keyboard()\fR. Specifying zero removes the local keyboard
and if necessary frees the memory associated with it if
there are no other references to the keyboard.

Local keyboards are usually used to effect things like
language sensitive editing modes, e.g. in C mode, the braces
\fB{\fR and \fB}\fR may be associated with a macro to perform C
style indenting; obviously it is not a good thing to perform
C style indenting on an nroff text buffer. Using local
keyboards avoids macros being complicated by having to check
the buffer type each time, and also make CRISP run faster.
.Fo RETURN VALUE

Returns 0 if operation successful; -1 if kbd_id is not a
valid keyboard id.

.HU use_tab_char
use_tab_char(yes)

.Fo DESCRIPTION

This macro allows the user to specify whether hard or soft
tabs should be used. yes is a string expression which should
be set to "y" if tabs are to be physically inserted into the
buffer; otherwise spaces are used instead to fill up to the
next tab stop.

If 'yes' is an integer expression then only the value of the
tab toggle is returned.

.Fo RETURN VALUE

Returns the previous value of the use tab char toggle.

.HU version
version([maj], [min], [edit])

.Fo DESCRIPTION

This macro is used to get the current version level. The
arguments are the names of integer variables which receive
the major, minor and edit level. If maj is not specified
then the version message is displayed on the command line.

Displays the current version on the status line.

.Fo RETURN VALUE

Returns the current version number * 100 plus the minor level.

.HU wait
wait([status])

.Fo DESCRIPTION

This macro waits for the process attached to the current
buffer to die. When the process dies, if status has been
specified (the name of an integer variable), then the exit
status of the process is placed in it.

This macro may be aborted by pressing a space.
.Fo RETURN VALUE

Returns -1 if there is no process attached to the current
buffer. -2 if user aborted the wait. Returns 0 if process
has died.

.HU wait_for
wait_for([timeout], expr)

.Fo DESCRIPTION

This macro is used to wait for a sequence of characters to
be output by the sub-process attached to the current buffer.
timeout specifies how long to wait (in seconds) and if
omitted or zero, the wait occurs indefinitely.

expr is either a string expression, representing a regular
expression of what is to be waited for, or a list of regular
expressions. If it is a list, then a parallel match is
performed as each character is read from the buffer. If any
of the atoms in the list (all string constants) match the
characters from the stream then (wait_for) terminates.

This macro is used by the various process control macros to
wait for magic strings, e.g. shell prompts.

.Fo EXAMPLES

See dial.cr and shell.cr for examples of how to use wait_for().
.Fo RETURN VALUE

Returns -1 if there is no process currently attached to the
current buffer, or user interrupted wait. Returns 1 if expr
is a string expression and the expression matched; returns n
if expr is a list and atom n matched.

.HU watch
(watch ...)

.Fo DESCRIPTION

This macro currently is a no-op. It is intended to allow
macros to be written which allow other macros to be
debugged. The idea is that a macro can monitor any variable
to see if it gets changed. The code does not exist, and the
ideas have not been thoroughly thought out yet.

This may be supported in a later version of CRISP if there
is sufficient demand.
.HU while
while (expr) stmt

.Fo DESCRIPTION

This macro is used to implement a while-loop. The expression
expr is evaluated and if non-zero, the statements 
are executed. Afterwards, expr is tested again. This
continues until either a (break) statement is encountered in
list, or the expression evaluates to false.
.HU window_color
window_color([color], [win_id])

.Fo DESCRIPTION

This macro is used to set the color of the background
associated with a window, and is used only when borders are
turned off.

color is the color to set. If it is not specified then the
old color is returned only. If win_id is specified then the
change is applied to the specified window.

This macro is currently not implemented.
.Fo RETURN VALUE

Returns previous background color of window.
.Fo SEE ALSO
inq_window_color()
.HU write_block
write_block([filename], [append], [keep-region], [pause])

.Fo DESCRIPTION

This macro is used to write out the currently marked region
to a file. If filename is not specified, then it is prompted
for.

Writing out a marked region does not affect the backup flag
or the undo information flag. (See (undo), (set_backup)).

If keep-region is not specified or is zero, then the current
anchor is raised. Otherwise it is left alone, e.g. so that
you can delete the region afterwards.

If append is specified and is non-zero, then the marked area
is appended to the file.

If the filename starts with a '|' character then the data is
written to a pipe (via popen()) instead of a file. The data
after the '|' is passed as an argument to the popen() call.
When writing the block to a command, the command may destroy
the screen by writing to stdout or stderr. If this is the
case, then the pause parameter can be used to force the
screen to be redrawn after execution. If not-specified or is
non-zero then the user is prompted to hit <Enter> before
continuing.

If the filename starts with either the '>' or '>>' characters then
the region is appended to the specified file. (The leading '>' or '>>'
are removed).

This primitive knows how to correctly write out a column
marked region.
.Fo RETURN VALUE

Zero or less if the macro was unsuccessful. Greater than
zero if the write was successful.

.HU write_buffer
write_buffer([filename], [append])

.Fo DESCRIPTION

This macro is used to write out the contents of the current
buffer to a file. If filename is omitted then the file is
written to the filename associated with the current buffer
(i.e. as specified via create_buffer). Otherwise filename is
used.

If this is the first time that write_buffer has been called
for this buffer, then a backup copy of the file will be
made. (See the section on making backups for a discussion of
the algorithm used). Subsequent calls to write_buffer do not
create backups.

If append is specified and is non-zero, then the output file
is appended to.

.Fo RETURN VALUE

Returns zero if file saved (or no modifications were made); returns
-1 if an error occurred during saving.


