/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	mnucel.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_menu_cell class header
 *
 *	RCSid = "$Id: mnucel.H,v 4.18.1.1 1993/06/01 22:55:39 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_mnucel_H
#define OI_mnucel_H

#ifndef OI_wldtech_H
#include <OI/wldtech.H>
#endif /* OI_wldtech_H */

#define OI_DEFAULT_MAPPING_DELAY 180	/* ms to wait before popping up a motif submenu */

	// class forward reference declaration
	class	OI_mdl_menu_cell;
	class	OI_basic_menu;
	class	OI_menu;
	class	OI_menu_cell;
	class	OI_tabstops;
	struct	OI_menu_spec;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		


#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_action_fn)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
	typedef	void	(OI_callback::OI_action_memfn)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_action_fnp)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
	typedef	void	(OI_callback::*OI_action_memfnp)(OI_menu_cell *cellp, void *argp, OI_number btn) ;

#ifdef CPLUSPLUS20
#define OI_ACTION_MEMFN_CAST(mfn)	/*(OI_action_memfnp)*/(mfn)
#else
#define OI_ACTION_MEMFN_CAST(mfn)	(OI_action_memfnp)(mfn)
#endif

 /* generic structure used for objects which build menus */
		struct	OI_cell_spec	{
			const	char			*namp ;		/* ptr to name string for cell */
			const	char			*labelp ;	/* ptr to string for cell label */
				OI_action_fnp		fnp ;		/* function to execute when cell fires */
				OI_callback		*objp ;		/* ptr to user object if callback is a C++ member function */
				OI_action_memfnp	memfnp ;	/* member function to execute when cell fires */
				void			*argp ;		/* ptr to user arg to pass to callback */
				OI_menu_cell_type	type;		/* Icon type as defined in defs.H */
			struct	OI_menu_spec		*menu_ptr;	/* Pointer to walking menu */
				OI_number		wid ;		/* width of pixmap */
				OI_number		ht ;		/* height of pixmap */
				OI_number		dpth ;		/* depth of pixmap */
				unsigned long		ctl_bits ;	/* control bits: OI_cell_select, OI_cell_default, OI_cell_subbox */
				OI_gravity		gr ;		/* gravity for cell */
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

#		define		OI_CELL_SUBMENU_SIZ	8		/* size of submenu box */
#		define		OI_CELL_SUBBOX_SIZ	10		/**/
#		define		OI_CELL_SUBBOX_WIDTH	10		/* size of subitem box */
#		define		OI_CELL_SUBBOX_HEIGHT	2		/* size of subitem box */
#		define		OI_CELL_SUBBOX_OFF	2		/* offset of subitem box from end of basic_stuff */
#		define		OI_CELL_SUBMENU_OFF	10		/* offset of subitem box from end of basic_stuff */
#		define		OI_CELL_ACCLBL_OFF	20		/* offset of accelerator label from end of basic_stuff */
 /* ctl_bits */
#		define		OI_cell_select		0x2L		/* cell is selected */
#		define		OI_CELL_SELECT		OI_cell_select
#		define		OI_cell_default		0x4L		/* cell is default choice for menu */
#		define		OI_CELL_DEFAULT		OI_cell_default
#		define		OI_CELL_PERSISTENT	0x8L		/* cell stays on when selected */
#		define		OI_CELL_EXCLUSIVE	0x10L		/* cell must be on by itself */
#		define		OI_CELL_HI_CROSSING	0x100L		/* on entry/exit into cell */
#		define		OI_CELL_HI_BUTTON	0x200L		/* on button press/release */
#		define		OI_CELL_HI_SELECT	0x400L		/* on select() call */
#		define		OI_CELL_PAINTED		0x800L		/* cell has been painted (cleared when 0 count expose event comes in */
#		define		OI_cell_submenu		0x1000L		/* cell has submenu */
#		define		OI_CELL_SUBMENU		OI_cell_submenu
#		define		OI_cell_subbox		0x2000L		/* cell has sub dialog box */
#		define		OI_CELL_SUBBOX		OI_cell_subbox
#		define		OI_CELL_BUSY		0x4000L		/* cell needs to be painted busy */
#		define		OI_CELL_NO_PULLDOWN	0x8000L		/* cell is a button, not a pull down handle (hint used by dialog boxes) */
#		define		OI_CELL_PREV_SELECT	0x10000L	/* cell was selected before new selection started. */
#		define		OI_CELL_REMOVE_CALLBACK	0x20000L	/* remove the callback if there is ever a child of this cell */
#		define		OI_CELL_NO_LIFT		0x40000L	/* do not execute lift_object */
#		define		OI_CELL_NO_PLACE	0x80000L	/* do not execute place_object */
#		define		OI_CELL_PAINTED_ONCE	0x100000L	/* cell has been painted once, OK to enable translations */
#		define		OI_CELL_TIMER_ACTIVE	0x200000L	/* the pulldown/right timer is active */


	class OI_menu_cell : public OI_wl_d_tech {
			OI_mdl_menu_cell	*mdl_dep ;	/* ptr to model dependent aspects of OI_box object */
			/**********************************************************************
			 * menu_cell resources 
			 **********************************************************************/
			OI_string               *plylbl;	/* label for menu_cell */
			OI_string		*acclbl;	/* accelerator label for menu_cell */
			OI_string		*mnlbl;		/* mnemonic label for menu cell */
			char                    *lbltxt;	/* pointer to encoded text string for label */
			char			*acclbltxt;	/* pointer of encoded text string for accelerator label */
			char			*mnlbltxt;	/* pointer of encoded text string for mnemonic label */
			/**********************************************************************
			 * end of menu_cell resources
			 **********************************************************************/
			unsigned long		ctl_bits ;	/* control bits */
			OI_menu_cell_type	typ;		/* cell type (OI_text_cell,OI_ICON_CELL,OI_ICON_DATA_CELL,OI_PIXMAP_CELL) */
			OI_xy			basic_siz ;	/* Spacing required for text or pixmap */
			OI_xy			basic_loc ;	/* location of upper left corner of text or pixmap */
			OI_xy			box_loc ;	/* location of sub item activator box */
			OI_xy			box_siz ;	/* size of sub item activator box */
			OI_xy			acclbl_loc ;	/* location of accelerator label */
			OI_xy			mnlbl_loc ;	/* location of mnemonic label */
			OI_number		num ;		/* cell number in menu */
			OI_number		top_xtra,bottom_xtra,left_xtra,right_xtra ;	/* decoration space added for each cell */
			OI_menu_cell		*actual_fire;
		 public:
		static	OI_class		*clsp ;			/* ptr to class record */
		static	XrmQuark		q_cbCellAction ;	/* quark for cell fire callback */
		static	XrmQuark		q_cbPrePopup ;		/* quark for submenu prepopup callback */
		
		 private:
			void		configure_subitem(unsigned long) ;			/* (un)configure for fake dialogbox/pulldown */
			char		*get_text( OI_string *, char **, OI_char_encode_type) ;
			char		*res_get_accelerator_label();
			char		*res_get_label();
			char		*res_get_mnemonic_label();
		virtual	void		new_accelerators(OI_translation_table *);
		virtual	void		new_mnemonics(OI_translation_table *);
			void		res_set_accelerator_label(void *);
			void		res_set_label(void *);
			void		res_mapping_delay(void *);
			void		res_set_mnemonic_label(void *);
			void		res_set_default(void *);				/* callback for default cell resource */
			void		construct(const char*, const char*, OI_action_fnp, OI_callback*, OI_action_memfnp, void*,
						OI_menu_cell_type, struct OI_menu_spec *, OI_number, OI_number, OI_number, unsigned long,
						OI_gravity) ;
 		virtual	void		font_resize() ;
		friend	void		dmpOI_menu_cell(OI_menu_cell*) ;

		protected:
					OI_menu_cell(OI_class*, const char*, const char*, OI_action_fnp=NULL, OI_callback* =NULL,
						OI_action_memfnp=NULL, void* =NULL, OI_menu_cell_type=OI_text_cell,
						struct OI_menu_spec* =NULL, OI_number=0, OI_number=0, OI_number=0, unsigned long=0,
						OI_gravity=OI_grav_unknown) ;
		virtual	void		new_model(OI_model_type) ;
		public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_menu_cell(const char*, const char*, OI_action_fnp=NULL, OI_callback* =NULL,
						OI_action_memfnp=NULL, void* =NULL, OI_menu_cell_type=OI_text_cell,
						struct OI_menu_spec* =NULL, OI_number=0, OI_number=0, OI_number=0, unsigned long=0,
						OI_gravity=OI_grav_unknown);
					~OI_menu_cell() ;

			char		*accelerator_label() ;
			OI_number	accelerator_label_loc_x()	{ return(acclbl_loc.x); }
			OI_number	accelerator_label_loc_y()	{ return(acclbl_loc.y); }
			OI_number	accelerator_label_size() ;
		virtual	void		allow_click_to_type();
			void		allow_default() ;
			void		allow_lift_object()		{ctl_bits &= ~OI_CELL_NO_LIFT;}
			void		allow_painted_once()		{ctl_bits |= OI_CELL_PAINTED_ONCE;}
			void		allow_place_object()		{ctl_bits &= ~OI_CELL_NO_PLACE;}
			void		allow_pulldown()		{ctl_bits &= ~OI_CELL_NO_PULLDOWN;}
			void		allow_remove_callback()		{ctl_bits |= OI_CELL_REMOVE_CALLBACK; }
			void		allow_timer_active()		{ctl_bits |= OI_CELL_TIMER_ACTIVE; }
			OI_number	basic_loc_x()			{ return(basic_loc.x); }
			OI_number	basic_loc_y()			{ return(basic_loc.y); }
			OI_number	basic_size_x()			{ return(basic_siz.x); }
			OI_number	basic_size_y()			{ return(basic_siz.y); }
		virtual	PIXEL		bkg_paint_pixel();	
			OI_number	bottom_extra()			{ return(bottom_xtra); }
			OI_number	box_loc_x()			{ return(box_loc.x); }
			OI_number	box_loc_y()			{ return(box_loc.y); }
			OI_number	box_off_x()			{ return((ctl_bits&(OI_cell_subbox|OI_cell_submenu)) ?
										OI_CELL_SUBBOX_OFF : 0); }
			OI_number	box_size_x()			{ return(box_siz.x); }
			OI_number	box_size_y()			{ return(box_siz.y); }
			OI_menu_cell_type	cell_type()		{return(typ);}
			void		clear_painted()			{ctl_bits &= ~OI_CELL_PAINTED;}
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	void		clone_adjust_after_descendants(OI_d_tech*) ;
		virtual	OI_number	column_position();
			void		disallow_default() ;
			void		disallow_lift_object()		{ctl_bits |= OI_CELL_NO_LIFT;}
			void		disallow_painted_once()		{ctl_bits &= ~OI_CELL_PAINTED_ONCE;}
			void		disallow_place_object()		{ctl_bits |= OI_CELL_NO_PLACE;}
			void		disallow_pulldown()		{ctl_bits |= OI_CELL_NO_PULLDOWN;}
			void		disallow_remove_callback()	{ctl_bits &= ~OI_CELL_REMOVE_CALLBACK; }
			void		disallow_timer_active()		{ctl_bits &= ~OI_CELL_TIMER_ACTIVE; }
			void		dragdrop_start(OI_dnd_operation, const	XEvent*);
			void		drag_preview(OI_d_tech*, void *, OI_dnd_operation op, long, long);
		virtual	void		enable_translations(OI_translation_table *);
		virtual	PIXEL		fg_paint_pixel();	
		virtual	PIXEL		fg_reverse_paint_pixel();	
		virtual	void		get_resources();					/* get resources for this object */
//			void		hilite(unsigned long) ;					/* hilite using current hilight parameters */
			OI_bool		in_submenu(OI_number,OI_number) ;			/* chk if position is in submenu area */
		static	OI_bool		init(OI_connection*) ;
			OI_bool		is_busy()			{ return((OI_bool) ((ctl_bits & OI_CELL_BUSY) !=0)); }
			OI_bool		is_default()			{ return(OI_bool)((ctl_bits & OI_cell_default) != 0); }
			OI_bool		is_lift_object()		{ return(((ctl_bits&OI_CELL_NO_LIFT)?OI_no:OI_yes)); }
			OI_bool		is_menu_cell();
			OI_bool		is_painted_once()		{ return(((ctl_bits&OI_CELL_PAINTED_ONCE)?OI_yes:OI_no)); }
			OI_bool		is_place_object()		{ return(((ctl_bits&OI_CELL_NO_PLACE)?OI_no:OI_yes)); }
			OI_bool		is_prev_select()		{ return((OI_bool)((ctl_bits & OI_CELL_PREV_SELECT) != 0)); }
			OI_bool		is_pulldown() ;
			OI_bool		is_remove_callback()		{ return ((OI_bool)(ctl_bits&OI_CELL_REMOVE_CALLBACK)?OI_yes:OI_no); }
			OI_bool		is_timer_active()		{ return ((ctl_bits&OI_CELL_TIMER_ACTIVE)?OI_yes:OI_no); }
			OI_bool		is_separator_cell()		{ return ( typ == OI_SEPARATOR_CELL ? OI_yes : OI_no ); }
		virtual	OI_bool		is_write_resq(XrmQuark);
			OI_number	left_extra()			{ return(left_xtra); }
		virtual	void		lift_object(long, long, int, int);			/* remove the object from the display */
			void		made_visible();			// the cell was made visible
		static	OI_menu_cell	*make_minimal(const char*,enum OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			char		*mnemonic_label() ;
			OI_number	mnemonic_label_loc_x()		{ return(mnlbl_loc.x); }
			OI_number	mnemonic_label_loc_y()		{ return(mnlbl_loc.y); }
			OI_number	mnemonic_label_size() ;
			OI_stat		new_accelerator_label(const char*,OI_char_encode_type) ;
			void		new_allow_subbox();
			void		new_disallow_subbox();
			void		new_allow_submenu();
  			void		new_bkg_pixmap(OI_pixmap *) ;
		virtual	void		new_bkg_pixel(PIXEL, OI_bool=OI_no) ;			/* change background pixel generically */
		virtual	void		new_bdr_pixel(PIXEL, OI_bool=OI_no) ;			/* change window border pixel generically */
			void		new_bdr_width(OI_number);
			void		new_bottom_pixel(PIXEL, OI_bool=OI_no) ;		/* change bottom bevel pixel generically */
		virtual void		new_bvl_width(OI_number);
			void		new_disallow_submenu();
			void		new_down_pixel(PIXEL, OI_bool=OI_no) ;			/* change down pixel generically */
		virtual	void		new_fg_pixel(PIXEL, OI_bool=OI_no) ;			/* change foreground pixel generically */
		virtual void		new_font(OI_font *, OI_charset=OI_charset_latin1);	/* change font generically */
			OI_stat		new_label(const char*,OI_char_encode_type) ;			/* set new label for cell */
			void		new_mapping_delay(OI_number);
			OI_stat		new_mnemonic_label(const char*,OI_char_encode_type) ;
		virtual	void		new_pixels(PIXEL,PIXEL,PIXEL, OI_bool=OI_no) ;
			void		new_top_pixel(PIXEL, OI_bool=OI_no) ;			/* change top bevel pixel generically */
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
			OI_menu		*outside_menu();					/* return outside menu of this cell. */
		virtual	void		paint(const XEvent*, void* =NULL) ;
			void		paint_unadorned(Window,OI_number,OI_number) ;		/* paint without menu specific decorations */
			void		paint_busy(int, int, int, int);
			void		paint_common(Window,OI_number,OI_number, OI_string *, int) ;	/* paint common stuff */
			unsigned long	painted()			{return(ctl_bits&OI_CELL_PAINTED);}
			OI_menu		*parent_menu();
			Pixmap		pixmap() ;
		virtual	void		place_object(long, long, int, int);			/* put the object in a new location */
			OI_string	*ply_accelerator_label()	{ return (acclbl); }
			OI_string       *ply_label()            	{ return (plylbl); }
			OI_string	*ply_mnemonic_label()		{ return (mnlbl); }
		virtual	void		post_get_resources();
		virtual	void		post_paint();
		virtual	void		pre_paint();
			void		pre_popup();
			OI_number	right_extra()			{ return(right_xtra); }
			void		res_select(void *);					/* resource setting callback */
			void		res_separator(void *);					/* resource setting callback */
			void		res_subbox(void *);					/* resource setting callback */
			void		res_submenu(void *);					/* resource setting callback */
			void		resize_cell(OI_basic_menu *);				/* resize a cell and possibly the menu */
		virtual	OI_number	row_position();
			void		run(OI_bool=OI_yes) ;					/* fire the cell */
			OI_number	separator_width() ;
			void		sel(OI_bool=OI_yes) ;					/* put cell in selected state */
			void		set_accelerator_label_loc_x(OI_number x)	{ acclbl_loc.x = x; }
			void		set_accelerator_label_loc_y(OI_number y)	{ acclbl_loc.y = y; }
			void		set_basic_loc_x(OI_number x)	{ basic_loc.x=x; }
			void		set_basic_loc_y(OI_number y)	{ basic_loc.y=y; }
			void		set_basic_size_x(OI_number x)	{ basic_siz.x=x; }
			void		set_basic_size_y(OI_number y)	{ basic_siz.y=y; }
			void		set_box_loc_x(OI_number x)	{ box_loc.x=x; }
			void		set_box_loc_y(OI_number y)	{ box_loc.y=y; }
			void		set_box_size_x(OI_number x)	{ box_siz.x=x; }
			void		set_box_size_y(OI_number y)	{ box_siz.y=y; }
			void		set_busy(OI_bool=OI_yes) ;
			void		set_mnemonic_label_loc_x(OI_number x)	{ mnlbl_loc.x = x; }
			void		set_mnemonic_label_loc_y(OI_number y)	{ mnlbl_loc.y = y; }
			void		set_number(OI_number n)		{ num=n; }
			void		set_painted()			{ctl_bits |= OI_CELL_PAINTED;}
			void		set_prev_select(OI_bool s) ;
			void		set_tabstops(OI_tabstops *) ;
			void		set_xtra(OI_number tp, OI_number bt, OI_number lf, OI_number rt) ;
			OI_d_tech	*sub_item()			{return(nprop ? *propp : NULL);}
			OI_number	top_extra()			{ return(top_xtra); }
			OI_menu_cell	*traverse_up();
			OI_menu_cell	*traverse_down();
			OI_menu_cell	*traverse_left();
			OI_menu_cell	*traverse_right();
			void		unsel(OI_bool=OI_yes) ;					/* remove cell from selected state */
			void		unset_busy(OI_bool=OI_yes) ;
		virtual	OI_d_tech	*val_assoc(OI_d_tech *) ;
			void		val_unparent(OI_d_tech *) ;

 		virtual	void		focus_in(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 		virtual	void		focus_out(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
		virtual	void		set_focus_next_tab(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to next obj. */
		virtual	void		set_focus_prev_tab(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to previous obj. */
 			void		select_key(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		adjust(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		button_press(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		button_release(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		button_motion(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		activate(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
 			void		deactivate(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		enter(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		leave(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		up(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		down(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		left(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		right(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		cancel(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		control(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);
 			void		menu_key(OI_d_tech *, const XEvent *ep, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_stat		add_to_layout(OI_number,OI_number) ;			/* convert child to laid out object */
		virtual	OI_stat		add_to_layout(void*,void*) ;				/* convert child to laid out object */
		virtual	void		drag_copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_move_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;
		virtual	OI_bool		is_acceptable_parent(OI_d_tech*) ;
		virtual	OI_stat		layout_associated_object(OI_d_tech*,OI_number,OI_number,OI_state=OI_SAME) ;
		virtual	OI_stat		layout_associated_object(OI_d_tech*,void*,void*,OI_state=OI_SAME) ;
		virtual	OI_stat		set_associated_object(OI_d_tech*,long=OI_DEF_LOC,long=OI_DEF_LOC,OI_state=OI_SAME) ;
			OI_stat		set_state(OI_state) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			fire(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			display_submenu(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		add_subtree(OI_menu_cell*, void*, OI_number);
			void		allow_subbox() ;					/* set fake dialog box on cell */
			void		allow_submenu() ;
			void		change_action(OI_action_fnp fp, void *arg =NULL) ;
			void		change_action(OI_callback *objp, OI_action_memfnp mfp, void *arg =NULL) ;
			void		change_arg(void *arg) ;
			void		disallow_subbox() ;
			void		disallow_submenu() ;
			OI_action_fnp		get_action() ;
			OI_action_memfnp	get_action_memfn() ;
			void		*get_arg() ;
			OI_callback	*get_obj() ;
			OI_bool		is_subbox()			{return((ctl_bits&OI_cell_subbox)?OI_yes:OI_no);}
			OI_bool		is_submenu()			{return((OI_bool) ((ctl_bits&OI_cell_submenu) != 0));}
												/* does submenu exist? */
			char		*label() ;
			OI_number       length() ;						/* get length of label */
			OI_number	mapping_delay();
			OI_number	number()			{return(num);}		/* get cell number, 0-n */
			void		select(OI_bool ans, OI_bool=OI_yes) ;
			OI_bool		selected()			{return((OI_bool) ((ctl_bits&OI_cell_select) != 0));}
												/* chk if selected */
			OI_stat		set_accelerator_label(const char*) ;
			OI_stat		set_default() ;						/* establish this cell as default */
			OI_stat		set_label(const char*) ;					/* set new label for cell */
			OI_stat         set_label_char(OI_number p, char c) ;			/* set a single char in cell label */
			OI_stat		set_label_chars(OI_number p, OI_number n, const char*) ;	/* change substring in cell label */
			void		set_mapping_delay(OI_number);
			OI_stat		set_mnemonic_label(const char*) ;
			void		set_pre_popup(OI_pre_popup_fnp, void* =NULL) ;
			void		set_pre_popup(OI_callback*, OI_pre_popup_memfnp, void * =NULL) ;

	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_menu_cell	*oi_create_menu_cell_cb(const char *, const char *, OI_action_fnp, OI_callback *, OI_action_memfnp, void *,
					OI_menu_cell_type, OI_menu_spec *, OI_number, OI_number, OI_number, unsigned long, OI_gravity) ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	inline	OI_menu_cell	*oi_create_menu_cell(const char *name, const char *lbl, OI_action_fnp fp =NULL, void *argp=NULL,
					OI_menu_cell_type ct=OI_text_cell, OI_menu_spec *msp=NULL,
					OI_number w=0, OI_number h=0, OI_number d=0, unsigned long ctl=0, OI_gravity gr=OI_grav_unknown)
						{return oi_create_menu_cell_cb(name,lbl,(OI_action_fnp)fp,NULL,NULL,argp,ct,msp,w,h,d,
							ctl,gr);}
	inline	OI_menu_cell	*oi_create_menu_cell(const char *name, const char *lbl, OI_callback *objp, OI_action_memfnp mfp,
					void *argp=NULL, OI_menu_cell_type ct=OI_text_cell, OI_menu_spec *msp=NULL,
					OI_number w=0, OI_number h=0, OI_number d=0, unsigned long ctl=0, OI_gravity gr=OI_grav_unknown)
						{return oi_create_menu_cell_cb(name,lbl,NULL,objp,(OI_action_memfnp)mfp,argp,ct,msp,w,h,d,
							ctl,gr);}

#define	OI_n_cells(array)	(sizeof(array)/sizeof(array[0]))	/* ~OIc */

#endif /* OI_mnucel_H */
